/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.support.color;

import java.awt.Color;

public final class RGBA {
    public static final RGBA white = new RGBA(Color.white);
    public static final RGBA WHITE = new RGBA(Color.WHITE);
    public static final RGBA lightGray = new RGBA(Color.lightGray);
    public static final RGBA LIGHT_GRAY = new RGBA(Color.LIGHT_GRAY);
    public static final RGBA gray = new RGBA(Color.gray);
    public static final RGBA GRAY = new RGBA(Color.GRAY);
    public static final RGBA darkGray = new RGBA(Color.darkGray);
    public static final RGBA DARK_GRAY = new RGBA(Color.DARK_GRAY);
    public static final RGBA black = new RGBA(Color.black);
    public static final RGBA BLACK = new RGBA(Color.BLACK);
    public static final RGBA red = new RGBA(Color.red);
    public static final RGBA RED = new RGBA(Color.RED);
    public static final RGBA pink = new RGBA(Color.pink);
    public static final RGBA PINK = new RGBA(Color.PINK);
    public static final RGBA orange = new RGBA(Color.orange);
    public static final RGBA ORANGE = new RGBA(Color.ORANGE);
    public static final RGBA yellow = new RGBA(Color.yellow);
    public static final RGBA YELLOW = new RGBA(Color.YELLOW);
    public static final RGBA green = new RGBA(Color.green);
    public static final RGBA GREEN = new RGBA(Color.GREEN);
    public static final RGBA magenta = new RGBA(Color.magenta);
    public static final RGBA MAGENTA = new RGBA(Color.MAGENTA);
    public static final RGBA cyan = new RGBA(Color.cyan);
    public static final RGBA CYAN = new RGBA(Color.CYAN);
    public static final RGBA blue = new RGBA(Color.blue);
    public static final RGBA BLUE = new RGBA(Color.BLUE);
    public final float r;
    public final float g;
    public final float b;
    public final float a;

    public RGBA(float r, float g, float b, float a) {
        this.r = r;
        this.g = g;
        this.b = b;
        this.a = a;
    }

    public RGBA(RGBA rgba) {
        this.r = rgba.r;
        this.g = rgba.g;
        this.b = rgba.b;
        this.a = rgba.a;
    }

    public RGBA(float[] rgba) {
        this.r = rgba[0];
        this.g = rgba[1];
        this.b = rgba[2];
        this.a = rgba[3];
    }

    public RGBA(float[] rgb, float a) {
        this.r = rgb[0];
        this.g = rgb[1];
        this.b = rgb[2];
        this.a = a;
    }

    public RGBA(Color color) {
        float[] rgba = color.getRGBComponents(null);
        this.r = rgba[0];
        this.g = rgba[1];
        this.b = rgba[2];
        this.a = rgba[3];
    }

    public static final RGBA fromIntRGBA(int r, int g, int b, int a) {
        return new RGBA((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public static final RGBA fromIntRGB(int r, int g, int b) {
        return new RGBA((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 1.0f);
    }

    public static final RGBA fromHsb(float hue, float saturation, float brightness, float alpha) {
        saturation = Math.min(1.0f, Math.max(0.0f, saturation));
        brightness = Math.min(1.0f, Math.max(0.0f, brightness));
        if (saturation == 0.0f) {
            return new RGBA(brightness, brightness, brightness, 1.0f);
        }
        float h = (hue - (float)Math.floor(hue)) * 6.0f;
        float f = h - (float)Math.floor(h);
        float p = brightness * (1.0f - saturation);
        float q = brightness * (1.0f - saturation * f);
        float t = brightness * (1.0f - saturation * (1.0f - f));
        float r = 0.0f;
        float g = 0.0f;
        float b = 0.0f;
        switch ((int)h) {
            case 0: {
                r = brightness;
                g = t;
                b = p;
                break;
            }
            case 1: {
                r = q;
                g = brightness;
                b = p;
                break;
            }
            case 2: {
                r = p;
                g = brightness;
                b = t;
                break;
            }
            case 3: {
                r = p;
                g = q;
                b = brightness;
                break;
            }
            case 4: {
                r = t;
                g = p;
                b = brightness;
                break;
            }
            case 5: {
                r = brightness;
                g = p;
                b = q;
            }
        }
        return new RGBA(r, g, b, alpha);
    }

    public final int getIntRed() {
        return (int)(this.r * 255.0f + 0.5f);
    }

    public final int getIntGreen() {
        return (int)(this.g * 255.0f + 0.5f);
    }

    public final int getIntBlue() {
        return (int)(this.b * 255.0f + 0.5f);
    }

    public final int getIntAlpha() {
        return (int)(this.a * 255.0f + 0.5f);
    }

    public final RGBA withAlpha(float a) {
        return new RGBA(this.r, this.g, this.b, a);
    }

    public final RGBA withIntAlpha(int a) {
        return new RGBA(this.r, this.g, this.b, (float)a / 255.0f);
    }

    public final boolean isTransparent() {
        return this.a < 1.0f;
    }

    public final float[] toFloat4() {
        return new float[]{this.r, this.g, this.b, this.a};
    }

    public final float[] toFloat3() {
        return new float[]{this.r, this.g, this.b};
    }

    public final int[] toInt4() {
        return new int[]{this.getIntRed(), this.getIntGreen(), this.getIntBlue(), this.getIntAlpha()};
    }

    public final int[] toInt3() {
        return new int[]{this.getIntRed(), this.getIntGreen(), this.getIntBlue()};
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.a);
        result = 31 * result + Float.floatToIntBits(this.b);
        result = 31 * result + Float.floatToIntBits(this.g);
        result = 31 * result + Float.floatToIntBits(this.r);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RGBA other = (RGBA)obj;
        if (Float.floatToIntBits(this.a) != Float.floatToIntBits(other.a)) {
            return false;
        }
        if (Float.floatToIntBits(this.b) != Float.floatToIntBits(other.b)) {
            return false;
        }
        if (Float.floatToIntBits(this.g) != Float.floatToIntBits(other.g)) {
            return false;
        }
        return Float.floatToIntBits(this.r) == Float.floatToIntBits(other.r);
    }
}

