/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.painter;

import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.plot.stacked.StackedPlot2D;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;
import com.metsci.glimpse.plot.timeline.painter.SimpleSelectedTimeRegionPainter;
import com.metsci.glimpse.support.color.GlimpseColor;
import java.awt.geom.Rectangle2D;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class SelectedTimeRegionPainter
extends SimpleSelectedTimeRegionPainter {
    protected StackedTimePlot2D plot;
    protected boolean showLockedStatus = true;

    public SelectedTimeRegionPainter(StackedTimePlot2D plot) {
        super(plot.getOrientation());
        this.plot = plot;
    }

    public void setShowLockedStatus(boolean show) {
        this.showLockedStatus = show;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paint(GL gl, TaggedAxis1D taggedAxis, List<Tag> tags, float min, float max, float current, int width, int height) {
        super.paint(gl, taggedAxis, tags, min, max, current, width, height);
        if (this.plot.isLocked() && this.showLockedStatus) {
            String text = "LOCKED";
            int value = taggedAxis.valueToScreenPixel(current);
            Rectangle2D textbounds = this.textRenderer.getBounds(text);
            GlimpseColor.setColor(this.textRenderer, this.selectionBorderColor);
            this.textRenderer.beginRendering(width, height);
            try {
                if (this.orientation == StackedPlot2D.Orientation.VERTICAL) {
                    this.textRenderer.draw(text, (int)((double)value - textbounds.getWidth() - 3.0), 3);
                } else {
                    this.textRenderer.draw(text, 3, (int)((double)value - textbounds.getHeight() - 3.0));
                }
            }
            finally {
                this.textRenderer.endRendering();
            }
        }
    }

    @Override
    public void dispose(GLContext context) {
    }
}

