/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.listener;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.axis.tagged.TaggedAxisMouseListener1D;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.ModifierKey;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;
import java.util.List;

public class TimeAxisMouseListener1D
extends TaggedAxisMouseListener1D {
    protected boolean onlyMoveCurrent = false;
    protected StackedTimePlot2D plot;

    public TimeAxisMouseListener1D(StackedTimePlot2D plot) {
        super(25);
        this.plot = plot;
    }

    public Tag getSelectedTag() {
        return this.selectedTag;
    }

    @Override
    public void mousePressed(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        this.updateTagSelection(e, axis, horizontal);
        if (this.allowSelectionLock && e.isButtonDown(MouseButton.Button3)) {
            if (this.plot.isCurrentTimeLocked() || this.plot.isSelectionLocked()) {
                this.plot.setCurrentTimeLocked(false);
                this.plot.setSelectionLocked(false);
            } else {
                this.plot.setSelectionLocked(!this.plot.isSelectionLocked());
            }
        }
    }

    @Override
    protected Tag getSelectedTag(TaggedAxis1D taggedAxis, List<Tag> tags, int mousePos, int maxPixelDist) {
        Tag minTag = taggedAxis.getTag("min_time");
        Tag maxTag = taggedAxis.getTag("max_time");
        Tag currentTag = taggedAxis.getTag("current_time");
        double maxDistance = (double)maxPixelDist / taggedAxis.getPixelsPerValue();
        double mouseValue = taggedAxis.screenPixelToValue(mousePos);
        boolean closeToMin = Math.abs(mouseValue - minTag.getValue()) < maxDistance;
        boolean closeToMax = Math.abs(mouseValue - maxTag.getValue()) < maxDistance;
        Tag selectedTag = null;
        if (closeToMin) {
            selectedTag = minTag;
        } else if (closeToMax) {
            selectedTag = maxTag;
        } else if (Math.abs(mouseValue - currentTag.getValue()) < maxDistance) {
            selectedTag = currentTag;
        }
        return selectedTag;
    }

    @Override
    public void mouseMoved(GlimpseMouseEvent e, Axis1D axis, boolean horizontal) {
        TaggedAxis1D taggedAxis = (TaggedAxis1D)axis;
        if (e.isKeyDown(ModifierKey.Ctrl) && e.isButtonDown(MouseButton.Button1) && this.selectedTag != null) {
            this.tagDragged(e, taggedAxis, horizontal);
        } else if (e.isButtonDown(MouseButton.Button1) && !this.plot.isCurrentTimeLocked()) {
            this.mouseDragged(e, taggedAxis, horizontal);
        } else if (!this.plot.isSelectionLocked() && !this.plot.isCurrentTimeLocked()) {
            this.mouseHovered(e, taggedAxis, horizontal);
        }
        this.mouseMoved0(e, taggedAxis, horizontal);
    }

    protected void mouseMoved0(GlimpseMouseEvent e, TaggedAxis1D taggedAxis, boolean horizontal) {
    }

    protected void tagDragged(GlimpseMouseEvent e, TaggedAxis1D taggedAxis, boolean horizontal) {
        this.anchor(taggedAxis, horizontal, e.getX(), e.getY());
        int mousePosPixels = this.getDim(horizontal, e.getX(), taggedAxis.getSizePixels() - e.getY());
        int panPixels = this.getDim(horizontal, this.anchorPixelsX, this.anchorPixelsY) - mousePosPixels;
        double panValue = (double)panPixels / taggedAxis.getPixelsPerValue();
        double newTagValue = this.tagAnchor - panValue;
        this.selectedTag.setValue(newTagValue);
    }

    protected void mouseDragged(GlimpseMouseEvent e, TaggedAxis1D taggedAxis, boolean horizontal) {
        this.pan(taggedAxis, horizontal, e.getX(), e.getY());
    }

    protected void mouseHovered(GlimpseMouseEvent e, TaggedAxis1D taggedAxis, boolean horizontal) {
        Tag minTag = taggedAxis.getTag("min_time");
        Tag maxTag = taggedAxis.getTag("max_time");
        Tag currentTag = taggedAxis.getTag("current_time");
        int mousePosPixels = this.getDim(horizontal, e.getX(), taggedAxis.getSizePixels() - e.getY());
        double mousePosValue = taggedAxis.screenPixelToValue(mousePosPixels);
        double minDiff = minTag.getValue() - currentTag.getValue();
        double maxDiff = maxTag.getValue() - currentTag.getValue();
        minTag.setValue(mousePosValue + minDiff);
        maxTag.setValue(mousePosValue + maxDiff);
        currentTag.setValue(mousePosValue);
    }

    @Override
    public void mouseWheelMoved(GlimpseMouseEvent e) {
        TaggedAxis1D taggedAxis = this.getAxis(e);
        if (taggedAxis == null) {
            return;
        }
        if (e.isKeyDown(ModifierKey.Ctrl) || e.isKeyDown(ModifierKey.Meta)) {
            this.handleCtrlMouseWheel(e);
        } else {
            super.mouseWheelMoved(e);
        }
    }

    @Override
    public void mousePressed(GlimpseMouseEvent event) {
        super.mousePressed(event);
        TaggedAxis1D taggedAxis = this.getAxis(event);
        if (taggedAxis == null) {
            return;
        }
        taggedAxis.validateTags();
    }

    @Override
    public void mouseMoved(GlimpseMouseEvent event) {
        super.mouseMoved(event);
        TaggedAxis1D taggedAxis = this.getAxis(event);
        if (taggedAxis == null) {
            return;
        }
        taggedAxis.validateTags();
    }

    @Override
    public void mouseReleased(GlimpseMouseEvent event) {
        super.mouseReleased(event);
        TaggedAxis1D taggedAxis = this.getAxis(event);
        if (taggedAxis == null) {
            return;
        }
        taggedAxis.validateTags();
    }

    public void handleCtrlMouseWheel(GlimpseMouseEvent e) {
        TaggedAxis1D taggedAxis = this.getAxis(e);
        if (taggedAxis == null) {
            return;
        }
        int zoomIncrements = e.getWheelIncrement();
        double newSelectionSize = this.calculateNewSelectionSize(taggedAxis, zoomIncrements);
        Tag minTag = taggedAxis.getTag("min_time");
        Tag maxTag = taggedAxis.getTag("max_time");
        Tag currentTag = taggedAxis.getTag("current_time");
        double maxValue = maxTag.getValue();
        minTag.setValue(maxValue - newSelectionSize);
        maxTag.setValue(maxValue);
        currentTag.setValue(maxValue);
        taggedAxis.validateTags();
        taggedAxis.validate();
    }

    protected TaggedAxis1D getAxis(GlimpseMouseEvent e) {
        GlimpseAxisLayout1D layout = this.getAxisLayout(e);
        Axis1D axis = layout.getAxis();
        if (axis instanceof TaggedAxis1D) {
            return (TaggedAxis1D)axis;
        }
        return null;
    }

    protected double calculateNewSelectionSize(TaggedAxis1D taggedAxis, int zoomIncrements) {
        Tag minTag = taggedAxis.getTag("min_time");
        Tag maxTag = taggedAxis.getTag("max_time");
        double minValue = minTag.getValue();
        double maxValue = maxTag.getValue();
        double selectionSize = maxValue - minValue;
        double zoomPercentDbl = 1.0;
        for (int i = 0; i < Math.abs(zoomIncrements); ++i) {
            zoomPercentDbl *= 1.119999997317791;
        }
        zoomPercentDbl = zoomIncrements > 0 ? 1.0 / zoomPercentDbl : zoomPercentDbl;
        double newSelectionSize = selectionSize * zoomPercentDbl;
        return newSelectionSize;
    }

    protected void moveAllTags(TaggedAxis1D taggedAxis, double deltaTagValue) {
        for (Tag tag : taggedAxis.getSortedTags()) {
            tag.setValue(tag.getValue() + deltaTagValue);
        }
    }
}

