/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.listener;

import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener1D;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.ModifierKey;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.plot.stacked.PlotInfo;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;

public class DataAxisMouseListener1D
extends AxisMouseListener1D {
    protected static final int AXIS_SIZE = 28;
    protected StackedTimePlot2D plot;
    protected PlotInfo info;
    protected boolean axisSelected;
    protected int axisSize = 28;

    public DataAxisMouseListener1D(StackedTimePlot2D plot, PlotInfo info) {
        this.info = info;
        this.plot = plot;
    }

    public void setAxisSize(int size) {
        this.axisSize = size;
    }

    @Override
    public void mouseMoved(GlimpseMouseEvent e) {
        GlimpseAxisLayout1D layout = this.getAxisLayout(e);
        if (layout == null) {
            return;
        }
        if (e.isAnyButtonDown() && this.axisSelected) {
            super.mouseMoved(e);
            e.setHandled(true);
        }
    }

    @Override
    public void mousePressed(GlimpseMouseEvent e) {
        this.plot.setSelectedPlot(this.info);
        this.axisSelected = this.isAxisSelected(e);
        if (this.axisSelected) {
            super.mousePressed(e);
            e.setHandled(true);
        }
    }

    protected boolean isAxisSelected(GlimpseMouseEvent e) {
        GlimpseAxisLayout1D layout = this.getAxisLayout(e);
        if (layout == null) {
            return false;
        }
        if (e.isKeyDown(ModifierKey.Shift)) {
            return true;
        }
        if (layout.isHorizontal() && e.getY() < this.axisSize) {
            return true;
        }
        return !layout.isHorizontal() && e.getX() < this.axisSize;
    }

    @Override
    public void mouseReleased(GlimpseMouseEvent e) {
        super.mouseReleased(e);
    }

    @Override
    public void mouseWheelMoved(GlimpseMouseEvent e) {
        this.axisSelected = this.isAxisSelected(e);
        if (this.axisSelected) {
            super.mouseWheelMoved(e);
            e.setHandled(true);
        }
    }
}

