/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.layout;

import com.metsci.glimpse.axis.painter.NumericXYAxisPainter;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.GlimpseMouseAllListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.painter.decoration.GridPainter;
import com.metsci.glimpse.painter.group.DelegatePainter;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.painter.info.TooltipPainter;
import com.metsci.glimpse.plot.stacked.PlotInfo;
import com.metsci.glimpse.plot.stacked.PlotInfoWrapper;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;
import com.metsci.glimpse.plot.timeline.layout.TimePlotInfo;
import com.metsci.glimpse.plot.timeline.layout.TimeToolTipHandler;
import com.metsci.glimpse.plot.timeline.listener.DataAxisMouseListener1D;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.util.units.time.TimeStamp;
import com.metsci.glimpse.util.units.time.format.TimeStampFormat;
import com.metsci.glimpse.util.units.time.format.TimeStampFormatStandard;
import java.awt.Font;

public class TimePlotInfoImpl
extends PlotInfoWrapper
implements TimePlotInfo {
    protected GridPainter gridPainter;
    protected NumericXYAxisPainter axisPainter;
    protected SimpleTextPainter labelPainter;
    protected BorderPainter borderPainter;
    protected BorderPainter labelBorderPainter;
    protected BackgroundPainter backgroundPainter;
    protected DelegatePainter dataPainter;
    protected StackedTimePlot2D parent;
    protected DataAxisMouseListener1D listener;
    protected GlimpseAxisLayout2D plotLayout;
    protected GlimpseLayout labelLayout;
    protected TimeToolTipHandler timeToolTipHandler;

    public TimePlotInfoImpl(final StackedTimePlot2D parent, PlotInfo child, GlimpseAxisLayout2D plotLayout, GlimpseLayout labelLayout, DataAxisMouseListener1D listener, GridPainter gridPainter, NumericXYAxisPainter axisPainter, final SimpleTextPainter labelPainter, BorderPainter borderPainter, BorderPainter labelBorderPainter, BackgroundPainter backgroundPainter, DelegatePainter dataPainter) {
        super(child);
        this.parent = parent;
        this.plotLayout = plotLayout;
        this.labelLayout = labelLayout;
        this.listener = listener;
        this.gridPainter = gridPainter;
        this.axisPainter = axisPainter;
        this.labelPainter = labelPainter;
        this.borderPainter = borderPainter;
        this.labelBorderPainter = labelBorderPainter;
        this.backgroundPainter = backgroundPainter;
        this.dataPainter = dataPainter;
        this.timeToolTipHandler = new TimeToolTipHandler(){
            TimeStampFormat format = new TimeStampFormatStandard("%2H:%2m:%3S", "UTC");

            @Override
            public void setToolTip(GlimpseMouseEvent e, TooltipPainter toolTipPainter) {
                double value = parent.isTimeAxisHorizontal() ? e.getAxisCoordinatesY() : e.getAxisCoordinatesX();
                double time = parent.isTimeAxisHorizontal() ? e.getAxisCoordinatesX() : e.getAxisCoordinatesY();
                TimeStamp timestamp = parent.getEpoch().toTimeStamp(time);
                toolTipPainter.setIcon(null);
                toolTipPainter.setText(String.format("%s\nTime: %s\nData: %.3f", labelPainter.getText(), timestamp.toString(this.format), value));
            }
        };
        this.plotLayout.addGlimpseMouseAllListener(new GlimpseMouseAllListener(){

            @Override
            public void mouseMoved(GlimpseMouseEvent e) {
                if (TimePlotInfoImpl.this.timeToolTipHandler != null) {
                    TimePlotInfoImpl.this.timeToolTipHandler.setToolTip(e, parent.getTooltipPainter());
                }
            }

            @Override
            public void mouseExited(GlimpseMouseEvent event) {
                if (TimePlotInfoImpl.this.timeToolTipHandler != null) {
                    TooltipPainter toolTipPainter = parent.getTooltipPainter();
                    toolTipPainter.setIcon(null);
                    toolTipPainter.setText(null);
                }
            }

            @Override
            public void mouseEntered(GlimpseMouseEvent event) {
            }

            @Override
            public void mousePressed(GlimpseMouseEvent event) {
            }

            @Override
            public void mouseReleased(GlimpseMouseEvent event) {
            }

            @Override
            public void mouseWheelMoved(GlimpseMouseEvent e) {
            }
        });
    }

    @Override
    public void setTimeToolTipHandler(TimeToolTipHandler toolTipHandler) {
        this.timeToolTipHandler = toolTipHandler;
    }

    @Override
    public DataAxisMouseListener1D getDataAxisMouseListener() {
        return this.listener;
    }

    @Override
    public void setBorderColor(float[] rgba) {
        this.borderPainter.setColor(rgba);
    }

    @Override
    public void setBorderWidth(float width) {
        this.borderPainter.setLineWidth(width);
    }

    @Override
    public void setLabelBorderColor(float[] rgba) {
        this.labelBorderPainter.setColor(rgba);
    }

    @Override
    public void setLabelBorderWidth(float width) {
        this.labelBorderPainter.setLineWidth(width);
    }

    @Override
    public void setLabelText(String text) {
        this.labelPainter.setText(text);
    }

    @Override
    public void setLabelColor(float[] rgba) {
        this.labelPainter.setColor(rgba);
    }

    @Override
    public void setAxisColor(float[] rgba) {
        this.axisPainter.setLineColor(rgba);
        this.axisPainter.setTextColor(rgba);
    }

    @Override
    public void setAxisFont(Font font) {
        this.axisPainter.setFont(font);
    }

    @Override
    public void setBackgroundColor(float[] rgba) {
        this.backgroundPainter.setColor(rgba);
    }

    @Override
    public GlimpseLayout getLabelLayout() {
        return this.labelLayout;
    }

    @Override
    public BackgroundPainter getBackgroundPainter() {
        return this.backgroundPainter;
    }

    @Override
    public GridPainter getGridPainter() {
        return this.gridPainter;
    }

    @Override
    public NumericXYAxisPainter getAxisPainter() {
        return this.axisPainter;
    }

    @Override
    public SimpleTextPainter getLabelPainter() {
        return this.labelPainter;
    }

    @Override
    public BorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    @Override
    public BorderPainter getLabelBorderPainter() {
        return this.labelBorderPainter;
    }

    @Override
    public StackedTimePlot2D getStackedTimePlot() {
        return this.parent;
    }

    @Override
    public DelegatePainter getDataPainter() {
        return this.dataPainter;
    }

    @Override
    public void addPainter(GlimpsePainter painter) {
        this.dataPainter.addPainter(painter);
    }

    @Override
    public void removePainter(GlimpsePainter painter) {
        this.dataPainter.removePainter(painter);
    }

    @Override
    public GlimpseAxisLayout2D getLayout() {
        return this.plotLayout;
    }

    @Override
    public void addLayout(GlimpseAxisLayout2D childLayout) {
        this.plotLayout.addLayout(childLayout);
    }

    @Override
    public TaggedAxis1D getCommonAxis(GlimpseTargetStack stack) {
        return (TaggedAxis1D)super.getCommonAxis(stack);
    }

    @Override
    public TaggedAxis1D getCommonAxis() {
        return (TaggedAxis1D)super.getCommonAxis();
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        super.setLookAndFeel(laf);
        this.labelLayout.setLookAndFeel(laf);
    }

    @Override
    public void updateLayout(int index) {
        int labelSize;
        super.updateLayout(index);
        StackedTimePlot2D parent = this.getStackedTimePlot();
        int n = labelSize = parent.isShowLabels() ? parent.getLabelSize() : 0;
        if (parent.isTimeAxisHorizontal()) {
            this.plotLayout.setLayoutData("cell 1 0 1 1, push, grow");
            this.labelLayout.setLayoutData(String.format("cell 0 0, pushy, growy, width %d!", labelSize));
            this.labelLayout.setVisible(parent.isShowLabels());
        } else {
            this.plotLayout.setLayoutData("cell 0 1 1 1, push, grow");
            this.labelLayout.setLayoutData(String.format("cell 0 0, pushx, growx, height %d!", labelSize));
            this.labelLayout.setVisible(parent.isShowLabels());
        }
    }
}

