/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.group;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainterImpl;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.settings.AbstractLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;

public class GroupLabelPainter
extends GlimpsePainterImpl {
    protected int buttonSize = 8;
    protected int padding = 5;
    protected float[] lineColor = GlimpseColor.getBlack();
    protected SimpleTextPainter textDelegate = new SimpleTextPainter();
    protected boolean isExpanded = true;
    protected boolean showDivider = true;
    protected boolean showArrow = true;

    public GroupLabelPainter(String name) {
        this.textDelegate.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Left);
        this.textDelegate.setVerticalPosition(SimpleTextPainter.VerticalPosition.Top);
        this.textDelegate.setHorizontalLabels(true);
        this.textDelegate.setHorizontalPadding(this.buttonSize + this.padding * 2);
        this.textDelegate.setVerticalPadding(0);
        this.textDelegate.setText(name);
        this.textDelegate.setFont(FontUtils.getDefaultPlain(14.0f), true);
    }

    public SimpleTextPainter getTextPainter() {
        return this.textDelegate;
    }

    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    public void setText(String text) {
        this.textDelegate.setText(text);
    }

    public void setShowArrow(boolean show) {
        this.showArrow = show;
    }

    public boolean isShowArrow() {
        return this.showArrow;
    }

    public void setShowDivider(boolean show) {
        this.showDivider = show;
    }

    public boolean isShowDivider() {
        return this.showDivider;
    }

    public void setDividerColor(float[] color) {
        this.lineColor = color;
    }

    public float[] getDividerColor() {
        return this.lineColor;
    }

    public void setArrowSpacing(int size) {
        this.padding = size;
    }

    public int getArrowSpacing() {
        return this.padding;
    }

    public void setArrowSize(int size) {
        this.buttonSize = size;
    }

    public int getArrowSize() {
        return this.buttonSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintTo(GlimpseContext context, GlimpseBounds bounds) {
        this.textDelegate.paintTo(context);
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        GL gl = context.getGL();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)bounds.getWidth(), 0.0, (double)bounds.getHeight(), -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        if (this.showDivider) {
            Rectangle2D textBounds = this.textDelegate.getTextBounds();
            float startY = (float)height / 2.0f;
            float startX = (float)((double)(this.padding + this.textDelegate.getHorizontalPadding()) + textBounds.getWidth() + textBounds.getMinX() - 1.0);
            gl.glLineWidth(1.0f);
            GlimpseColor.glColor(gl, this.lineColor);
            gl.glBegin(1);
            try {
                gl.glVertex2f(startX, startY);
                gl.glVertex2f((float)width, startY);
            }
            finally {
                gl.glEnd();
            }
        }
        if (this.showArrow) {
            float halfSize = (float)this.buttonSize / 2.0f;
            float centerX = halfSize + (float)this.padding;
            float centerY = (float)height / 2.0f;
            gl.glBegin(9);
            try {
                if (this.isExpanded) {
                    gl.glVertex2f(centerX - halfSize, centerY + halfSize);
                    gl.glVertex2f(centerX + halfSize, centerY + halfSize);
                    gl.glVertex2f(centerX, centerY - halfSize);
                } else {
                    gl.glVertex2f(centerX - halfSize, centerY - halfSize);
                    gl.glVertex2f(centerX - halfSize, centerY + halfSize);
                    gl.glVertex2f(centerX + halfSize, centerY);
                }
            }
            finally {
                gl.glEnd();
            }
        }
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        super.setLookAndFeel(laf);
        if (laf != null) {
            this.textDelegate.setLookAndFeel(laf);
            this.lineColor = laf.getColor(AbstractLookAndFeel.BORDER_COLOR);
        }
    }
}

