/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.group;

import com.metsci.glimpse.event.mouse.GlimpseMouseAdapter;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.plot.stacked.PlotInfo;
import com.metsci.glimpse.plot.stacked.PlotInfoWrapper;
import com.metsci.glimpse.plot.timeline.CollapsibleTimePlot2D;
import com.metsci.glimpse.plot.timeline.group.GroupInfo;
import com.metsci.glimpse.plot.timeline.group.GroupLabelPainter;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public class GroupInfoImpl
extends PlotInfoWrapper
implements GroupInfo {
    protected CollapsibleTimePlot2D plot;
    protected Set<PlotInfo> children;
    protected GroupLabelPainter labelPainter;
    protected String label;
    protected boolean expanded;

    public GroupInfoImpl(CollapsibleTimePlot2D plot, PlotInfo group, Collection<? extends PlotInfo> subplots) {
        super(group);
        this.plot = plot;
        this.labelPainter = new GroupLabelPainter("");
        this.info.getLayout().addPainter(this.labelPainter);
        this.info.setSize(22);
        this.expanded = true;
        this.children = new LinkedHashSet<PlotInfo>();
        this.children.addAll(subplots);
        GlimpseAxisLayout2D layout = this.info.getLayout();
        layout.setEventConsumer(false);
        layout.setEventGenerator(true);
        layout.addGlimpseMouseListener(new GlimpseMouseAdapter(){

            @Override
            public void mousePressed(GlimpseMouseEvent event) {
                int x = event.getScreenPixelsX();
                if (x < GroupInfoImpl.this.labelPainter.getArrowSize() + GroupInfoImpl.this.labelPainter.getArrowSpacing() * 2) {
                    GroupInfoImpl.this.setExpanded(!GroupInfoImpl.this.expanded);
                    event.setHandled(true);
                }
            }
        });
    }

    @Override
    public SimpleTextPainter getTextPainter() {
        return this.labelPainter.getTextPainter();
    }

    @Override
    public void setShowArrow(boolean show) {
        this.labelPainter.setShowArrow(show);
    }

    @Override
    public boolean isShowArrow() {
        return this.labelPainter.isShowArrow();
    }

    @Override
    public void setShowDivider(boolean show) {
        this.labelPainter.setShowDivider(show);
    }

    @Override
    public boolean isShowDivider() {
        return this.labelPainter.isShowDivider();
    }

    @Override
    public void setDividerColor(float[] color) {
        this.labelPainter.setDividerColor(color);
    }

    @Override
    public float[] getDividerColor() {
        return this.labelPainter.getDividerColor();
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.labelPainter.setExpanded(expanded);
        this.setVisible0(this, expanded);
        this.plot.validateLayout();
    }

    protected void setVisible0(GroupInfo parent, boolean visible) {
        for (PlotInfo child : parent.getChildPlots()) {
            GroupInfo childGroup;
            child.setVisible(visible);
            if (!(child instanceof GroupInfo) || !(childGroup = (GroupInfo)child).isExpanded()) continue;
            this.setVisible0(childGroup, visible);
        }
    }

    @Override
    public void addChildPlot(PlotInfo childPlot) {
        childPlot.setVisible(this.expanded);
        this.children.add(childPlot);
        if (this.plot.isAutoValidate()) {
            this.plot.validateLayout();
        }
    }

    @Override
    public void removeChildPlot(PlotInfo childPlot) {
        this.children.remove(childPlot);
        if (this.plot.isAutoValidate()) {
            this.plot.validateLayout();
        }
    }

    @Override
    public Collection<PlotInfo> getChildPlots() {
        return Collections.unmodifiableCollection(this.children);
    }

    @Override
    public void setLabelText(String label) {
        this.label = label;
        this.labelPainter.setText(label);
    }

    @Override
    public String getLabelText() {
        return this.label;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroupInfoImpl other = (GroupInfoImpl)obj;
        return !(this.info == null ? other.info != null : !this.info.equals(other.info));
    }
}

