/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.event;

import com.google.common.base.Supplier;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.metsci.glimpse.plot.timeline.event.Event;
import com.metsci.glimpse.util.units.time.TimeStamp;
import com.metsci.glimpse.util.units.time.TimeStampPosixMillisInt64;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class IntervalSortedMultimap {
    SetMultimap<TimeStamp, Event> startMultimap = IntervalSortedMultimap.buildMap();
    SetMultimap<TimeStamp, Event> endMultimap = IntervalSortedMultimap.buildMap();
    SortedMap<TimeStamp, Collection<Event>> startMap = (SortedMap)this.startMultimap.asMap();
    SortedMap<TimeStamp, Collection<Event>> endMap = (SortedMap)this.endMultimap.asMap();

    protected TimeStamp successor(TimeStamp t) {
        return TimeStampPosixMillisInt64.factory.fromPosixMillis(t.toPosixMillis() + 1L);
    }

    protected TimeStamp predecessor(TimeStamp t) {
        return TimeStampPosixMillisInt64.factory.fromPosixMillis(t.toPosixMillis() - 1L);
    }

    protected Set<Event> getEvents(SortedMap<TimeStamp, Collection<Event>> map) {
        HashSet<Event> allEvents = new HashSet<Event>();
        for (Collection<Event> c : map.values()) {
            allEvents.addAll(c);
        }
        return allEvents;
    }

    public void addEvent(Event event) {
        this.startMultimap.put((Object)event.getStartTime(), (Object)event);
        this.endMultimap.put((Object)event.getEndTime(), (Object)event);
    }

    public void removeEvent(Event event) {
        this.startMultimap.remove((Object)event.getStartTime(), (Object)event);
        this.endMultimap.remove((Object)event.getEndTime(), (Object)event);
    }

    public Set<Event> get(TimeStamp time) {
        return this.get(time, true, time, true);
    }

    public Set<Event> get(TimeStamp start, TimeStamp end) {
        return this.get(start, true, end, false);
    }

    public Set<Event> get(TimeStamp start, boolean startInclusive, TimeStamp end, boolean endInclusive) {
        if (!startInclusive) {
            start = this.successor(start);
        }
        if (endInclusive) {
            end = this.successor(end);
        }
        SortedMap<TimeStamp, Collection<Event>> tailMap = this.endMap.tailMap(start);
        SortedMap<TimeStamp, Collection<Event>> headMap = this.startMap.headMap(end);
        Set<Event> tailSet = this.getEvents(tailMap);
        Set<Event> headSet = this.getEvents(headMap);
        return Sets.intersection(headSet, tailSet);
    }

    public SetMultimap<TimeStamp, Event> getMap(TimeStamp start, boolean startInclusive, TimeStamp end, boolean endInclusive) {
        Set<Event> set = this.get(start, startInclusive, end, endInclusive);
        SetMultimap<TimeStamp, Event> map = IntervalSortedMultimap.buildMap();
        for (Event e : set) {
            map.put((Object)e.getStartTime(), (Object)e);
        }
        return map;
    }

    public Set<Event> getOverlapping(Event event) {
        return this.get(event.getStartTime(), event.getEndTime());
    }

    public Set<Event> getInterior(TimeStamp start, TimeStamp end) {
        return this.getInterior(start, true, end, false);
    }

    public Set<Event> getInterior(TimeStamp start, boolean startInclusive, TimeStamp end, boolean endInclusive) {
        if (!startInclusive) {
            start = this.successor(start);
        }
        if (endInclusive) {
            end = this.successor(end);
        }
        SortedMap<TimeStamp, Collection<Event>> tailMap = this.endMap.headMap(end);
        SortedMap<TimeStamp, Collection<Event>> headMap = this.startMap.tailMap(start);
        Set<Event> tailSet = this.getEvents(tailMap);
        Set<Event> headSet = this.getEvents(headMap);
        return Sets.intersection(headSet, tailSet);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size() {
        return this.startMap.size();
    }

    public static void main(String[] args) {
        Event a = new Event("a", "a", TimeStamp.fromPosixMillis((long)0L), TimeStamp.fromPosixMillis((long)1L));
        Event b = new Event("b", "b", TimeStamp.fromPosixMillis((long)2L), TimeStamp.fromPosixMillis((long)4L));
        Event c = new Event("c", "c", TimeStamp.fromPosixMillis((long)0L), TimeStamp.fromPosixMillis((long)2L));
        Event d = new Event("d", "d", TimeStamp.fromPosixMillis((long)1L), TimeStamp.fromPosixMillis((long)1L));
        IntervalSortedMultimap map = new IntervalSortedMultimap();
        map.addEvent(a);
        map.addEvent(b);
        map.addEvent(c);
        map.addEvent(d);
        map.addEvent(a);
        System.out.println(map.getInterior(TimeStamp.fromPosixMillis((long)1L), TimeStamp.fromPosixMillis((long)4L)));
    }

    public static SetMultimap<TimeStamp, Event> buildMap() {
        TreeMap map = new TreeMap();
        Supplier<LinkedHashSet<Event>> supplier = new Supplier<LinkedHashSet<Event>>(){

            public LinkedHashSet<Event> get() {
                return new LinkedHashSet<Event>();
            }
        };
        return Multimaps.newSetMultimap(map, (Supplier)supplier);
    }
}

