/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.event;

import com.google.common.collect.Sets;
import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.event.mouse.GlimpseMouseAllListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseAxisLayoutX;
import com.metsci.glimpse.layout.GlimpseAxisLayoutY;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.painter.info.TooltipPainter;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.plot.timeline.data.EventSelection;
import com.metsci.glimpse.plot.timeline.event.Event;
import com.metsci.glimpse.plot.timeline.event.EventPainter;
import com.metsci.glimpse.plot.timeline.layout.TimePlotInfo;
import com.metsci.glimpse.plot.timeline.layout.TimePlotInfoWrapper;
import com.metsci.glimpse.support.atlas.TextureAtlas;
import com.metsci.glimpse.util.units.time.TimeStamp;
import java.awt.Font;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventPlotInfo
extends TimePlotInfoWrapper
implements TimePlotInfo {
    public static final int DEFAULT_ROW_SIZE = 26;
    public static final int DEFAULT_BUFFER_SIZE = 2;
    protected EventPainter eventPainter;
    protected GlimpseAxisLayout1D layout1D;
    protected int maxRowCount = Integer.MAX_VALUE;
    protected int minRowCount = 0;
    protected int rowSize;
    protected int eventPadding;
    protected List<EventPlotListener> eventListeners;
    protected boolean isHorizontal;
    protected EventToolTipHandler eventToolTipHandler;
    protected DragListener dragListener;
    protected TooltipListener tooltipListener;
    protected Event.TextRenderingMode textRenderingMode = Event.TextRenderingMode.Ellipsis;

    public EventPlotInfo(TimePlotInfo delegate) {
        this(delegate, new TextureAtlas());
    }

    public EventPlotInfo(TimePlotInfo delegate, TextureAtlas atlas) {
        super(delegate);
        Epoch epoch = this.getStackedTimePlot().getEpoch();
        this.isHorizontal = this.getStackedTimePlot().isTimeAxisHorizontal();
        this.layout1D = this.isHorizontal ? new GlimpseAxisLayoutX((GlimpseLayout)this.getLayout(), "EventLayout1D") : new GlimpseAxisLayoutY((GlimpseLayout)this.getLayout(), "EventLayout1D");
        this.layout1D.setLayoutData("pos container.x container.y container.x2 container.y2");
        this.layout1D.setEventConsumer(false);
        this.eventPainter = new EventPainter(this, epoch, atlas, this.isHorizontal);
        this.layout1D.addPainter(this.eventPainter);
        this.eventListeners = new CopyOnWriteArrayList<EventPlotListener>();
        this.layout1D.addGlimpseMouseAllListener(new EventListener());
        this.dragListener = new DragListener();
        this.addEventPlotListener(this.dragListener);
        this.layout1D.addGlimpseMouseAllListener(this.dragListener);
        this.tooltipListener = new TooltipListener();
        this.addEventPlotListener(this.tooltipListener);
        this.info.setTimeToolTipHandler(null);
        this.eventToolTipHandler = new EventToolTipHandler(){

            @Override
            public void setToolTip(EventSelection selection, TooltipPainter tooltipPainter) {
                Event event = selection.getEvent();
                String label = event.getLabel() == null ? "" : event.getLabel();
                String tip = event.getToolTipText() == null ? "" : event.getToolTipText();
                String text = String.format("%s\n%s", label, tip);
                tooltipPainter.setText(text);
                tooltipPainter.setIcon(event.getIconId());
            }
        };
        this.rowSize = 26;
        this.eventPadding = 2;
        this.updateSize();
    }

    public void setEventToolTipHandler(EventToolTipHandler toolTipHandler) {
        this.eventToolTipHandler = toolTipHandler;
    }

    public TimeStamp getTime(GlimpseMouseEvent e) {
        Axis1D axis = e.getAxis1D();
        double valueX = axis.screenPixelToValue(e.getX());
        return this.getStackedTimePlot().getEpoch().toTimeStamp(valueX);
    }

    public boolean isMouseDragEnabled() {
        return this.dragListener.isEnabled();
    }

    public void setMouseDragEnabled(boolean enabled) {
        this.dragListener.setEnabled(enabled);
    }

    public void addEventPlotListener(EventPlotListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventPlotListener(EventPlotListener listener) {
        this.eventListeners.remove(listener);
    }

    public boolean isStackOverlappingEvents() {
        return this.eventPainter.isStackOverlappingEvents();
    }

    public void setStackOverlappingEvents(boolean stack) {
        this.eventPainter.setStackOverlappingEvents(stack);
    }

    public int getRow(Object eventId) {
        return this.eventPainter.getRow(eventId);
    }

    public void setRowSize(int size) {
        this.rowSize = size;
        this.updateSize();
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public void setEventPadding(int size) {
        this.eventPadding = size;
        this.updateSize();
    }

    public int getEventPadding() {
        return this.eventPadding;
    }

    public void setRowMaxCount(int count) {
        this.maxRowCount = count;
        this.eventPainter.validate();
    }

    public int getRowMaxCount() {
        return this.maxRowCount;
    }

    public void setRowMinCount(int count) {
        this.minRowCount = count;
        this.updateSize();
    }

    public int getRowMinCount() {
        return this.minRowCount;
    }

    public int getRowCount() {
        return Math.max(this.minRowCount, this.eventPainter.getRowCount());
    }

    public void updateSize() {
        int rowCount = this.getRowCount();
        this.setSize(rowCount * this.rowSize + (rowCount + 1) * this.eventPadding);
    }

    public TextureAtlas getTextureAtlas() {
        return this.eventPainter.getTextureAtlas();
    }

    @Override
    public void setBackgroundColor(float[] backgroundColor) {
        this.eventPainter.setBackgroundColor(backgroundColor);
    }

    @Override
    public void setBorderColor(float[] borderColor) {
        this.eventPainter.setBorderColor(borderColor);
    }

    public void setTextColor(float[] textColor) {
        this.eventPainter.setTextColor(textColor);
    }

    public void setFont(Font font, boolean antialias) {
        this.eventPainter.setFont(font, antialias);
    }

    public Set<Event> getEvents() {
        return this.eventPainter.getEvents();
    }

    public Event getEvent(Object id) {
        return this.eventPainter.getEvent(id);
    }

    public Event addEvent(String label, TimeStamp time) {
        return this.addEvent(UUID.randomUUID(), label, time);
    }

    public Event addEvent(String label, TimeStamp startTime, TimeStamp endTime) {
        return this.addEvent(UUID.randomUUID(), label, startTime, endTime);
    }

    public Event addEvent(Object id, String label, TimeStamp time) {
        Event event = new Event(id, label, time);
        this.addEvent(event);
        return event;
    }

    public Event addEvent(Object id, String label, TimeStamp startTime, TimeStamp endTime) {
        Event event = new Event(id, label, startTime, endTime);
        this.addEvent(event);
        return event;
    }

    public void addEvent(Event event) {
        event.setEventPlotInfo(this);
        event.setTextRenderingMode(this.textRenderingMode);
        this.eventPainter.addEvent(event);
    }

    public void removeEvent(Event event) {
        event.setEventPlotInfo(null);
        this.eventPainter.removeEvent(event.getId());
    }

    public void removeEvent(Object id) {
        Event event = this.eventPainter.removeEvent(id);
        if (event != null) {
            event.setEventPlotInfo(null);
        }
    }

    public void setTextRenderingMode(Event.TextRenderingMode mode) {
        this.textRenderingMode = mode;
    }

    public Event.TextRenderingMode getTextRenderingMode() {
        return this.textRenderingMode;
    }

    public void updateEventRow(Event event, int rowIndex) {
        this.eventPainter.setRow(event.getId(), rowIndex);
        this.notifyEventUpdated(event);
    }

    public void updateEvent(Event oldEvent, TimeStamp newStartTime, TimeStamp newEndTime) {
        this.eventPainter.moveEvent0(oldEvent, newStartTime, newEndTime);
        this.notifyEventUpdated(oldEvent);
    }

    protected void notifyEventUpdated(Event event) {
        for (EventPlotListener listener : this.eventListeners) {
            listener.eventUpdated(event);
        }
    }

    public static interface EventToolTipHandler {
        public void setToolTip(EventSelection var1, TooltipPainter var2);
    }

    public static interface EventPlotListener {
        public void eventsExited(GlimpseMouseEvent var1, Set<EventSelection> var2, TimeStamp var3);

        public void eventsEntered(GlimpseMouseEvent var1, Set<EventSelection> var2, TimeStamp var3);

        public void eventsHovered(GlimpseMouseEvent var1, Set<EventSelection> var2, TimeStamp var3);

        public void eventsClicked(GlimpseMouseEvent var1, Set<EventSelection> var2, TimeStamp var3);

        public void eventUpdated(Event var1);
    }

    protected class DragListener
    implements EventPlotListener,
    GlimpseMouseAllListener {
        EventSelection.Location dragType = null;
        TimeStamp anchorTime = null;
        TimeStamp eventStart = null;
        TimeStamp eventEnd = null;
        Event dragEvent = null;
        boolean enabled = true;

        protected DragListener() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
            this.reset();
        }

        public void reset() {
            this.dragType = null;
            this.anchorTime = null;
            this.eventStart = null;
            this.eventEnd = null;
            this.dragEvent = null;
        }

        @Override
        public void mouseMoved(GlimpseMouseEvent e) {
            if (!this.enabled) {
                return;
            }
            if (e.isButtonDown(MouseButton.Button1) && this.dragEvent != null) {
                TimeStamp time = EventPlotInfo.this.getTime(e);
                if (this.dragType == EventSelection.Location.Center) {
                    double diff = time.durationAfter(this.anchorTime);
                    this.dragEvent.setTimes(this.eventStart.add(diff), this.eventEnd.add(diff));
                } else if (this.dragType == EventSelection.Location.End && this.eventStart.isBefore(time)) {
                    this.dragEvent.setTimes(this.eventStart, time);
                } else if (this.dragType == EventSelection.Location.Start && this.eventEnd.isAfter(time)) {
                    this.dragEvent.setTimes(time, this.eventEnd);
                }
                e.setHandled(true);
            }
        }

        @Override
        public void eventsClicked(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
            if (!this.enabled) {
                return;
            }
            if (e.isButtonDown(MouseButton.Button1)) {
                for (EventSelection selection : events) {
                    if (!selection.isLocation(EventSelection.Location.Center, EventSelection.Location.Start, EventSelection.Location.End) || !selection.getEvent().isEditable()) continue;
                    this.dragEvent = selection.getEvent();
                    this.eventStart = this.dragEvent.getStartTime();
                    this.eventEnd = this.dragEvent.getEndTime();
                    this.anchorTime = time;
                    e.setHandled(true);
                    if (selection.isCenterSelection()) {
                        this.dragType = EventSelection.Location.Center;
                    } else if (selection.isStartTimeSelection()) {
                        this.dragType = EventSelection.Location.Start;
                    } else if (selection.isEndTimeSelection()) {
                        this.dragType = EventSelection.Location.End;
                    }
                    return;
                }
            }
        }

        @Override
        public void mouseReleased(GlimpseMouseEvent event) {
            if (!this.enabled) {
                return;
            }
            this.reset();
        }

        @Override
        public void eventsHovered(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
        }

        @Override
        public void eventsExited(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
        }

        @Override
        public void eventsEntered(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
        }

        @Override
        public void eventUpdated(Event event) {
        }

        @Override
        public void mouseEntered(GlimpseMouseEvent event) {
        }

        @Override
        public void mouseExited(GlimpseMouseEvent event) {
        }

        @Override
        public void mousePressed(GlimpseMouseEvent event) {
        }

        @Override
        public void mouseWheelMoved(GlimpseMouseEvent e) {
        }
    }

    protected class TooltipListener
    implements EventPlotListener {
        EventSelection selection = null;

        protected TooltipListener() {
        }

        protected void selectEvent(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
            EventSelection bestSelection = null;
            double bestDiff = Double.POSITIVE_INFINITY;
            for (EventSelection eventSelection : events) {
                Event event = eventSelection.getEvent();
                double diff = Math.abs(event.getEndTime().durationAfter(time));
                if (diff < bestDiff) {
                    bestSelection = eventSelection;
                    bestDiff = diff;
                }
                if (!((diff = Math.abs(event.getStartTime().durationAfter(time))) < bestDiff)) continue;
                bestSelection = eventSelection;
                bestDiff = diff;
            }
            if (bestSelection == null || bestSelection.equals(this.selection)) {
                return;
            }
            this.selection = bestSelection;
            StackedTimePlot2D plot = EventPlotInfo.this.getStackedTimePlot();
            TooltipPainter tooltipPainter = plot.getTooltipPainter();
            if (EventPlotInfo.this.eventToolTipHandler != null) {
                EventPlotInfo.this.eventToolTipHandler.setToolTip(this.selection, tooltipPainter);
            }
        }

        @Override
        public void eventsExited(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
            if (EventPlotInfo.this.eventToolTipHandler != null && events.contains(this.selection)) {
                StackedTimePlot2D plot = EventPlotInfo.this.getStackedTimePlot();
                TooltipPainter tooltipPainter = plot.getTooltipPainter();
                tooltipPainter.setText(null);
                this.selection = null;
            }
        }

        @Override
        public void eventsEntered(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
            this.selectEvent(e, events, time);
        }

        @Override
        public void eventsHovered(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
            this.selectEvent(e, events, time);
        }

        @Override
        public void eventsClicked(GlimpseMouseEvent e, Set<EventSelection> events, TimeStamp time) {
        }

        @Override
        public void eventUpdated(Event event) {
        }
    }

    protected class EventListener
    implements GlimpseMouseAllListener {
        Set<EventSelection> hoveredEvents = Collections.emptySet();

        protected EventListener() {
        }

        @Override
        public void mouseEntered(GlimpseMouseEvent e) {
        }

        @Override
        public void mouseExited(GlimpseMouseEvent e) {
            TimeStamp time = EventPlotInfo.this.getTime(e);
            for (EventPlotListener listener : EventPlotInfo.this.eventListeners) {
                listener.eventsExited(e, this.hoveredEvents, time);
            }
            this.hoveredEvents = Collections.emptySet();
        }

        @Override
        public void mousePressed(GlimpseMouseEvent e) {
            if (EventPlotInfo.this.isHorizontal) {
                TimeStamp time = EventPlotInfo.this.getTime(e);
                Set<EventSelection> events = Collections.unmodifiableSet(EventPlotInfo.this.eventPainter.getNearestEvents(e));
                for (EventPlotListener listener : EventPlotInfo.this.eventListeners) {
                    listener.eventsClicked(e, events, time);
                }
            }
        }

        @Override
        public void mouseReleased(GlimpseMouseEvent e) {
        }

        @Override
        public void mouseWheelMoved(GlimpseMouseEvent e) {
        }

        @Override
        public void mouseMoved(GlimpseMouseEvent e) {
            if (EventPlotInfo.this.isHorizontal) {
                TimeStamp time = EventPlotInfo.this.getTime(e);
                Set<EventSelection> newHoveredEvents = Collections.unmodifiableSet(EventPlotInfo.this.eventPainter.getNearestEvents(e));
                Sets.SetView eventsExited = Sets.difference(this.hoveredEvents, newHoveredEvents);
                for (EventPlotListener listener : EventPlotInfo.this.eventListeners) {
                    listener.eventsExited(e, (Set<EventSelection>)eventsExited, time);
                }
                Sets.SetView eventsEntered = Sets.difference(newHoveredEvents, this.hoveredEvents);
                for (EventPlotListener listener : EventPlotInfo.this.eventListeners) {
                    listener.eventsEntered(e, (Set<EventSelection>)eventsEntered, time);
                }
                for (EventPlotListener listener : EventPlotInfo.this.eventListeners) {
                    listener.eventsHovered(e, newHoveredEvents, time);
                }
                this.hoveredEvents = Sets.newHashSet(newHoveredEvents);
            }
        }
    }
}

