/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.event;

import com.google.common.collect.SetMultimap;
import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.painter.base.GlimpseDataPainter1D;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.plot.timeline.data.EventSelection;
import com.metsci.glimpse.plot.timeline.event.Event;
import com.metsci.glimpse.plot.timeline.event.EventPlotInfo;
import com.metsci.glimpse.plot.timeline.event.IntervalSortedMultimap;
import com.metsci.glimpse.support.atlas.TextureAtlas;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.settings.AbstractLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.metsci.glimpse.util.units.time.TimeStamp;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import javax.media.opengl.GL;

public class EventPainter
extends GlimpseDataPainter1D {
    protected static final double OVERLAP_HEURISTIC = 20.0;
    protected static final int PICK_BUFFER_PIXELS = 10;
    protected Map<Object, Event> eventMap;
    protected Map<Object, Row> rowMap;
    protected List<Row> rows;
    protected EventPlotInfo plot;
    protected TextureAtlas atlas;
    protected boolean shouldStack = true;
    protected boolean isHorizontal = true;
    protected boolean visibleEventsDirty = true;
    protected double prevMin;
    protected double prevMax;
    protected TextRenderer textRenderer;
    protected boolean fontSet = false;
    protected volatile Font newFont = null;
    protected volatile boolean antialias = false;
    protected float[] backgroundColor = GlimpseColor.getGray(0.2f);
    protected float[] borderColor = GlimpseColor.getWhite(1.0f);
    protected float[] textColor = GlimpseColor.getBlack();
    protected float[] textColorNoBackground = GlimpseColor.getBlack();
    protected boolean textColorSet = false;
    protected boolean backgroundColorSet = false;
    protected boolean borderColorSet = false;

    public EventPainter(EventPlotInfo plot, Epoch epoch, TextureAtlas atlas, boolean isHorizontal) {
        this.plot = plot;
        this.atlas = atlas;
        this.rows = new ArrayList<Row>();
        this.eventMap = new HashMap<Object, Event>();
        this.rowMap = new HashMap<Object, Row>();
        this.isHorizontal = isHorizontal;
        this.newFont = FontUtils.getDefaultPlain(12.0f);
    }

    public boolean isStackOverlappingEvents() {
        return this.shouldStack;
    }

    public void setStackOverlappingEvents(boolean stack) {
        this.shouldStack = stack;
        this.validate();
    }

    public void validate() {
        this.rebuildRows0();
        this.visibleEventsDirty = true;
        this.plot.updateSize();
    }

    public int getRowSize() {
        return this.plot.getRowSize();
    }

    public int getRowBufferSize() {
        return this.plot.getEventPadding();
    }

    public int getRowCount() {
        return Math.max(1, this.rows.size());
    }

    public float[] getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(float[] backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.backgroundColorSet = true;
    }

    public float[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(float[] borderColor) {
        this.borderColor = borderColor;
        this.borderColorSet = true;
    }

    public float[] getTextColor() {
        return this.textColor;
    }

    public void setTextColor(float[] textColor) {
        this.textColor = textColor;
        this.textColorSet = true;
    }

    public void addEvent(Event event) {
        if (event == null) {
            return;
        }
        this.removeEvent(event.getId());
        this.eventMap.put(event.getId(), event);
        this.addEvent0(event);
        this.visibleEventsDirty = true;
        this.plot.updateSize();
    }

    public Event removeEvent(Object id) {
        Event event = this.eventMap.remove(id);
        if (event != null) {
            this.removeEvent0(event);
            this.visibleEventsDirty = true;
            this.plot.updateSize();
        }
        return event;
    }

    public Set<Event> getEvents() {
        return Collections.unmodifiableSet(new HashSet<Event>(this.eventMap.values()));
    }

    public Event getEvent(Object id) {
        return this.eventMap.get(id);
    }

    public TextRenderer getTextRenderer() {
        return this.textRenderer;
    }

    public TextureAtlas getTextureAtlas() {
        return this.atlas;
    }

    public EventPainter setFont(Font font, boolean antialias) {
        this.newFont = font;
        this.antialias = antialias;
        this.fontSet = true;
        return this;
    }

    public boolean isHorizontal() {
        return this.isHorizontal;
    }

    public Epoch getEpoch() {
        return this.plot.getStackedTimePlot().getEpoch();
    }

    public Set<EventSelection> getNearestEvents(GlimpseMouseEvent e) {
        if (this.isHorizontal) {
            Axis1D axis = e.getAxis1D();
            int valueY = e.getY();
            double valueX = axis.screenPixelToValue(e.getX());
            double bufferX = 10.0 / axis.getPixelsPerValue();
            Epoch epoch = this.getEpoch();
            TimeStamp time = epoch.toTimeStamp(valueX);
            TimeStamp timeStart = epoch.toTimeStamp(valueX - bufferX);
            TimeStamp timeEnd = epoch.toTimeStamp(valueX + bufferX);
            int rowIndex = (int)Math.floor((double)valueY / (double)(this.getRowSize() + this.getRowBufferSize()));
            rowIndex = this.plot.getRowCount() - 1 - rowIndex;
            if (rowIndex >= 0 && rowIndex < this.rows.size()) {
                Row row = this.rows.get(rowIndex);
                Set<Event> events = row.getMap().get(timeStart, timeEnd);
                Set<EventSelection> eventSelections = this.createEventSelection(axis, events, time);
                return eventSelections;
            }
        }
        return Collections.emptySet();
    }

    protected Set<EventSelection> createEventSelection(Axis1D axis, Set<Event> events, TimeStamp clickTime) {
        HashSet<EventSelection> set = new HashSet<EventSelection>();
        for (Event event : events) {
            set.add(this.createEventSelection(axis, event, clickTime));
        }
        return set;
    }

    protected EventSelection createEventSelection(Axis1D axis, Event event, TimeStamp t) {
        boolean text;
        double buffer = 10.0 / axis.getPixelsPerValue();
        TimeStamp t1 = t.subtract(buffer);
        TimeStamp t2 = t.add(buffer);
        TimeStamp e1 = event.getStartTime();
        TimeStamp e2 = event.getEndTime();
        EnumSet<EventSelection.Location> locations = EnumSet.noneOf(EventSelection.Location.class);
        boolean start = t2.isAfterOrEquals(e1) && t1.isBeforeOrEquals(e1);
        boolean end = t2.isAfterOrEquals(e2) && t1.isBeforeOrEquals(e2);
        TimeStamp i1 = event.getIconStartTime();
        TimeStamp i2 = event.getIconEndTime();
        boolean icon = event.isIconVisible() && i1 != null && i2 != null && t.isAfterOrEquals(i1) && t.isBeforeOrEquals(i2);
        TimeStamp l1 = event.getLabelStartTime();
        TimeStamp l2 = event.getLabelEndTime();
        boolean bl = text = event.isLabelVisible() && l1 != null && l2 != null && t.isAfterOrEquals(l1) && t.isBeforeOrEquals(l2);
        if (text) {
            locations.add(EventSelection.Location.Label);
        }
        if (icon) {
            locations.add(EventSelection.Location.Icon);
        }
        if (start) {
            locations.add(EventSelection.Location.Start);
        }
        if (end) {
            locations.add(EventSelection.Location.End);
        }
        if (!start && !end || start && end) {
            locations.add(EventSelection.Location.Center);
        }
        return new EventSelection(event, locations);
    }

    protected void rebuildRows0() {
        this.rows.clear();
        this.rowMap.clear();
        for (Event event : this.eventMap.values()) {
            this.addEvent0(event);
        }
    }

    public void setRow(Object eventId, int rowIndex) {
        Event event = this.getEvent(eventId);
        if (event == null) {
            return;
        }
        int oldRowIndex = this.getRow(eventId);
        Row oldRow = this.rows.get(oldRowIndex);
        if (oldRow != null) {
            oldRow.removeEvent(event);
        }
        this.ensureRows0(rowIndex);
        Row newRow = this.rows.get(rowIndex);
        newRow.addEvent(event);
        this.visibleEventsDirty = true;
        this.plot.updateSize();
    }

    public int getRow(Object eventId) {
        Row row = this.rowMap.get(eventId);
        if (row != null) {
            return row.getIndex();
        }
        return 0;
    }

    protected void ensureRows0(int requestedIndex) {
        int currentRowCount = this.rows.size();
        while (requestedIndex >= currentRowCount) {
            this.rows.add(new Row(currentRowCount++));
        }
    }

    protected void moveEvent0(Event event, TimeStamp newStartTime, TimeStamp newEndTime) {
        Event eventOld = Event.createDummyEvent(event);
        Row oldRow = this.rowMap.get(event.getId());
        if (oldRow == null) {
            return;
        }
        if (event.isFixedRow()) {
            oldRow.removeEvent(event);
            event.setTimes0(newStartTime, newEndTime);
            oldRow.addEvent(event);
            this.displaceEvents0(oldRow, event);
        } else {
            oldRow.removeEvent(event);
            event.setTimes0(newStartTime, newEndTime);
            this.addEvent0(event);
        }
        this.shiftEvents0(eventOld, oldRow);
        this.clearEmptyRows0();
        this.visibleEventsDirty = true;
        this.plot.updateSize();
    }

    protected void displaceEvents0(Row row, Event event) {
        HashSet<Event> overlapEvents = new HashSet<Event>(row.getOverlappingEvents(event));
        for (Event overlapEvent : overlapEvents) {
            this.displaceEvent0(overlapEvent);
        }
    }

    protected void displaceEvent0(Event oldEvent) {
        if (!oldEvent.isFixedRow()) {
            Row oldRow = this.rowMap.get(oldEvent.getId());
            oldRow.removeEvent(oldEvent);
            this.addEvent0(oldEvent);
            this.shiftEvents0(oldEvent, oldRow);
        }
    }

    protected void clearEmptyRows0() {
        for (int i = this.rows.size() - 1; i >= 0 && this.rows.get(i).isEmpty(); --i) {
            this.rows.remove(i);
        }
    }

    protected void removeEvent0(Event event) {
        this.eventMap.remove(event.getId());
        Row row = this.rowMap.remove(event.getId());
        if (row == null) {
            return;
        }
        row.removeEvent(event);
        this.shiftEvents0(event, row);
        this.clearEmptyRows0();
    }

    protected void shiftEvents0(Event event, Row toRow) {
        int size = this.rows.size();
        for (int i = size - 1; i > toRow.index; --i) {
            Row fromRow = this.rows.get(i);
            HashSet<Event> events = new HashSet<Event>(fromRow.getOverlappingEvents(event));
            for (Event e : events) {
                this.moveEventIfRoom0(e, fromRow, toRow);
            }
        }
    }

    protected void moveEventIfRoom0(Event event, Row fromRow, Row toRow) {
        if (!event.isFixedRow() && toRow.getOverlappingEvents(event).isEmpty()) {
            fromRow.removeEvent(event);
            toRow.addEvent(event);
            this.shiftEvents0(event, fromRow);
        }
    }

    protected Row addEvent0(Event event) {
        Row row = null;
        if (this.shouldStack && !event.isFixedRow()) {
            row = this.getRowWithLeastOverlaps(event);
            row.addEvent(event);
        } else {
            int requestedRow = Math.min(Math.max(0, event.getFixedRow()), this.plot.getRowMaxCount() - 1);
            this.ensureRows0(requestedRow);
            row = this.rows.get(requestedRow);
            row.addEvent(event);
            if (this.shouldStack) {
                this.displaceEvents0(row, event);
            }
        }
        return row;
    }

    protected Row getRowWithLeastOverlaps(Event event) {
        int size = this.rows.size();
        int max = this.plot.getRowMaxCount();
        double leastTime = Double.POSITIVE_INFINITY;
        Row leastRow = null;
        for (int i = 0; i < size; ++i) {
            Row candidate = this.rows.get(i);
            double overlapTime = this.getTotalOverlapTime(candidate, event);
            if (!(overlapTime < leastTime)) continue;
            leastTime = overlapTime;
            leastRow = candidate;
        }
        if (leastTime != 0.0 && size < max) {
            leastTime = 0.0;
            leastRow = new Row(size);
            this.rows.add(leastRow);
        }
        return leastRow;
    }

    protected double getTotalOverlapTime(Row candidate, Event event) {
        double totalOverlap = 0.0;
        double minOverlap1 = event.getDuration() / 20.0;
        Set<Event> events = candidate.getOverlappingEvents(event);
        for (Event overlapEvent : events) {
            double minOverlap = Math.max(minOverlap1, overlapEvent.getDuration() / 20.0);
            double overlap = event.getOverlapTime(overlapEvent);
            totalOverlap += Math.max(minOverlap, overlap);
        }
        return totalOverlap;
    }

    protected void calculateVisibleEvents(double min, double max) {
        Epoch epoch = this.getEpoch();
        for (Row row : this.rows) {
            row.calculateVisibleEvents(epoch.toTimeStamp(min), epoch.toTimeStamp(max));
        }
        this.visibleEventsDirty = false;
    }

    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis1D axis) {
        int height = bounds.getHeight();
        int width = bounds.getWidth();
        if (this.newFont != null) {
            if (this.textRenderer != null) {
                this.textRenderer.dispose();
            }
            this.textRenderer = new TextRenderer(this.newFont, this.antialias, false);
            this.newFont = null;
        }
        if (this.textRenderer == null) {
            return;
        }
        if (this.visibleEventsDirty || axis.getMin() != this.prevMin || axis.getMax() != this.prevMax) {
            this.calculateVisibleEvents(axis.getMin(), axis.getMax());
        }
        int buffer = this.plot.getEventPadding();
        int rowSize = this.plot.getRowSize();
        int sizeMin = buffer;
        int sizeMax = buffer + rowSize;
        int size = this.rows.size();
        for (int i = 0; i < size; ++i) {
            Row row = this.rows.get(i);
            Event prev = null;
            for (Collection<Event> eventsAtTime : row.visibleEvents.values()) {
                for (Event event : eventsAtTime) {
                    if (prev != null) {
                        prev.paint(gl, axis, this, event, width, height, sizeMin, sizeMax);
                    }
                    prev = event;
                }
            }
            if (prev != null) {
                prev.paint(gl, axis, this, null, width, height, sizeMin, sizeMax);
            }
            sizeMin = sizeMax + buffer;
            sizeMax = sizeMax + buffer + rowSize;
        }
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        if (!this.fontSet) {
            this.setFont(laf.getFont(AbstractLookAndFeel.TITLE_FONT), false);
            this.fontSet = false;
        }
        if (!this.textColorSet) {
            this.textColor = laf.getColor(AbstractLookAndFeel.AXIS_TEXT_COLOR);
            this.textColorNoBackground = laf.getColor(AbstractLookAndFeel.AXIS_TEXT_COLOR);
            this.textColorSet = false;
        }
        if (!this.borderColorSet) {
            this.setBorderColor(laf.getColor(AbstractLookAndFeel.BORDER_COLOR));
            this.borderColorSet = false;
        }
    }

    protected class Row {
        int index;
        IntervalSortedMultimap events;
        SortedMap<TimeStamp, Collection<Event>> visibleEvents;

        public Row(int index) {
            this.index = index;
            this.events = new IntervalSortedMultimap();
        }

        public void addEvent(Event event) {
            this.events.addEvent(event);
            EventPainter.this.rowMap.put(event.getId(), this);
        }

        public void removeEvent(Event event) {
            this.events.removeEvent(event);
            EventPainter.this.rowMap.remove(event.getId());
        }

        public void calculateVisibleEvents(TimeStamp min, TimeStamp max) {
            SetMultimap<TimeStamp, Event> visibleMap = this.events.getMap(min, true, max, true);
            this.visibleEvents = (SortedMap)visibleMap.asMap();
        }

        public Set<Event> getOverlappingEvents(Event event) {
            return this.events.get(event.getStartTime(), false, event.getEndTime(), false);
        }

        public IntervalSortedMultimap getMap() {
            return this.events;
        }

        public boolean isEmpty() {
            return this.events.isEmpty();
        }

        public int size() {
            return this.events.size();
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }
    }
}

