/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.event;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.plot.timeline.data.EventConstraint;
import com.metsci.glimpse.plot.timeline.data.TimeSpan;
import com.metsci.glimpse.plot.timeline.event.EventPainter;
import com.metsci.glimpse.plot.timeline.event.EventPlotInfo;
import com.metsci.glimpse.support.atlas.TextureAtlas;
import com.metsci.glimpse.support.atlas.support.ImageData;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.util.units.time.TimeStamp;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.geom.Rectangle2D;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import javax.media.opengl.GL;

public class Event {
    public static final int ARROW_TIP_BUFFER = 2;
    public static final int ARROW_SIZE = 10;
    public static final float[] DEFAULT_COLOR = GlimpseColor.getGray();
    protected EventPlotInfo info;
    protected Object id;
    protected String label;
    protected Object iconId;
    protected String toolTipText;
    protected float[] backgroundColor;
    protected float[] borderColor;
    protected float[] textColor;
    protected float borderThickness = 1.8f;
    protected TimeStamp startTime;
    protected TimeStamp endTime;
    protected boolean fixedRow = false;
    protected int fixedRowIndex = 0;
    protected boolean showLabel = true;
    protected boolean showIcon = true;
    protected boolean showBorder = true;
    protected boolean showBackground = true;
    protected TextRenderingMode textRenderingMode = TextRenderingMode.Ellipsis;
    protected OverlapRenderingMode overlapRenderingMode = OverlapRenderingMode.Overfull;
    protected boolean isIconVisible;
    protected boolean isTextVisible;
    protected TimeStamp iconStartTime;
    protected TimeStamp iconEndTime;
    protected TimeStamp textStartTime;
    protected TimeStamp textEndTime;
    protected boolean isEditable = true;
    protected boolean isEndTimeMoveable = true;
    protected boolean isStartTimeMoveable = true;
    protected boolean isResizeable = true;
    protected double maxTimeSpan = Double.MAX_VALUE;
    protected double minTimeSpan = 0.0;
    protected List<EventConstraint> constraints;
    protected EventConstraint builtInConstraints = new EventConstraint(){

        @Override
        public TimeSpan applyConstraint(Event event, TimeSpan proposedTimeSpan) {
            if (!Event.this.isEditable) {
                return event.getTimeSpan();
            }
            TimeStamp oldStart = event.getStartTime();
            TimeStamp oldEnd = event.getEndTime();
            TimeStamp newStart = proposedTimeSpan.getStartTime();
            TimeStamp newEnd = proposedTimeSpan.getEndTime();
            if (!Event.this.isEndTimeMoveable) {
                newEnd = oldEnd;
            }
            if (!Event.this.isStartTimeMoveable) {
                newStart = oldStart;
            }
            double newDiff = newEnd.durationAfter(newStart);
            double oldDiff = oldEnd.durationAfter(oldStart);
            if (!Event.this.isResizeable && newDiff != oldDiff) {
                newEnd = oldEnd;
                newStart = oldStart;
            }
            if (newDiff < Event.this.minTimeSpan) {
                if (oldEnd.equals((Object)newEnd)) {
                    newStart = newEnd.subtract(Event.this.minTimeSpan);
                } else {
                    newEnd = newStart.add(Event.this.minTimeSpan);
                }
            }
            if (newDiff > Event.this.maxTimeSpan) {
                if (oldEnd.equals((Object)newEnd)) {
                    newStart = newEnd.subtract(Event.this.maxTimeSpan);
                } else {
                    newEnd = newStart.add(Event.this.maxTimeSpan);
                }
            }
            return new TimeSpan(newStart, newEnd);
        }
    };

    private Event(TimeStamp time) {
        this(null, null, time);
    }

    public Event(Object id, String name, TimeStamp time) {
        this.id = id;
        this.label = name;
        this.startTime = time;
        this.endTime = time;
        this.overlapRenderingMode = OverlapRenderingMode.Intersecting;
        this.constraints = new LinkedList<EventConstraint>();
        this.constraints.add(this.builtInConstraints);
    }

    public Event(Object id, String name, TimeStamp startTime, TimeStamp endTime) {
        this.id = id;
        this.label = name;
        this.startTime = startTime;
        this.endTime = endTime;
        this.overlapRenderingMode = startTime.equals((Object)endTime) ? OverlapRenderingMode.Intersecting : OverlapRenderingMode.Overfull;
        this.constraints = new LinkedList<EventConstraint>();
        this.constraints.add(this.builtInConstraints);
    }

    public void addConstraint(EventConstraint constraint) {
        this.constraints.add(constraint);
    }

    public void removeConstrain(EventConstraint constraint) {
        this.constraints.remove(constraint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(GL gl, Axis1D axis, EventPainter painter, Event next, int width, int height, int sizeMin, int sizeMax) {
        int nextStartPixel;
        int size = sizeMax - sizeMin;
        double sizeCenter = (double)sizeMin + (double)size / 2.0;
        int buffer = painter.getRowBufferSize();
        int arrowSize = Math.min(size, 10);
        Epoch epoch = painter.getEpoch();
        double timeMin = epoch.fromTimeStamp(this.startTime);
        double timeMax = epoch.fromTimeStamp(this.endTime);
        double arrowBaseMin = timeMin;
        boolean offEdgeMin = false;
        if (axis.getMin() > timeMin) {
            offEdgeMin = true;
            timeMin = axis.getMin() + 2.0 / axis.getPixelsPerValue();
            arrowBaseMin = timeMin + (double)arrowSize / axis.getPixelsPerValue();
        }
        double arrowBaseMax = timeMax;
        boolean offEdgeMax = false;
        if (axis.getMax() < timeMax) {
            offEdgeMax = true;
            timeMax = axis.getMax() - 2.0 / axis.getPixelsPerValue();
            arrowBaseMax = timeMax - (double)arrowSize / axis.getPixelsPerValue();
        }
        arrowBaseMax = Math.max(timeMin, arrowBaseMax);
        arrowBaseMin = Math.min(timeMax, arrowBaseMin);
        double timeSpan = arrowBaseMax - arrowBaseMin;
        double remainingSpaceX = axis.getPixelsPerValue() * timeSpan - (double)(buffer * 2);
        int pixelX = buffer + (offEdgeMin ? arrowSize : 0) + Math.max(0, axis.valueToScreenPixel(timeMin));
        double nextStartValue = next != null ? epoch.fromTimeStamp(next.getStartTime()) : axis.getMax();
        int n = nextStartPixel = next != null ? axis.valueToScreenPixel(nextStartValue) : width;
        if (painter.isHorizontal()) {
            if (!offEdgeMin && !offEdgeMax) {
                if (this.showBackground) {
                    GlimpseColor.glColor(gl, this.backgroundColor != null ? this.backgroundColor : painter.getBackgroundColor());
                    gl.glBegin(7);
                    try {
                        gl.glVertex2d(timeMin, (double)sizeMin);
                        gl.glVertex2d(timeMin, (double)sizeMax);
                        gl.glVertex2d(timeMax, (double)sizeMax);
                        gl.glVertex2d(timeMax, (double)sizeMin);
                    }
                    finally {
                        gl.glEnd();
                    }
                }
                if (this.showBorder) {
                    GlimpseColor.glColor(gl, this.borderColor != null ? this.borderColor : painter.getBorderColor());
                    gl.glLineWidth(this.borderThickness);
                    gl.glBegin(2);
                    try {
                        gl.glVertex2d(timeMin, (double)sizeMin);
                        gl.glVertex2d(timeMin, (double)sizeMax);
                        gl.glVertex2d(timeMax, (double)sizeMax);
                        gl.glVertex2d(timeMax, (double)sizeMin);
                    }
                    finally {
                        gl.glEnd();
                    }
                }
            } else {
                if (this.showBackground) {
                    GlimpseColor.glColor(gl, this.backgroundColor != null ? this.backgroundColor : painter.getBackgroundColor());
                    gl.glBegin(9);
                    try {
                        gl.glVertex2d(arrowBaseMin, (double)sizeMax);
                        gl.glVertex2d(arrowBaseMax, (double)sizeMax);
                        gl.glVertex2d(timeMax, sizeCenter);
                        gl.glVertex2d(arrowBaseMax, (double)sizeMin);
                        gl.glVertex2d(arrowBaseMin, (double)sizeMin);
                        gl.glVertex2d(timeMin, sizeCenter);
                    }
                    finally {
                        gl.glEnd();
                    }
                }
                if (this.showBorder) {
                    GlimpseColor.glColor(gl, this.borderColor != null ? this.borderColor : painter.getBorderColor());
                    gl.glLineWidth(this.borderThickness);
                    gl.glBegin(2);
                    try {
                        gl.glVertex2d(arrowBaseMin, (double)sizeMax);
                        gl.glVertex2d(arrowBaseMax, (double)sizeMax);
                        gl.glVertex2d(timeMax, sizeCenter);
                        gl.glVertex2d(arrowBaseMax, (double)sizeMin);
                        gl.glVertex2d(arrowBaseMin, (double)sizeMin);
                        gl.glVertex2d(timeMin, sizeCenter);
                    }
                    finally {
                        gl.glEnd();
                    }
                }
            }
            boolean bl = this.isIconVisible = this.showIcon && this.iconId != null && !this.isIconOverlapping(size, buffer, remainingSpaceX, pixelX, nextStartPixel);
            if (this.isIconVisible) {
                double valueX = axis.screenPixelToValue(pixelX);
                this.iconStartTime = epoch.toTimeStamp(valueX);
                this.iconEndTime = this.iconStartTime.add((double)size / axis.getPixelsPerValue());
                TextureAtlas atlas = painter.getTextureAtlas();
                atlas.beginRendering();
                try {
                    ImageData iconData = atlas.getImageData(this.iconId);
                    double iconScale = (double)size / (double)iconData.getHeight();
                    atlas.drawImageAxisX(gl, this.iconId, axis, valueX, sizeMin, iconScale, iconScale, 0, iconData.getHeight());
                }
                finally {
                    atlas.endRendering();
                }
                remainingSpaceX -= (double)(size + buffer);
                pixelX += size + buffer;
            }
            if (this.showLabel) {
                TextRenderer textRenderer = painter.getTextRenderer();
                Rectangle2D labelBounds = textRenderer.getBounds(this.label);
                boolean isTextOverfull = this.isTextOverfull(size, buffer, remainingSpaceX, pixelX, nextStartPixel, labelBounds);
                boolean isTextIntersecting = this.isTextIntersecting(size, buffer, remainingSpaceX, pixelX, nextStartPixel, labelBounds);
                boolean isTextOverlappingAndHidden = (isTextOverfull || isTextIntersecting) && this.textRenderingMode == TextRenderingMode.HideAll;
                double availableSpace = this.getTextAvailableSpace(size, buffer, remainingSpaceX, pixelX, nextStartPixel);
                boolean bl2 = this.isTextVisible = !isTextOverlappingAndHidden;
                if (this.isTextVisible) {
                    Rectangle2D displayBounds = labelBounds;
                    String displayText = this.label;
                    if (labelBounds.getWidth() > availableSpace && this.textRenderingMode != TextRenderingMode.ShowAll) {
                        displayText = this.calculateDisplayText(textRenderer, displayText, availableSpace);
                        displayBounds = textRenderer.getBounds(displayText);
                    }
                    double valueX = axis.screenPixelToValue(pixelX);
                    this.textStartTime = epoch.toTimeStamp(valueX);
                    this.textEndTime = this.textStartTime.add(displayBounds.getWidth() / axis.getPixelsPerValue());
                    if (this.textColor != null) {
                        GlimpseColor.setColor(textRenderer, this.textColor);
                    } else if (!painter.textColorSet && !this.showBackground) {
                        GlimpseColor.setColor(textRenderer, painter.textColorNoBackground);
                    } else {
                        GlimpseColor.setColor(textRenderer, painter.textColor);
                    }
                    textRenderer.beginRendering(width, height);
                    try {
                        int pixelY = (int)((double)size / 2.0 - labelBounds.getHeight() * 0.3 + (double)sizeMin);
                        textRenderer.draw(displayText, pixelX, pixelY);
                        remainingSpaceX -= displayBounds.getWidth() + (double)buffer;
                        pixelX = (int)((double)pixelX + (displayBounds.getWidth() + (double)buffer));
                    }
                    finally {
                        textRenderer.endRendering();
                    }
                }
            } else {
                this.isTextVisible = false;
            }
        } else {
            GlimpseColor.glColor(gl, this.backgroundColor != null ? this.backgroundColor : painter.getBackgroundColor());
            gl.glBegin(7);
            try {
                gl.glVertex2d((double)sizeMin, timeMin);
                gl.glVertex2d((double)sizeMax, timeMin);
                gl.glVertex2d((double)sizeMax, timeMax);
                gl.glVertex2d((double)sizeMin, timeMax);
            }
            finally {
                gl.glEnd();
            }
            GlimpseColor.glColor(gl, this.borderColor != null ? this.borderColor : painter.getBorderColor());
            gl.glLineWidth(this.borderThickness);
            gl.glBegin(2);
            try {
                gl.glVertex2d((double)sizeMin, timeMin);
                gl.glVertex2d((double)sizeMax, timeMin);
                gl.glVertex2d((double)sizeMax, timeMax);
                gl.glVertex2d((double)sizeMin, timeMax);
            }
            finally {
                gl.glEnd();
            }
        }
    }

    protected String calculateDisplayText(TextRenderer textRenderer, String fullText, double availableSpace) {
        for (int endIndex = fullText.length(); endIndex >= 0; --endIndex) {
            String subText = fullText.substring(0, endIndex) + "...";
            Rectangle2D bounds = textRenderer.getBounds(subText);
            if (!(bounds.getWidth() < availableSpace)) continue;
            return subText;
        }
        return "";
    }

    protected double getTextAvailableSpace(int size, int buffer, double remainingSpaceX, int pixelX, int nextStartPixel) {
        double insideBoxSpace = remainingSpaceX - (double)buffer;
        double outsideBoxSpace = nextStartPixel - pixelX - buffer;
        switch (this.overlapRenderingMode) {
            case Overfull: {
                return insideBoxSpace;
            }
            case Intersecting: {
                return outsideBoxSpace;
            }
        }
        return Double.MAX_VALUE;
    }

    protected boolean isTextOverfull(int size, int buffer, double remainingSpaceX, int pixelX, int nextStartPixel, Rectangle2D bounds) {
        return bounds.getWidth() + (double)buffer > remainingSpaceX && this.overlapRenderingMode == OverlapRenderingMode.Overfull;
    }

    protected boolean isTextIntersecting(int size, int buffer, double remainingSpaceX, int pixelX, int nextStartPixel, Rectangle2D bounds) {
        return (double)pixelX + bounds.getWidth() + (double)buffer > (double)nextStartPixel && this.overlapRenderingMode == OverlapRenderingMode.Intersecting;
    }

    protected boolean isIconOverlapping(int size, int buffer, double remainingSpaceX, int pixelX, int nextStartPixel) {
        return (double)(size + buffer) > remainingSpaceX && this.overlapRenderingMode == OverlapRenderingMode.Overfull || pixelX + size + buffer > nextStartPixel && this.overlapRenderingMode == OverlapRenderingMode.Intersecting;
    }

    public void setToolTipText(String text) {
        this.toolTipText = text;
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public void setEditable(boolean isEditable) {
        this.isEditable = isEditable;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean isEndTimeMoveable() {
        return this.isEndTimeMoveable;
    }

    public void setEndTimeMoveable(boolean isEndTimeMoveable) {
        this.isEndTimeMoveable = isEndTimeMoveable;
    }

    public boolean isStartTimeMoveable() {
        return this.isStartTimeMoveable;
    }

    public void setStartTimeMoveable(boolean isStartTimeMoveable) {
        this.isStartTimeMoveable = isStartTimeMoveable;
    }

    public boolean isResizeable() {
        return this.isResizeable;
    }

    public void setResizeable(boolean isResizeable) {
        this.isResizeable = isResizeable;
    }

    public double getMaxTimeSpan() {
        return this.maxTimeSpan;
    }

    public void setMaxTimeSpan(double maxTimeSpan) {
        this.maxTimeSpan = maxTimeSpan;
    }

    public double getMinTimeSpan() {
        return this.minTimeSpan;
    }

    public void setMinTimeSpan(double minTimeSpan) {
        this.minTimeSpan = minTimeSpan;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String name) {
        this.label = name;
    }

    public String getName() {
        return this.label;
    }

    public void setName(String name) {
        this.label = name;
    }

    public Object getIconId() {
        return this.iconId;
    }

    public void setIconId(Object iconId) {
        this.iconId = iconId;
    }

    public void setBorderThickness(float thickness) {
        this.borderThickness = thickness;
    }

    public float getBorderThickness() {
        return this.borderThickness;
    }

    public float[] getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(float[] backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public float[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(float[] borderColor) {
        this.borderColor = borderColor;
    }

    public float[] getLabelColor() {
        return this.textColor;
    }

    public void setLabelColor(float[] textColor) {
        this.textColor = textColor;
    }

    public void setTimes(TimeStamp startTime, TimeStamp endTime, boolean force) {
        if (!force) {
            TimeSpan newTimes = this.applyConstraints(new TimeSpan(startTime, endTime));
            startTime = newTimes.getStartTime();
            endTime = newTimes.getEndTime();
        }
        if (this.info == null) {
            this.startTime = startTime;
            this.endTime = endTime;
        } else {
            this.info.updateEvent(this, startTime, endTime);
        }
    }

    public int getRow() {
        if (this.info != null) {
            return this.info.getRow(this.id);
        }
        return 0;
    }

    public boolean isFixedRow() {
        return this.fixedRow;
    }

    protected int getFixedRow() {
        return this.fixedRowIndex;
    }

    public void setFloatingRow() {
        this.fixedRow = false;
    }

    public void setFixedRow(int rowIndex) {
        this.fixedRow = true;
        this.fixedRowIndex = rowIndex;
        if (this.info != null) {
            this.info.updateEventRow(this, rowIndex);
        }
    }

    protected TimeSpan applyConstraints(TimeSpan span) {
        for (EventConstraint constraint : this.constraints) {
            span = constraint.applyConstraint(this, span);
        }
        return span;
    }

    public void setTimes(TimeStamp startTime, TimeStamp endTime) {
        this.setTimes(startTime, endTime, false);
    }

    protected void setTimes0(TimeStamp startTime, TimeStamp endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public TimeStamp getStartTime() {
        return this.startTime;
    }

    public void setStartTime(TimeStamp startTime) {
        this.setTimes(startTime, this.endTime);
    }

    protected void setStartTime0(TimeStamp startTime) {
        this.startTime = startTime;
    }

    public TimeStamp getEndTime() {
        return this.endTime;
    }

    public void setEndTime(TimeStamp endTime) {
        this.setTimes(this.startTime, endTime);
    }

    protected void setEndTime0(TimeStamp endTime) {
        this.endTime = endTime;
    }

    public TimeSpan getTimeSpan() {
        return new TimeSpan(this.startTime, this.endTime);
    }

    public boolean isShowLabel() {
        return this.showLabel;
    }

    public boolean isLabelVisible() {
        return this.isTextVisible;
    }

    public void setShowLabel(boolean showName) {
        this.showLabel = showName;
    }

    public void setOverlapMode(OverlapRenderingMode mode) {
        this.overlapRenderingMode = mode;
    }

    public OverlapRenderingMode getOverlapRenderingMode() {
        return this.overlapRenderingMode;
    }

    public void setTextRenderingMode(TextRenderingMode mode) {
        this.textRenderingMode = mode;
    }

    public TextRenderingMode getTextRenderingMode() {
        return this.textRenderingMode;
    }

    public boolean isShowIcon() {
        return this.showIcon;
    }

    public boolean isIconVisible() {
        return this.isIconVisible;
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
    }

    public boolean isShowBackground() {
        return this.showBackground;
    }

    public void setShowBackground(boolean showBorder) {
        this.showBackground = showBorder;
    }

    public boolean isShowBorder() {
        return this.showBorder;
    }

    public void setShowBorder(boolean showBorder) {
        this.showBorder = showBorder;
    }

    public Object getId() {
        return this.id;
    }

    public TimeStamp getIconStartTime() {
        return this.iconStartTime;
    }

    public TimeStamp getIconEndTime() {
        return this.iconEndTime;
    }

    public TimeStamp getLabelStartTime() {
        return this.textStartTime;
    }

    public TimeStamp getLabelEndTime() {
        return this.textEndTime;
    }

    public EventPlotInfo getEventPlotInfo() {
        return this.info;
    }

    public double getOverlapTime(Event event) {
        double maxStart = Math.max(event.getStartTime().toPosixSeconds(), this.getStartTime().toPosixSeconds());
        double minEnd = Math.min(event.getEndTime().toPosixSeconds(), this.getEndTime().toPosixSeconds());
        return Math.max(0.0, minEnd - maxStart);
    }

    public double getDuration() {
        return this.startTime.durationBefore(this.endTime);
    }

    protected void setEventPlotInfo(EventPlotInfo info) {
        this.info = info;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Event other = (Event)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return String.format("%s (%s)", this.label, this.id);
    }

    public static Event createDummyEvent(Event event) {
        TimeStamp startTime = TimeStamp.fromTimeStamp((TimeStamp)event.getStartTime());
        TimeStamp endTime = TimeStamp.fromTimeStamp((TimeStamp)event.getEndTime());
        return new Event(event.getId(), null, startTime, endTime);
    }

    public static Event createDummyEvent(TimeStamp time) {
        return new Event(time);
    }

    public static Comparator<Event> getStartTimeComparator() {
        return new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                int c_time = o1.getStartTime().compareTo(o2.getStartTime());
                if (c_time == 0) {
                    if (o1.getId() == null && o2.getId() == null) {
                        return 0;
                    }
                    if (o1.getId() == null) {
                        return -1;
                    }
                    if (o2.getId() == null) {
                        return 1;
                    }
                    return 0;
                }
                return c_time;
            }
        };
    }

    public static Comparator<Event> getEndTimeComparator() {
        return new Comparator<Event>(){

            @Override
            public int compare(Event o1, Event o2) {
                return o1.getEndTime().compareTo(o2.getEndTime());
            }
        };
    }

    public static enum OverlapRenderingMode {
        None,
        Overfull,
        Intersecting;

    }

    public static enum TextRenderingMode {
        ShowAll,
        HideAll,
        Ellipsis;

    }
}

