/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline.data;

import com.metsci.glimpse.plot.timeline.event.Event;
import java.util.EnumSet;

public class EventSelection {
    protected Event event;
    protected EnumSet<Location> locations;

    public EventSelection(Event event, EnumSet<Location> locations) {
        this.event = event;
        this.locations = locations;
    }

    public Event getEvent() {
        return this.event;
    }

    public EnumSet<Location> getLocations() {
        return this.locations;
    }

    public boolean isIconSelection() {
        return this.locations.contains((Object)Location.Icon);
    }

    public boolean isTextSelection() {
        return this.locations.contains((Object)Location.Icon);
    }

    public boolean isStartTimeSelection() {
        return this.locations.contains((Object)Location.Start);
    }

    public boolean isEndTimeSelection() {
        return this.locations.contains((Object)Location.End);
    }

    public boolean isCenterSelection() {
        return this.locations.contains((Object)Location.Center);
    }

    public boolean isLocation(Location ... locationList) {
        for (Location location : locationList) {
            if (!this.locations.contains((Object)location)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.event == null ? 0 : this.event.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventSelection other = (EventSelection)obj;
        return !(this.event == null ? other.event != null : !this.event.equals(other.event));
    }

    public String toString() {
        return String.format("%s %s", this.event, this.locations);
    }

    public static enum Location {
        Start,
        End,
        Center,
        Icon,
        Label;

    }
}

