/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener1D;
import com.metsci.glimpse.axis.painter.NumericXYAxisPainter;
import com.metsci.glimpse.axis.painter.TimeAxisPainter;
import com.metsci.glimpse.axis.painter.TimeXAxisPainter;
import com.metsci.glimpse.axis.painter.TimeYAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.GridAxisLabelHandler;
import com.metsci.glimpse.axis.tagged.Constraint;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseMotionListener;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseAxisLayoutX;
import com.metsci.glimpse.layout.GlimpseAxisLayoutY;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.painter.decoration.GridPainter;
import com.metsci.glimpse.painter.group.DelegatePainter;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.painter.info.TooltipPainter;
import com.metsci.glimpse.plot.stacked.PlotInfo;
import com.metsci.glimpse.plot.stacked.PlotInfoWrapper;
import com.metsci.glimpse.plot.stacked.StackedPlot2D;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.plot.timeline.event.EventPlotInfo;
import com.metsci.glimpse.plot.timeline.layout.TimePlotInfo;
import com.metsci.glimpse.plot.timeline.layout.TimePlotInfoImpl;
import com.metsci.glimpse.plot.timeline.listener.DataAxisMouseListener1D;
import com.metsci.glimpse.plot.timeline.listener.TimeAxisMouseListener1D;
import com.metsci.glimpse.plot.timeline.painter.SelectedTimeRegionPainter;
import com.metsci.glimpse.support.atlas.TextureAtlas;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.util.units.time.Time;
import com.metsci.glimpse.util.units.time.TimeStamp;
import java.awt.Font;
import java.util.Collection;
import java.util.LinkedList;
import java.util.UUID;

public class StackedTimePlot2D
extends StackedPlot2D {
    public static final String MIN_TIME = "min_time";
    public static final String MAX_TIME = "max_time";
    public static final String CURRENT_TIME = "current_time";
    public static final String BACKGROUND = "Timeline Background";
    public static final String TIMELINE = "Timeline";
    protected Tag minTag;
    protected Tag maxTag;
    protected Tag currentTag;
    protected Epoch epoch;
    protected PlotInfo timelineInfo;
    protected GlimpseAxisLayout1D timeLayout;
    protected DelegatePainter timeAxisDelegate;
    protected TimeAxisPainter timeAxisPainter;
    protected PlotInfo selectedLayout;
    protected AxisMouseListener1D timelineMouseListener;
    protected SimpleTextPainter timeUnitsPainter;
    protected BorderPainter timeAxisBorderPainter;
    protected SelectedTimeRegionPainter selectedTimePainter;
    protected TooltipPainter tooltipPainter;
    protected boolean allowPanX = true;
    protected boolean allowPanY = true;
    protected boolean allowZoomX = true;
    protected boolean allowZoomY = true;
    protected boolean allowSelectionLock = true;
    protected boolean currentTimeLock;
    protected int labelLayoutSize;
    protected boolean showLabelLayout = false;
    protected boolean showTimeline = true;
    protected TextureAtlas defaultTextureAtlas;

    public StackedTimePlot2D() {
        this(StackedPlot2D.Orientation.VERTICAL, Epoch.posixEpoch());
    }

    public StackedTimePlot2D(Epoch epoch) {
        this(StackedPlot2D.Orientation.VERTICAL, epoch);
    }

    public StackedTimePlot2D(StackedPlot2D.Orientation orientation) {
        this(orientation, Epoch.posixEpoch());
    }

    public StackedTimePlot2D(StackedPlot2D.Orientation orientation, Epoch epoch) {
        this(orientation, epoch, new TextureAtlas());
    }

    public StackedTimePlot2D(StackedPlot2D.Orientation orientation, Epoch epoch, TextureAtlas atlas) {
        this(orientation, epoch, atlas, null);
    }

    public StackedTimePlot2D(StackedPlot2D.Orientation orientation, Epoch epoch, TaggedAxis1D commonAxis) {
        this(orientation, epoch, new TextureAtlas(), commonAxis);
    }

    public StackedTimePlot2D(StackedPlot2D.Orientation orientation, Epoch epoch, TextureAtlas atlas, TaggedAxis1D commonAxis) {
        super(orientation, commonAxis);
        this.epoch = epoch;
        this.defaultTextureAtlas = atlas;
        this.initializeTimePlot();
        this.initializeOverlayPainters();
    }

    public void setShowTimeline(boolean showTimeline) {
        this.showTimeline = showTimeline;
        this.timelineInfo.getLayout().setVisible(showTimeline);
        if (this.isAutoValidate()) {
            this.validate();
        }
    }

    public boolean isShowTimeline() {
        return this.showTimeline;
    }

    @Override
    protected int getOverlayLayoutOffsetX() {
        return this.orient == StackedPlot2D.Orientation.VERTICAL ? this.labelLayoutSize : 0;
    }

    @Override
    protected int getOverlayLayoutOffsetY2() {
        return this.orient == StackedPlot2D.Orientation.VERTICAL ? 0 : -this.labelLayoutSize;
    }

    @Override
    public void setPlotSpacing(int size) {
        this.plotSpacing = size;
        for (PlotInfo info : this.stackedPlots.values()) {
            if (info.equals(this.timelineInfo)) continue;
            info.setPlotSpacing(size);
        }
        if (this.isAutoValidate()) {
            this.validate();
        }
    }

    public GlimpseAxisLayout1D getOverlayLayout() {
        return this.overlayLayout;
    }

    public GlimpseAxisLayout1D getUnderlayLayout() {
        return this.underlayLayout;
    }

    public GlimpseAxisLayout1D getTimelineLayout() {
        return this.timeLayout;
    }

    public TooltipPainter getTooltipPainter() {
        return this.tooltipPainter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<TimePlotInfo> getAllTimePlots() {
        this.lock.lock();
        try {
            LinkedList<TimePlotInfo> list = new LinkedList<TimePlotInfo>();
            for (PlotInfo plot : this.getAllPlots()) {
                if (!(plot instanceof TimePlotInfo)) continue;
                list.add((TimePlotInfo)plot);
            }
            LinkedList<TimePlotInfo> linkedList = list;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimePlotInfo getTimePlot(Object id) {
        this.lock.lock();
        try {
            PlotInfo plot = this.getPlot(id);
            if (plot instanceof TimePlotInfo) {
                TimePlotInfo timePlotInfo = (TimePlotInfo)plot;
                return timePlotInfo;
            }
            TimePlotInfo timePlotInfo = null;
            return timePlotInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventPlotInfo getEventPlot(Object id) {
        this.lock.lock();
        try {
            PlotInfo plot = this.getPlot(id);
            if (plot instanceof EventPlotInfo) {
                EventPlotInfo eventPlotInfo = (EventPlotInfo)plot;
                return eventPlotInfo;
            }
            EventPlotInfo eventPlotInfo = null;
            return eventPlotInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setSelectedPlot(Object id) {
        this.setSelectedPlot(this.getPlot(id));
    }

    public void setSelectedPlot(PlotInfo layout) {
        this.selectedLayout = layout;
    }

    public PlotInfo getSelectedPlot() {
        return this.selectedLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeAxisMouseListener(AxisMouseListener1D listener) {
        this.lock.lock();
        try {
            if (this.timelineMouseListener != null) {
                this.underlayLayout.removeGlimpseMouseAllListener(this.timelineMouseListener);
            }
            if (listener != null) {
                this.underlayLayout.addGlimpseMouseAllListener(listener);
            }
            this.timelineMouseListener = listener;
        }
        finally {
            this.lock.unlock();
        }
    }

    public AxisMouseListener1D getTimeAxisMouseListener() {
        return this.timelineMouseListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowSelectionLock(boolean lock) {
        this.lock.lock();
        try {
            this.allowSelectionLock = lock;
            this.timelineMouseListener.setAllowSelectionLock(lock);
            for (TimePlotInfo info : this.getAllTimePlots()) {
                info.getDataAxisMouseListener().setAllowSelectionLock(lock);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowZoomY(boolean lock) {
        this.lock.lock();
        try {
            this.allowZoomY = lock;
            if (this.getOrientation() == StackedPlot2D.Orientation.HORIZONTAL) {
                this.timelineMouseListener.setAllowZoom(lock);
            } else {
                for (TimePlotInfo info : this.getAllTimePlots()) {
                    info.getDataAxisMouseListener().setAllowZoom(lock);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowZoomX(boolean lock) {
        this.lock.lock();
        try {
            this.allowZoomX = lock;
            if (this.getOrientation() == StackedPlot2D.Orientation.VERTICAL) {
                this.timelineMouseListener.setAllowZoom(lock);
            } else {
                for (TimePlotInfo info : this.getAllTimePlots()) {
                    info.getDataAxisMouseListener().setAllowZoom(lock);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowPanY(boolean lock) {
        this.lock.lock();
        try {
            this.allowPanY = lock;
            if (this.getOrientation() == StackedPlot2D.Orientation.HORIZONTAL) {
                this.timelineMouseListener.setAllowPan(lock);
            } else {
                for (TimePlotInfo info : this.getAllTimePlots()) {
                    info.getDataAxisMouseListener().setAllowPan(lock);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllowPanX(boolean lock) {
        this.lock.lock();
        try {
            this.allowPanX = lock;
            if (this.getOrientation() == StackedPlot2D.Orientation.VERTICAL) {
                this.timelineMouseListener.setAllowPan(lock);
            } else {
                for (TimePlotInfo info : this.getAllTimePlots()) {
                    info.getDataAxisMouseListener().setAllowPan(lock);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTimeAxisPainter(TimeAxisPainter painter) {
        this.lock.lock();
        try {
            this.timeAxisDelegate.removePainter(this.timeAxisPainter);
            this.timeAxisPainter = painter;
            this.timeAxisDelegate.addPainter(this.timeAxisPainter);
        }
        finally {
            this.lock.unlock();
        }
    }

    public Tag getTimeSelectionTag() {
        return this.currentTag;
    }

    public Tag getTimeSelectionMinTag() {
        return this.minTag;
    }

    public Tag getTimeSelectionMaxTag() {
        return this.maxTag;
    }

    public TimeStamp getTimeSelection() {
        return this.epoch.toTimeStamp(this.currentTag.getValue());
    }

    public TimeStamp getTimeSelectionMin() {
        return this.epoch.toTimeStamp(this.minTag.getValue());
    }

    public TimeStamp getTimeSelectionMax() {
        return this.epoch.toTimeStamp(this.maxTag.getValue());
    }

    public Epoch getEpoch() {
        return this.epoch;
    }

    public void setEpoch(Epoch epoch) {
        this.epoch = epoch;
        this.timeAxisPainter.setEpoch(epoch);
    }

    public TimeStamp toTimeStamp(double value) {
        return this.epoch.toTimeStamp(value);
    }

    public double fromTimeStamp(TimeStamp value) {
        return this.epoch.fromTimeStamp(value);
    }

    public TaggedAxis1D getTimeAxis() {
        return (TaggedAxis1D)this.commonAxis;
    }

    public TimeAxisPainter getTimeAxisPainter() {
        return this.timeAxisPainter;
    }

    public SimpleTextPainter getTimeUnitsPainter() {
        return this.timeUnitsPainter;
    }

    public BorderPainter getTimeAxisBorderPainter() {
        return this.timeAxisBorderPainter;
    }

    public SelectedTimeRegionPainter getSelectedTimePainter() {
        return this.selectedTimePainter;
    }

    public PlotInfo getTimelinePlotInfo() {
        return this.timelineInfo;
    }

    public void setAxisColor(float[] rgba) {
        this.timeAxisPainter.setTextColor(rgba);
        this.timeAxisPainter.setTickColor(rgba);
    }

    public void setAxisFont(Font font) {
        this.timeAxisPainter.setFont(font);
    }

    public void setShowCurrentTime(boolean show) {
        this.timeAxisPainter.showCurrentTimeLabel(show);
    }

    public void setCurrentTimeColor(float[] rgba) {
        this.timeAxisPainter.setCurrentTimeTextColor(rgba);
        this.timeAxisPainter.setCurrentTimeTickColor(rgba);
    }

    public void setLabelSize(int size) {
        this.labelLayoutSize = size;
        this.validateLayout();
    }

    public void showLabels(boolean show) {
        this.showLabelLayout = show;
        this.validateLayout();
    }

    public int getLabelSize() {
        return this.labelLayoutSize;
    }

    public boolean isShowLabels() {
        return this.showLabelLayout;
    }

    public boolean isTimeAxisHorizontal() {
        return this.getOrientation() == StackedPlot2D.Orientation.VERTICAL;
    }

    public GlimpseTargetStack pushLayoutTargetStack(GlimpseTargetStack stack, Object id) {
        stack = this.pushPlotTargetStack(stack);
        PlotInfo plot = this.getPlot(id);
        stack.push(plot.getLayout());
        return stack;
    }

    public GlimpseTargetStack pushPlotTargetStack(GlimpseTargetStack stack) {
        stack.push(this);
        return stack;
    }

    public TimePlotInfo createTimePlot() {
        return this.createTimePlot(UUID.randomUUID());
    }

    public TimePlotInfo createTimePlot(Object id) {
        return this.createTimePlot(id, new Axis1D());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimePlotInfo createTimePlot(Object id, Axis1D axis) {
        this.lock.lock();
        try {
            PlotInfo plotInfo = this.createPlot0(id, axis);
            TimePlotInfo timePlotInfo = this.createTimePlot0(plotInfo);
            this.stackedPlots.put(id, timePlotInfo);
            if (this.isAutoValidate()) {
                this.validate();
            }
            TimePlotInfo timePlotInfo2 = timePlotInfo;
            return timePlotInfo2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public TextureAtlas getTextureAtlas() {
        return this.defaultTextureAtlas;
    }

    public EventPlotInfo createEventPlot() {
        return this.createEventPlot(UUID.randomUUID());
    }

    public EventPlotInfo createEventPlot(Object id) {
        return this.createEventPlot(id, this.defaultTextureAtlas);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventPlotInfo createEventPlot(Object id, TextureAtlas atlas) {
        if (!this.isTimeAxisHorizontal()) {
            throw new UnsupportedOperationException("Event Plots are currently not supported by HORIZTONAL StackedTimePlot2D");
        }
        this.lock.lock();
        try {
            PlotInfo plotInfo = this.createPlot0(id, new Axis1D());
            EventPlotInfo timePlotInfo = this.createEventPlot0(plotInfo, atlas);
            this.stackedPlots.put(id, timePlotInfo);
            if (this.isAutoValidate()) {
                this.validate();
            }
            EventPlotInfo eventPlotInfo = timePlotInfo;
            return eventPlotInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean isLocked() {
        return this.isSelectionLocked() || this.isCurrentTimeLocked();
    }

    public boolean isSelectionLocked() {
        return this.getTimeAxis().isSelectionLocked();
    }

    public void setSelectionLocked(boolean lock) {
        this.getTimeAxis().setSelectionLock(lock);
        this.getTimeAxis().validate();
    }

    public boolean isCurrentTimeLocked() {
        return this.currentTimeLock;
    }

    public void setCurrentTimeLocked(boolean lock) {
        this.currentTimeLock = lock;
        if (lock) {
            double maxValue = this.maxTag.getValue();
            TimeStamp maxTime = this.epoch.toTimeStamp(maxValue);
            this.shiftTimeSelection(maxTime);
            this.shiftTimeAxisBounds(maxTime);
            this.getTimeAxis().lockMax(maxValue);
        } else {
            this.getTimeAxis().unlockMax();
        }
        this.getTimeAxis().validate();
    }

    public void setTimeSelection(TimeStamp minTime, TimeStamp selectedTime, TimeStamp maxTime) {
        this.minTag.setValue(this.epoch.fromTimeStamp(minTime));
        this.maxTag.setValue(this.epoch.fromTimeStamp(maxTime));
        this.currentTag.setValue(this.epoch.fromTimeStamp(selectedTime));
        TaggedAxis1D axis = this.getTimeAxis();
        axis.validateTags();
        axis.validate();
        if (this.isCurrentTimeLocked()) {
            this.shiftTimeAxisBounds(maxTime);
        }
    }

    public void setTimeAxisBounds(TimeStamp minTime, TimeStamp maxTime) {
        TaggedAxis1D axis = this.getTimeAxis();
        axis.setMax(this.epoch.fromTimeStamp(maxTime));
        axis.setMin(this.epoch.fromTimeStamp(minTime));
        axis.validate();
        if (this.isCurrentTimeLocked()) {
            this.shiftTimeSelection(maxTime);
        }
    }

    public void shiftTimeAxisBounds(TimeStamp maxTime) {
        TaggedAxis1D axis = this.getTimeAxis();
        double diff = axis.getMax() - axis.getMin();
        double max = this.epoch.fromTimeStamp(maxTime);
        axis.setMax(max);
        axis.setMin(max - diff);
        axis.validate();
    }

    public void setTimeSelection(TimeStamp minTime, TimeStamp maxTime) {
        this.setTimeSelection(minTime, maxTime, maxTime);
    }

    public void shiftTimeSelection(TimeStamp maxTime) {
        double diff = Time.fromSeconds((double)(this.maxTag.getValue() - this.minTag.getValue()));
        TimeStamp minTime = maxTime.subtract(diff);
        this.setTimeSelection(minTime, maxTime, maxTime);
    }

    protected void initializeOverlayPainters() {
        this.selectedTimePainter = new SelectedTimeRegionPainter(this);
        this.tooltipPainter = new TooltipPainter(this.defaultTextureAtlas);
        this.overlayLayout.addGlimpseMouseMotionListener(new GlimpseMouseMotionListener(){

            @Override
            public void mouseMoved(GlimpseMouseEvent e) {
                StackedTimePlot2D.this.tooltipPainter.setLocation(e);
            }
        });
        this.overlayLayout.addPainter(this.selectedTimePainter);
        this.overlayLayout.addPainter(this.tooltipPainter);
        this.timelineMouseListener = this.createTimeAxisListener();
        this.underlayLayout.addGlimpseMouseAllListener(this.timelineMouseListener);
    }

    protected void initializeTimePlot() {
        TaggedAxis1D timeAxis = this.getTimeAxis();
        this.addTimeTags(this.getTimeAxis());
        this.minTag = timeAxis.getTag(MIN_TIME);
        this.maxTag = timeAxis.getTag(MAX_TIME);
        this.currentTag = timeAxis.getTag(CURRENT_TIME);
        PlotInfo info = this.createPlot(TIMELINE);
        this.timelineInfo = new PlotInfoWrapper(info){

            protected boolean doAnyOtherPlotsGrow() {
                for (PlotInfo plot : StackedTimePlot2D.this.getAllPlots()) {
                    if (this == plot || !plot.isGrow()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void updateLayout(int index) {
                this.setGrow(!this.doAnyOtherPlotsGrow());
                super.updateLayout(index);
                if (StackedTimePlot2D.this.timeLayout == null) {
                    return;
                }
                if (StackedTimePlot2D.this.isTimeAxisHorizontal()) {
                    StackedTimePlot2D.this.timeLayout.setLayoutData(String.format("push, grow, gapleft %d!", StackedTimePlot2D.this.labelLayoutSize));
                } else {
                    StackedTimePlot2D.this.timeLayout.setLayoutData(String.format("push, grow, gaptop %d!", StackedTimePlot2D.this.labelLayoutSize));
                }
            }
        };
        this.stackedPlots.put(this.timelineInfo.getId(), this.timelineInfo);
        this.timelineInfo.setPlotSpacing(0);
        if (this.isTimeAxisHorizontal()) {
            this.timelineInfo.setSize(45);
            this.timelineInfo.setOrder(Integer.MAX_VALUE);
            this.timeLayout = new GlimpseAxisLayoutX(this.timelineInfo.getLayout());
            this.timeLayout.setEventConsumer(false);
            this.labelLayoutSize = 30;
        } else {
            this.timelineInfo.setSize(60);
            this.timelineInfo.setOrder(Integer.MIN_VALUE);
            this.timeLayout = new GlimpseAxisLayoutY(this.timelineInfo.getLayout());
            this.timeLayout.setEventConsumer(false);
            this.labelLayoutSize = 30;
        }
        this.timelineInfo.getLayout().setEventConsumer(false);
        this.timeAxisPainter = this.createTimeAxisPainter();
        this.timeAxisPainter.setFont(FontUtils.getDefaultPlain(12.0f), false);
        this.timeAxisPainter.showCurrentTimeLabel(false);
        this.timeAxisPainter.setCurrentTimeTickColor(GlimpseColor.getGreen());
        this.setBorderSize(0);
        this.timeAxisDelegate = new DelegatePainter();
        this.timeAxisDelegate.addPainter(this.timeAxisPainter);
        this.timeLayout.addPainter(this.timeAxisDelegate);
        this.timeUnitsPainter = new SimpleTextPainter();
        this.timeUnitsPainter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Right);
        this.timeUnitsPainter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Bottom);
        this.timeUnitsPainter.setColor(GlimpseColor.getBlack());
        this.timeUnitsPainter.setFont(FontUtils.getDefaultBold(12.0f));
        this.timeUnitsPainter.setText("GMT");
        this.timeUnitsPainter.setBackgroundColor(GlimpseColor.getYellow());
        this.timeUnitsPainter.setPaintBackground(true);
        this.timeAxisBorderPainter = new BorderPainter();
        this.timeAxisBorderPainter.setVisible(false);
        this.timeLayout.addPainter(this.timeUnitsPainter);
        this.timeLayout.addPainter(this.timeAxisBorderPainter);
        this.validate();
    }

    protected DataAxisMouseListener1D createDataAxisListener(PlotInfo plotInfo) {
        return new DataAxisMouseListener1D(this, plotInfo);
    }

    protected TimeAxisMouseListener1D createTimeAxisListener() {
        return new TimeAxisMouseListener1D(this);
    }

    protected TimeAxisPainter createTimeAxisPainter() {
        TimeAxisPainter painter = this.isTimeAxisHorizontal() ? new TimeXAxisPainter(this.epoch) : new TimeYAxisPainter(this.epoch);
        painter.setFont(FontUtils.getDefaultPlain(12.0f), false);
        painter.showCurrentTimeLabel(false);
        painter.setCurrentTimeTickColor(GlimpseColor.getGreen());
        return painter;
    }

    protected void addTimeTags(TaggedAxis1D axis) {
        axis.addTag(MIN_TIME, 0.0);
        axis.addTag(MAX_TIME, 10.0);
        axis.addTag(CURRENT_TIME, 10.0);
        axis.addConstraint(new Constraint(){

            @Override
            public void applyConstraint(TaggedAxis1D axis) {
                Tag minTag = axis.getTag(StackedTimePlot2D.MIN_TIME);
                Tag maxTag = axis.getTag(StackedTimePlot2D.MAX_TIME);
                Tag currentTag = axis.getTag(StackedTimePlot2D.CURRENT_TIME);
                double minValue = minTag.getValue();
                double maxValue = maxTag.getValue();
                double currentValue = currentTag.getValue();
                if (minValue > maxValue) {
                    minTag.setValue(maxValue);
                }
                if (currentValue < minValue) {
                    currentTag.setValue(minValue);
                } else if (currentValue > maxValue) {
                    currentTag.setValue(maxValue);
                }
            }

            @Override
            public String getName() {
                return "order";
            }
        });
    }

    @Override
    protected TaggedAxis1D createCommonAxis() {
        return new TaggedAxis1D();
    }

    protected EventPlotInfo createEventPlot0(PlotInfo plotInfo, TextureAtlas atlas) {
        TimePlotInfo timePlot = this.createTimePlot0(plotInfo);
        timePlot.getAxisPainter().setVisible(false);
        timePlot.getGridPainter().setVisible(false);
        timePlot.getLabelPainter().setVerticalPosition(SimpleTextPainter.VerticalPosition.Center);
        timePlot.getLayout().setEventConsumer(false);
        EventPlotInfo eventPlotInfo = new EventPlotInfo(timePlot, atlas);
        eventPlotInfo.setLookAndFeel(this.laf);
        return eventPlotInfo;
    }

    protected EventPlotInfo createEventPlot0(PlotInfo plotInfo) {
        return this.createEventPlot0(plotInfo, this.defaultTextureAtlas);
    }

    protected TimePlotInfo createTimePlot0(PlotInfo plotInfo) {
        AxisLabelHandler yHandler;
        AxisLabelHandler xHandler;
        GridAxisLabelHandler labelHandler = new GridAxisLabelHandler(){

            @Override
            protected String tickString(double number, int orderAxis) {
                return this.tickNumberFormatter.format(number);
            }

            @Override
            protected void updateFormatter(int orderAxis, int orderTick) {
                this.tickNumberFormatter.setMaximumFractionDigits(Math.abs(orderTick));
            }
        };
        GlimpseAxisLayout2D layout2D = plotInfo.getLayout();
        layout2D.setEventConsumer(false);
        GlimpseAxisLayout2D plotLayout = new GlimpseAxisLayout2D(layout2D, String.format("%s-plot", plotInfo.getId()), layout2D.getAxis());
        plotLayout.setEventConsumer(false);
        BackgroundPainter backgroundPainter = new BackgroundPainter(false);
        plotLayout.addPainter((GlimpsePainter)backgroundPainter, Integer.MIN_VALUE);
        DelegatePainter dataPainter = new DelegatePainter();
        plotLayout.addPainter(dataPainter);
        if (this.orient == StackedPlot2D.Orientation.HORIZONTAL) {
            xHandler = labelHandler;
            yHandler = this.timeAxisPainter.getLabelHandler();
        } else {
            yHandler = labelHandler;
            xHandler = this.timeAxisPainter.getLabelHandler();
        }
        GridPainter gridPainter = new GridPainter(xHandler, yHandler);
        gridPainter.setShowMinorGrid(false);
        plotLayout.addPainter(gridPainter);
        NumericXYAxisPainter axisPainter = new NumericXYAxisPainter(xHandler, yHandler);
        axisPainter.setFont(FontUtils.getDefaultPlain(9.0f), false);
        axisPainter.setShowLabelsNearOrigin(true);
        axisPainter.setShowOriginLabel(true);
        plotLayout.addPainter(axisPainter);
        BorderPainter borderPainter = new BorderPainter();
        plotLayout.addPainter(borderPainter);
        DataAxisMouseListener1D listener = this.createDataAxisListener(plotInfo);
        GlimpseAxisLayout1D layout1D = this.orient == StackedPlot2D.Orientation.HORIZONTAL ? new GlimpseAxisLayoutX(plotLayout) : new GlimpseAxisLayoutY(plotLayout);
        layout1D.setEventConsumer(false);
        layout1D.addGlimpseMouseAllListener(listener);
        plotLayout.setEventConsumer(false);
        GlimpseLayout labelLayout = new GlimpseLayout(layout2D, String.format("%s-label", plotInfo.getId()));
        SimpleTextPainter labelPainter = new SimpleTextPainter();
        labelPainter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Center);
        labelPainter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Center);
        labelPainter.setFont(FontUtils.getDefaultBold(9.0f), false);
        labelPainter.setPadding(2);
        labelPainter.setText("");
        labelPainter.setHorizontalLabels(false);
        labelLayout.addPainter(labelPainter);
        BorderPainter labelBorderPainter = new BorderPainter();
        labelBorderPainter.setVisible(false);
        labelLayout.addPainter(labelBorderPainter);
        TimePlotInfoImpl timePlotInfo = new TimePlotInfoImpl(this, plotInfo, plotLayout, labelLayout, listener, gridPainter, axisPainter, labelPainter, borderPainter, labelBorderPainter, backgroundPainter, dataPainter);
        if (this.orient == StackedPlot2D.Orientation.HORIZONTAL) {
            gridPainter.setShowHorizontalLines(false);
            labelHandler.setTickSpacing(45);
            axisPainter.setShowVerticalTicks(false);
            axisPainter.setShowHorizontalTicks(true);
            axisPainter.setLockTop(true);
        } else {
            gridPainter.setShowVerticalLines(false);
            labelHandler.setTickSpacing(16);
            axisPainter.setShowVerticalTicks(true);
            axisPainter.setShowHorizontalTicks(false);
            axisPainter.setLockLeft(true);
        }
        timePlotInfo.setLookAndFeel(this.laf);
        return timePlotInfo;
    }
}

