/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.timeline;

import com.google.common.collect.Lists;
import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.plot.stacked.PlotInfo;
import com.metsci.glimpse.plot.stacked.PlotInfoImpl;
import com.metsci.glimpse.plot.stacked.StackedPlot2D;
import com.metsci.glimpse.plot.timeline.StackedTimePlot2D;
import com.metsci.glimpse.plot.timeline.data.Epoch;
import com.metsci.glimpse.plot.timeline.group.GroupInfo;
import com.metsci.glimpse.plot.timeline.group.GroupInfoImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;

public class CollapsibleTimePlot2D
extends StackedTimePlot2D {
    public CollapsibleTimePlot2D() {
        super(StackedPlot2D.Orientation.VERTICAL);
    }

    public CollapsibleTimePlot2D(Epoch epoch) {
        super(StackedPlot2D.Orientation.VERTICAL, epoch);
    }

    public CollapsibleTimePlot2D(Epoch epoch, TaggedAxis1D commonAxis) {
        super(StackedPlot2D.Orientation.VERTICAL, epoch, commonAxis);
    }

    public GroupInfo createGroup(PlotInfo ... subplots) {
        return this.createGroup((Object)UUID.randomUUID(), subplots);
    }

    public GroupInfo createGroup(Object id, PlotInfo ... subplots) {
        LinkedList<PlotInfo> list = new LinkedList<PlotInfo>();
        for (int i = 0; i < subplots.length; ++i) {
            list.add(subplots[i]);
        }
        return this.createGroup(id, list);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupInfo getGroupById(Object groupId) {
        this.lock.lock();
        try {
            GroupInfo groupInfo = (GroupInfo)this.getPlot(groupId);
            return groupInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroupInfo createGroup(Object id, Collection<? extends PlotInfo> subplots) {
        this.lock.lock();
        try {
            PlotInfo plotInfo = this.createPlot0(id, new Axis1D());
            GroupInfoImpl group = new GroupInfoImpl(this, plotInfo, subplots);
            this.stackedPlots.put(id, group);
            if (this.isAutoValidate()) {
                this.validate();
            }
            GroupInfoImpl groupInfoImpl = group;
            return groupInfoImpl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<GroupInfo> getAllGroups() {
        this.lock.lock();
        try {
            LinkedList<GroupInfo> list = new LinkedList<GroupInfo>();
            for (PlotInfo plot : this.getAllPlots()) {
                if (!(plot instanceof GroupInfo)) continue;
                list.add((GroupInfo)plot);
            }
            LinkedList<GroupInfo> linkedList = list;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void validateLayout() {
        for (GroupInfo group : this.getAllGroups()) {
            for (PlotInfo plot : Lists.newArrayList(group.getChildPlots())) {
                if (plot.getStackedPlot() != null) continue;
                group.removeChildPlot(plot);
            }
        }
        super.validateLayout();
    }

    @Override
    protected List<PlotInfo> getSortedPlots(Collection<PlotInfo> unsorted) {
        ArrayList<PlotInfo> ungroupedPlots = new ArrayList<PlotInfo>(unsorted.size());
        ungroupedPlots.addAll(unsorted);
        for (GroupInfo group : this.getAllGroups()) {
            ungroupedPlots.removeAll(group.getChildPlots());
        }
        ArrayList<PlotInfo> accumulator = new ArrayList<PlotInfo>(unsorted.size());
        this.getSortedPlots0(ungroupedPlots, accumulator);
        return accumulator;
    }

    protected void getSortedPlots0(Collection<PlotInfo> toVisitUnsorted, List<PlotInfo> accumulator) {
        if (toVisitUnsorted == null || toVisitUnsorted.isEmpty()) {
            return;
        }
        ArrayList<PlotInfo> toVisitSorted = new ArrayList<PlotInfo>();
        toVisitSorted.addAll(toVisitUnsorted);
        Collections.sort(toVisitSorted, PlotInfoImpl.getComparator());
        for (PlotInfo info : toVisitSorted) {
            accumulator.add(info);
            if (!(info instanceof GroupInfo)) continue;
            GroupInfo group = (GroupInfo)info;
            this.getSortedPlots0(group.getChildPlots(), accumulator);
        }
    }
}

