/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.stacked;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseAxisLayoutX;
import com.metsci.glimpse.layout.GlimpseAxisLayoutY;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutManagerMig;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.plot.stacked.PlotInfo;
import com.metsci.glimpse.plot.stacked.PlotInfoImpl;
import com.metsci.glimpse.support.settings.DefaultLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class StackedPlot2D
extends GlimpseLayout {
    protected boolean autoValidate = true;
    protected int outerBorder = 10;
    protected int plotSpacing = 0;
    protected Axis1D commonAxis;
    protected GlimpseLayoutManagerMig layout;
    protected Map<Object, PlotInfo> stackedPlots;
    protected BackgroundPainter backgroundPainter;
    protected Orientation orient = Orientation.VERTICAL;
    protected LookAndFeel laf;
    protected GlimpseAxisLayout1D overlayLayout;
    protected GlimpseAxisLayout1D underlayLayout;

    public StackedPlot2D(Orientation orientation, Axis1D commonAxis) {
        this.orient = orientation;
        this.initializePlot(commonAxis);
    }

    public StackedPlot2D(Orientation orientation) {
        this(orientation, null);
    }

    public StackedPlot2D(Axis1D commonAxis) {
        this(Orientation.VERTICAL, commonAxis);
    }

    public StackedPlot2D() {
        this(Orientation.VERTICAL, null);
    }

    protected void initializePlot(Axis1D commonAxis) {
        this.initializeAxes(commonAxis);
        this.initializeArrays();
        this.initializeLayout();
        this.initializeOverlayLayout();
        this.initializePainters();
        this.initializeLookAndFeel();
        this.updatePainterLayout();
    }

    protected void initializeAxes(Axis1D commonAxis) {
        this.commonAxis = commonAxis == null ? this.createCommonAxis() : commonAxis;
    }

    protected Axis1D createCommonAxis() {
        return new Axis1D();
    }

    protected void initializeArrays() {
        this.stackedPlots = new LinkedHashMap<Object, PlotInfo>();
    }

    protected void initializeLayout() {
        this.layout = new GlimpseLayoutManagerMig();
        this.setLayoutManager(this.layout);
    }

    protected void initializePainters() {
        this.backgroundPainter = new BackgroundPainter(true);
        this.addPainter((GlimpsePainter)this.backgroundPainter, Integer.MIN_VALUE);
    }

    protected void initializeLookAndFeel() {
        this.setLookAndFeel(new DefaultLookAndFeel());
    }

    protected void initializeOverlayLayout() {
        if (this.getOrientation() == Orientation.VERTICAL) {
            this.overlayLayout = new GlimpseAxisLayoutX(this, "Overlay", this.commonAxis);
            this.underlayLayout = new GlimpseAxisLayoutX(this, "Underlay", this.commonAxis);
        } else {
            this.overlayLayout = new GlimpseAxisLayoutY(this, "Overlay", this.commonAxis);
            this.underlayLayout = new GlimpseAxisLayoutY(this, "Underlay", this.commonAxis);
        }
        this.overlayLayout.setEventGenerator(true);
        this.overlayLayout.setEventConsumer(false);
        this.underlayLayout.setEventGenerator(true);
        this.underlayLayout.setEventConsumer(false);
        this.setZOrder(this.overlayLayout, Integer.MAX_VALUE);
        this.setZOrder(this.underlayLayout, Integer.MIN_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updatePainterLayout() {
        this.lock.lock();
        try {
            this.setLayoutConstraints();
            List<PlotInfo> list = this.getSortedPlots(this.stackedPlots.values());
            for (int index = 0; index < list.size(); ++index) {
                PlotInfo info = list.get(index);
                info.updateLayout(index);
            }
            this.updateOverlayLayout(list);
            this.invalidateLayout();
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void updateOverlayLayout(List<PlotInfo> list) {
        if (this.overlayLayout != null) {
            int index = list.size() - 1;
            int offsetX = this.getOverlayLayoutOffsetX();
            int offsetX2 = this.getOverlayLayoutOffsetX2();
            int offsetY = this.getOverlayLayoutOffsetY();
            int offsetY2 = this.getOverlayLayoutOffsetY2();
            if (this.getOrientation() == Orientation.VERTICAL) {
                String layout = String.format("pos i%d.x+(%d) i%d.y+(%d) i0.x2+(%d) i0.y2+(%d)", index, offsetX, index, offsetY, offsetX2, offsetY2);
                this.overlayLayout.setLayoutData(layout);
                this.underlayLayout.setLayoutData(layout);
            } else {
                String layout = String.format("pos i0.x+(%d) i0.y+(%d) i%d.x2+(%d) i%d.y2+(%d)", offsetX, offsetY, index, offsetX2, index, offsetY2);
                this.overlayLayout.setLayoutData(layout);
                this.underlayLayout.setLayoutData(layout);
            }
        }
    }

    protected int getOverlayLayoutOffsetX() {
        return 0;
    }

    protected int getOverlayLayoutOffsetX2() {
        return 0;
    }

    protected int getOverlayLayoutOffsetY() {
        return 0;
    }

    protected int getOverlayLayoutOffsetY2() {
        return 0;
    }

    protected void setLayoutConstraints() {
        this.layout.setLayoutConstraints(String.format("bottomtotop, gapx 0, gapy 0, insets %d %d %d %d", this.outerBorder, this.outerBorder, this.outerBorder, this.outerBorder));
    }

    public boolean isAutoValidate() {
        return this.autoValidate;
    }

    public void setAutoValidate(boolean autoValidate) {
        this.autoValidate = autoValidate;
    }

    public int getPlotSpacing() {
        return this.plotSpacing;
    }

    public Orientation getOrientation() {
        return this.orient;
    }

    public Axis1D getCommonAxis() {
        return this.commonAxis;
    }

    public PlotInfo getPlot(Object id) {
        return this.stackedPlots.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<PlotInfo> getAllPlots() {
        this.lock.lock();
        try {
            Collection<PlotInfo> collection = Collections.unmodifiableCollection(this.stackedPlots.values());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setPlotSpacing(int size) {
        this.plotSpacing = size;
        for (PlotInfo info : this.stackedPlots.values()) {
            info.setPlotSpacing(size);
        }
        if (this.isAutoValidate()) {
            this.validate();
        }
    }

    public void setBackgroundColor(float[] color) {
        this.backgroundPainter.setColor(color);
    }

    public void setBorderSize(int size) {
        this.outerBorder = size;
        if (this.isAutoValidate()) {
            this.validate();
        }
    }

    public void validate() {
        this.validateLayout();
        this.validateAxes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAxes() {
        this.lock.lock();
        try {
            this.commonAxis.validate();
            for (PlotInfo info : this.stackedPlots.values()) {
                Axis2D axis = info.getLayout().getAxis();
                if (axis == null) continue;
                axis.getAxisX().validate();
                axis.getAxisY().validate();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void validateLayout() {
        this.updatePainterLayout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePlot(Object id) {
        this.lock.lock();
        try {
            PlotInfo info = this.stackedPlots.remove(id);
            if (info == null) {
                return;
            }
            info.deletePlot();
            if (this.isAutoValidate()) {
                this.validate();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public PlotInfo createPlot() {
        return this.createPlot(UUID.randomUUID());
    }

    public PlotInfo createPlot(Object id) {
        return this.createPlot(id, new Axis1D());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlotInfo createPlot(Object id, Axis1D axis) {
        this.lock.lock();
        try {
            PlotInfo info = this.createPlot0(id, axis);
            this.stackedPlots.put(id, info);
            if (this.isAutoValidate()) {
                this.validate();
            }
            PlotInfo plotInfo = info;
            return plotInfo;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        return StackedPlot2D.class.getSimpleName();
    }

    protected List<PlotInfo> getSortedPlots(Collection<PlotInfo> unsorted) {
        ArrayList<PlotInfo> sortedList = new ArrayList<PlotInfo>();
        sortedList.addAll(unsorted);
        Collections.sort(sortedList, PlotInfoImpl.getComparator());
        return sortedList;
    }

    protected Axis1D getCommonAxis(Axis2D axis) {
        return this.orient == Orientation.HORIZONTAL ? axis.getAxisY() : axis.getAxisX();
    }

    protected Axis1D getOrthogonalAxis(Axis2D axis) {
        return this.orient == Orientation.HORIZONTAL ? axis.getAxisX() : axis.getAxisY();
    }

    protected PlotInfo createPlot0(Object id, Axis1D axis) {
        if (id == null) {
            throw new IllegalArgumentException("Plot ID cannot be null.");
        }
        if (this.stackedPlots.containsKey(id)) {
            throw new IllegalArgumentException("Plot ID: " + id + " already exists.");
        }
        int order = 0;
        int size = -1;
        GlimpseAxisLayout2D layout = new GlimpseAxisLayout2D(null, id.toString(), this.createAxis2D(axis));
        layout.setLookAndFeel(this.laf);
        this.addLayout(layout);
        PlotInfoImpl info = new PlotInfoImpl(this, id, order, size, this.plotSpacing, layout);
        return info;
    }

    protected Axis2D createAxis2D(Axis1D axis) {
        Axis1D commonChildAxis = this.commonAxis.clone();
        Axis2D axis2D = this.orient == Orientation.HORIZONTAL ? new Axis2D(axis, commonChildAxis) : new Axis2D(commonChildAxis, axis);
        return axis2D;
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        super.setLookAndFeel(laf);
        this.laf = laf;
    }

    public static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

