/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot.stacked;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.plot.stacked.PlotInfo;
import com.metsci.glimpse.plot.stacked.StackedPlot2D;
import com.metsci.glimpse.support.settings.LookAndFeel;
import java.util.Comparator;

public class PlotInfoImpl
implements PlotInfo {
    protected boolean visible;
    protected boolean grow;
    protected Object id;
    protected int order;
    protected int size;
    protected int spacing;
    protected GlimpseAxisLayout2D layout;
    protected StackedPlot2D parent;

    public PlotInfoImpl(StackedPlot2D parent, Object id, int order, int size, int spacing, GlimpseAxisLayout2D layout) {
        this.parent = parent;
        this.id = id;
        this.order = order;
        this.size = size;
        this.spacing = spacing;
        this.layout = layout;
        this.grow = size < 0;
        this.visible = true;
    }

    @Override
    public StackedPlot2D getStackedPlot() {
        return this.parent;
    }

    @Override
    public Object getId() {
        return this.id;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setGrow(boolean grow) {
        this.grow = grow;
    }

    @Override
    public boolean isGrow() {
        return this.grow && this.isVisible();
    }

    @Override
    public void setOrder(int order) {
        this.order = order;
        if (this.parent.isAutoValidate()) {
            this.parent.validate();
        }
    }

    @Override
    public void setSize(int size) {
        this.size = size;
        boolean bl = this.grow = size < 0;
        if (this.parent.isAutoValidate()) {
            this.parent.validate();
        }
    }

    @Override
    public void setPlotSpacing(int spacing) {
        this.spacing = spacing;
    }

    @Override
    public int getPlotSpacing() {
        return this.spacing;
    }

    @Override
    public GlimpseAxisLayout2D getLayout() {
        return this.layout;
    }

    @Override
    public Axis1D getCommonAxis(GlimpseTargetStack stack) {
        return this.parent.getCommonAxis(this.layout.getAxis(stack));
    }

    @Override
    public Axis1D getOrthogonalAxis(GlimpseTargetStack stack) {
        return this.parent.getOrthogonalAxis(this.layout.getAxis(stack));
    }

    @Override
    public Axis1D getCommonAxis() {
        return this.parent.getCommonAxis(this.layout.getAxis());
    }

    @Override
    public Axis1D getOrthogonalAxis() {
        return this.parent.getOrthogonalAxis(this.layout.getAxis());
    }

    @Override
    public void addLayout(GlimpseAxisLayout2D childLayout) {
        if (childLayout.getAxis() != null) {
            Axis1D childCommonAxis = this.parent.getCommonAxis(childLayout.getAxis());
            Axis1D parentCommonAxis = this.parent.getCommonAxis(this.layout.getAxis());
            childCommonAxis.setParent(parentCommonAxis);
        }
        this.layout.addLayout(childLayout);
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        this.layout.setLookAndFeel(laf);
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
        this.layout.setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void deletePlot() {
        if (this.parent != null) {
            StackedPlot2D oldParent = this.parent;
            this.parent = null;
            oldParent.removeLayout(this.layout);
            oldParent.deletePlot(this.id);
        }
    }

    @Override
    public void updateLayout(int index) {
        StackedPlot2D.Orientation orient = this.getStackedPlot().getOrientation();
        int plotCount = this.getStackedPlot().getAllPlots().size();
        int plotSpacing = this.getPlotSpacing();
        int plotSize = this.getSize();
        if (!this.isVisible()) {
            plotSpacing = 0;
            plotSize = 0;
        }
        if (index == plotCount - 1 && orient == StackedPlot2D.Orientation.HORIZONTAL) {
            plotSpacing = 0;
        } else if (index == 0 && orient == StackedPlot2D.Orientation.VERTICAL) {
            plotSpacing = 0;
        }
        String layoutData = null;
        if (orient == StackedPlot2D.Orientation.VERTICAL) {
            if (this.isGrow()) {
                String format = "cell %d %d, push, grow, gaptop %d, id i%2$d";
                layoutData = String.format(format, 0, index, plotSpacing);
            } else {
                String format = "cell %d %d, growx, pushx, height %d!, gaptop %d, id i%2$d";
                layoutData = String.format(format, 0, index, plotSize, plotSpacing);
            }
        } else if (orient == StackedPlot2D.Orientation.HORIZONTAL) {
            if (this.isGrow()) {
                String format = "cell %d %d, push, grow, gapright %d, id i%1$d";
                layoutData = String.format(format, index, 0, plotSpacing);
            } else {
                String format = "cell %d %d, growy, pushy, width %d!, gapright %d, id i%1$d";
                layoutData = String.format(format, index, 0, plotSize, plotSpacing);
            }
        }
        this.getLayout().setLayoutData(layoutData);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlotInfoImpl other = (PlotInfoImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public static Comparator<PlotInfo> getComparator() {
        return new Comparator<PlotInfo>(){

            @Override
            public int compare(PlotInfo axis0, PlotInfo axis1) {
                if (axis0.getOrder() < axis1.getOrder()) {
                    return -1;
                }
                if (axis0.getOrder() > axis1.getOrder()) {
                    return 1;
                }
                return 0;
            }
        };
    }
}

