/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot;

import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.base.GlimpsePainterCallback;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.painter.decoration.CrosshairPainter;
import com.metsci.glimpse.painter.decoration.GridPainter;
import com.metsci.glimpse.plot.Plot2D;

public class SimplePlot2D
extends Plot2D {
    protected BorderPainter borderPainter;
    protected BackgroundPainter plotBackgroundPainter;
    protected GridPainter gridPainter;
    protected CrosshairPainter crosshairPainter;

    public SimplePlot2D() {
        this.initialize();
    }

    public SimplePlot2D(String name) {
        this.initialize();
        this.setName(name);
    }

    @Override
    protected void initializePainters() {
        super.initializePainters();
        this.plotBackgroundPainter = new BackgroundPainter(false);
        this.axisLayoutXY.addPainter((GlimpsePainter)this.plotBackgroundPainter, Integer.MIN_VALUE);
        this.gridPainter = new GridPainter(this.tickX, this.tickY);
        this.axisLayoutXY.addPainter((GlimpsePainter)this.gridPainter, Plot2D.BACKGROUND_LAYER);
        this.crosshairPainter = new CrosshairPainter();
        this.axisLayoutXY.addPainter((GlimpsePainter)this.crosshairPainter, Plot2D.FOREGROUND_LAYER);
        this.borderPainter = new BorderPainter();
        this.axisLayoutXY.addPainter((GlimpsePainter)this.borderPainter, Plot2D.FOREGROUND_LAYER);
        this.setAxisSizeZ(0);
    }

    public void addPainterBackground(GlimpsePainter painter) {
        this.axisLayoutXY.addPainter(painter, Plot2D.BACKGROUND_LAYER);
    }

    public void addPainterForeground(GlimpsePainter painter) {
        this.axisLayoutXY.addPainter(painter, Plot2D.FOREGROUND_LAYER);
    }

    @Override
    public void setZOrder(GlimpsePainter painter, int zOrder) {
        this.axisLayoutXY.setZOrder(painter, zOrder);
    }

    @Override
    public void addPainter(GlimpsePainter painter) {
        this.axisLayoutXY.addPainter(painter);
    }

    @Override
    public void addPainter(GlimpsePainter painter, GlimpsePainterCallback callback) {
        this.axisLayoutXY.addPainter(painter, callback);
    }

    @Override
    public void addPainter(GlimpsePainter painter, int zOrder) {
        this.axisLayoutXY.addPainter(painter, zOrder);
    }

    @Override
    public void addPainter(GlimpsePainter painter, GlimpsePainterCallback callback, int zOrder) {
        this.axisLayoutXY.addPainter(painter, callback, zOrder);
    }

    @Override
    public void removePainter(GlimpsePainter painter) {
        this.axisLayoutXY.removePainter(painter);
    }

    public void setPlotBackgroundColor(float[] color) {
        this.plotBackgroundPainter.setColor(color);
    }

    @Override
    public void setBackgroundColor(float[] color) {
        this.backgroundPainter.setColor(color);
    }

    public CrosshairPainter getCrosshairPainter() {
        return this.crosshairPainter;
    }

    public BorderPainter getBorderPainter() {
        return this.borderPainter;
    }

    public GridPainter getGridPainter() {
        return this.gridPainter;
    }

    @Override
    public String toString() {
        return SimplePlot2D.class.getSimpleName();
    }
}

