/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.plot;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.UpdateMode;
import com.metsci.glimpse.axis.listener.AxisListener2D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener1D;
import com.metsci.glimpse.axis.listener.mouse.AxisMouseListener2D;
import com.metsci.glimpse.axis.painter.NumericAxisPainter;
import com.metsci.glimpse.axis.painter.NumericXAxisPainter;
import com.metsci.glimpse.axis.painter.NumericYAxisPainter;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.GridAxisLabelHandler;
import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.context.TargetStackUtil;
import com.metsci.glimpse.event.mouse.GlimpseMouseAllListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseMotionListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseWheelListener;
import com.metsci.glimpse.event.mouse.Mouseable;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseAxisLayoutX;
import com.metsci.glimpse.layout.GlimpseAxisLayoutY;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutManagerMig;
import com.metsci.glimpse.painter.decoration.BackgroundPainter;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.repaint.RepaintManager;
import com.metsci.glimpse.support.settings.DefaultLookAndFeel;
import java.awt.Font;

public class Plot2D
extends GlimpseAxisLayout2D {
    public static int BACKGROUND_LAYER = -100;
    public static int DATA_LAYER = 0;
    public static int FOREGROUND_LAYER = 100;
    protected int outerBorder = 10;
    protected int axisThicknessX = 40;
    protected int axisThicknessY = 60;
    protected int axisThicknessZ = 65;
    protected int titleSpacing = 50;
    protected String title = null;
    protected boolean showTitle = false;
    protected BackgroundPainter backgroundPainter;
    protected GlimpseLayout titleLayout;
    protected GlimpseAxisLayout1D axisLayoutX;
    protected GlimpseAxisLayout1D axisLayoutY;
    protected GlimpseAxisLayout1D axisLayoutZ;
    protected GlimpseAxisLayout2D axisLayoutXY;
    protected Axis2D axisXY;
    protected Axis1D axisZ;
    protected SimpleTextPainter titlePainter;
    protected NumericAxisPainter painterX;
    protected NumericAxisPainter painterY;
    protected NumericAxisPainter painterZ;
    protected GridAxisLabelHandler tickX;
    protected GridAxisLabelHandler tickY;
    protected GridAxisLabelHandler tickZ;
    protected AxisMouseListener mouseListenerX;
    protected AxisMouseListener mouseListenerY;
    protected AxisMouseListener mouseListenerZ;
    protected AxisMouseListener mouseListenerXY;

    protected Plot2D() {
    }

    public Plot2D(String name) {
        this.initialize();
        this.setName(name);
    }

    protected void initialize() {
        this.initializeAxes();
        this.initializeParentLayout();
        this.initializePainters();
        this.attachAxisMouseListeners();
        this.initializeLookAndFeel();
        this.updatePainterLayout();
    }

    protected void initializeAxes() {
        this.axisXY = new Axis2D(this.createAxisX(), this.createAxisY());
        this.axisZ = this.createAxisZ();
    }

    protected void initializeParentLayout() {
        this.backgroundPainter = new BackgroundPainter(true);
        super.addPainter0(this.backgroundPainter, null, Integer.MIN_VALUE);
    }

    protected void initializeLookAndFeel() {
        this.setLookAndFeel(new DefaultLookAndFeel());
    }

    protected void updatePainterLayout() {
        this.getLayoutManager().setLayoutConstraints(String.format("bottomtotop, gapx 0, gapy 0, insets %d %d %d %d", this.getTopInset(), this.outerBorder, this.outerBorder, this.outerBorder));
        this.titleLayout.setLayoutData(String.format("cell 1 0 1 1, pushx, growx, height %d!", this.titleSpacing));
        this.axisLayoutY.setLayoutData(String.format("cell 0 1 1 1, pushy, growy, width %d!", this.axisThicknessY));
        this.axisLayoutX.setLayoutData(String.format("cell 1 2 1 1, pushx, growx, height %d!", this.axisThicknessX));
        this.axisLayoutXY.setLayoutData("cell 1 1 1 1, push, grow");
        this.axisLayoutZ.setLayoutData(String.format("cell 2 1 1 1, pushy, growy, width %d!", this.axisThicknessZ));
        this.invalidateLayout();
    }

    protected void initializePainters() {
        this.titleLayout = new GlimpseLayout(this, "Title");
        this.axisLayoutX = new GlimpseAxisLayoutX((GlimpseLayout)this, "AxisX");
        this.axisLayoutY = new GlimpseAxisLayoutY((GlimpseLayout)this, "AxisY");
        this.axisLayoutZ = new GlimpseAxisLayoutY((GlimpseLayout)this, "AxisZ");
        this.axisLayoutXY = new GlimpseAxisLayout2D((GlimpseLayout)this, "Center");
        this.setAxis(this.axisXY);
        this.axisLayoutZ.setAxis(this.axisZ);
        this.tickX = this.createLabelHandlerX();
        this.tickY = this.createLabelHandlerY();
        this.tickZ = this.createLabelHandlerZ();
        this.titlePainter = this.createTitlePainter();
        this.painterX = this.createAxisPainterX(this.tickX);
        this.painterY = this.createAxisPainterY(this.tickY);
        this.painterZ = this.createAxisPainterZ(this.tickZ);
        if (this.titlePainter != null) {
            this.titleLayout.addPainter(this.titlePainter);
        }
        if (this.painterX != null) {
            this.axisLayoutX.addPainter(this.painterX);
        }
        if (this.painterY != null) {
            this.axisLayoutY.addPainter(this.painterY);
        }
        if (this.painterZ != null) {
            this.axisLayoutZ.addPainter(this.painterZ);
        }
        this.mouseListenerX = this.createAxisMouseListenerX();
        this.mouseListenerY = this.createAxisMouseListenerY();
        this.mouseListenerZ = this.createAxisMouseListenerZ();
        this.mouseListenerXY = this.createAxisMouseListenerXY();
    }

    protected void attachAxisMouseListeners() {
        this.attachAxisMouseListener(this.axisLayoutX, this.mouseListenerX);
        this.attachAxisMouseListener(this.axisLayoutY, this.mouseListenerY);
        this.attachAxisMouseListener(this.axisLayoutZ, this.mouseListenerZ);
        this.attachAxisMouseListener(this.axisLayoutXY, this.mouseListenerXY);
    }

    protected RepaintManager createRepaintManager(GlimpseCanvas canvas) {
        return new RepaintManager(canvas);
    }

    protected void removeAxisMouseListener(Mouseable mouseable, AxisMouseListener listener) {
        mouseable.removeGlimpseMouseListener(listener);
        mouseable.removeGlimpseMouseMotionListener(listener);
        mouseable.removeGlimpseMouseWheelListener(listener);
    }

    protected void attachAxisMouseListener(Mouseable mouseable, AxisMouseListener listener) {
        mouseable.addGlimpseMouseListener(listener);
        mouseable.addGlimpseMouseMotionListener(listener);
        mouseable.addGlimpseMouseWheelListener(listener);
    }

    protected AxisMouseListener createAxisMouseListenerX() {
        return new AxisMouseListener1D();
    }

    protected AxisMouseListener createAxisMouseListenerY() {
        return new AxisMouseListener1D();
    }

    protected AxisMouseListener createAxisMouseListenerZ() {
        return new AxisMouseListener1D();
    }

    protected AxisMouseListener createAxisMouseListenerXY() {
        return new AxisMouseListener2D();
    }

    protected SimpleTextPainter createTitlePainter() {
        SimpleTextPainter painter = new SimpleTextPainter();
        painter.setHorizontalPosition(SimpleTextPainter.HorizontalPosition.Center);
        painter.setVerticalPosition(SimpleTextPainter.VerticalPosition.Center);
        painter.setColor(GlimpseColor.getBlack());
        return painter;
    }

    protected Axis1D createAxisX() {
        return new Axis1D();
    }

    protected Axis1D createAxisY() {
        return new Axis1D();
    }

    protected Axis1D createAxisZ() {
        return new Axis1D();
    }

    protected GridAxisLabelHandler createLabelHandlerX() {
        return new GridAxisLabelHandler();
    }

    protected GridAxisLabelHandler createLabelHandlerY() {
        return new GridAxisLabelHandler();
    }

    protected GridAxisLabelHandler createLabelHandlerZ() {
        return new GridAxisLabelHandler();
    }

    protected NumericAxisPainter createAxisPainterX(AxisLabelHandler tickHandler) {
        return new NumericXAxisPainter(tickHandler);
    }

    protected NumericAxisPainter createAxisPainterY(AxisLabelHandler tickHandler) {
        return new NumericYAxisPainter(tickHandler);
    }

    protected NumericAxisPainter createAxisPainterZ(AxisLabelHandler tickHandler) {
        return new NumericYAxisPainter(tickHandler);
    }

    protected int getTopInset() {
        if (this.showTitle && this.title != null && !this.title.isEmpty()) {
            return 0;
        }
        return this.outerBorder;
    }

    @Override
    public GlimpseLayoutManagerMig getLayoutManager() {
        return (GlimpseLayoutManagerMig)super.getLayoutManager();
    }

    public void setBackgroundColor(float[] color) {
        this.backgroundPainter.setColor(color);
    }

    public void addAxisListener(AxisListener2D l) {
        this.axis.addAxisListener(l);
    }

    public void setUpdateModeZ(UpdateMode mode) {
        this.axisZ.setUpdateMode(mode);
    }

    public void setUpdateModeXY(UpdateMode mode) {
        this.axis.getAxisX().setUpdateMode(mode);
        this.axis.getAxisY().setUpdateMode(mode);
    }

    public void setAxisFont(Font font) {
        this.setAxisFont(font, true);
    }

    public void setAxisFont(Font font, boolean antialias) {
        if (this.painterX != null) {
            this.painterX.setFont(font, antialias);
        }
        if (this.painterY != null) {
            this.painterY.setFont(font, antialias);
        }
        if (this.painterZ != null) {
            this.painterZ.setFont(font, antialias);
        }
    }

    public void setAxisColor(float[] color) {
        this.setTickColor(color);
        this.setTickLabelColor(color);
        this.setAxisLabelColor(color);
    }

    public void setTitleFont(Font font) {
        this.setTitleFont(font, true);
    }

    public void setTitleFont(Font font, boolean antialias) {
        this.titlePainter.setFont(font, antialias);
    }

    public void setTitle(String title) {
        this.title = title;
        this.titlePainter.setText(title);
        this.showTitle(true);
    }

    public void setTitleColor(float[] rgba) {
        this.titlePainter.setColor(rgba);
        this.showTitle(true);
    }

    public void showTitle(boolean show) {
        this.showTitle = show;
        this.updatePainterLayout();
        this.validate();
    }

    public void setBorderSize(int size) {
        this.outerBorder = size;
        this.updatePainterLayout();
        this.validate();
    }

    public void setAxisSizeX(int size) {
        this.axisThicknessX = size;
        this.updatePainterLayout();
        this.validate();
    }

    public void setAxisSizeY(int size) {
        this.axisThicknessY = size;
        this.updatePainterLayout();
        this.validate();
    }

    public void setAxisSizeZ(int size) {
        this.axisThicknessZ = size;
        this.updatePainterLayout();
        this.validate();
    }

    public void setTitleHeight(int size) {
        this.titleSpacing = size;
        this.updatePainterLayout();
        this.validate();
    }

    @Override
    public Axis2D getAxis() {
        return this.axisXY;
    }

    public Axis1D getAxisX() {
        return this.axisXY.getAxisX();
    }

    public Axis1D getAxisY() {
        return this.axisXY.getAxisY();
    }

    public Axis1D getAxisZ() {
        return this.axisZ;
    }

    public void setTickSize(int size) {
        if (this.painterX != null) {
            this.painterX.setTickSize(size);
        }
        if (this.painterY != null) {
            this.painterY.setTickSize(size);
        }
        if (this.painterZ != null) {
            this.painterZ.setTickSize(size);
        }
    }

    public void setTickColor(float[] color) {
        if (this.painterX != null) {
            this.painterX.setTickColor(color);
        }
        if (this.painterY != null) {
            this.painterY.setTickColor(color);
        }
        if (this.painterZ != null) {
            this.painterZ.setTickColor(color);
        }
    }

    public void setTickLabelColor(float[] color) {
        if (this.painterX != null) {
            this.painterX.setTickLabelColor(color);
        }
        if (this.painterY != null) {
            this.painterY.setTickLabelColor(color);
        }
        if (this.painterZ != null) {
            this.painterZ.setTickLabelColor(color);
        }
    }

    public void setAxisLabelColor(float[] color) {
        if (this.painterX != null) {
            this.painterX.setAxisLabelColor(color);
        }
        if (this.painterY != null) {
            this.painterY.setAxisLabelColor(color);
        }
        if (this.painterZ != null) {
            this.painterZ.setAxisLabelColor(color);
        }
    }

    public void setMinorTickCount(int count) {
        if (this.tickX != null) {
            this.tickX.setMinorTickCount(count);
        }
        if (this.tickY != null) {
            this.tickY.setMinorTickCount(count);
        }
        if (this.tickZ != null) {
            this.tickZ.setMinorTickCount(count);
        }
    }

    public void setShowMinorTicks(boolean show) {
        if (this.painterX != null) {
            this.painterX.setShowMinorTicks(show);
        }
        if (this.painterY != null) {
            this.painterY.setShowMinorTicks(show);
        }
        if (this.painterZ != null) {
            this.painterZ.setShowMinorTicks(show);
        }
    }

    public void setAxisLabelZ(String label) {
        this.setAxisLabelZ(label, "");
    }

    public void setAxisLabelZ(String label, String abbreviatedUnits) {
        this.tickZ.setAxisLabel(label);
        this.tickZ.setAxisUnits(abbreviatedUnits, true);
    }

    public void setAxisLabelZ(String label, String units, boolean abbreviated) {
        this.tickZ.setAxisLabel(label);
        this.tickZ.setAxisUnits(units, abbreviated);
    }

    public void setShowAxisMarkerZ(boolean show) {
        this.painterZ.setShowMarker(show);
    }

    public void setShowMinorTicksZ(boolean show) {
        this.painterZ.setShowMinorTicks(show);
    }

    public void setMarkerWidthZ(int width) {
        this.painterZ.setMarkerWidth(width);
    }

    public void setTickSpacingZ(int spacing) {
        this.tickZ.setTickSpacing(spacing);
    }

    public void setMinorTickCountZ(int count) {
        this.tickZ.setMinorTickCount(count);
    }

    public void setAxisLabelX(String label) {
        this.setAxisLabelX(label, "");
    }

    public void setAxisLabelX(String label, String abbreviatedUnits) {
        this.tickX.setAxisLabel(label);
        this.tickX.setAxisUnits(abbreviatedUnits, true);
    }

    public void setAxisLabelX(String label, String units, boolean abbreviated) {
        this.tickX.setAxisLabel(label);
        this.tickX.setAxisUnits(units, abbreviated);
    }

    public void setShowAxisMarkerX(boolean show) {
        this.painterX.setShowMarker(show);
    }

    public void setShowMinorTicksX(boolean show) {
        this.painterX.setShowMinorTicks(show);
    }

    public void setMarkerWidthX(int width) {
        this.painterX.setMarkerWidth(width);
    }

    public void setTickSpacingX(int spacing) {
        this.tickX.setTickSpacing(spacing);
    }

    public void setMinorTickCountX(int count) {
        this.tickX.setMinorTickCount(count);
    }

    public void setAxisLabelY(String label) {
        this.setAxisLabelY(label, "");
    }

    public void setAxisLabelY(String label, String abbreviatedUnits) {
        this.tickY.setAxisLabel(label);
        this.tickY.setAxisUnits(abbreviatedUnits, true);
    }

    public void setAxisLabelY(String label, String units, boolean abbreviated) {
        this.tickY.setAxisLabel(label);
        this.tickY.setAxisUnits(units, abbreviated);
    }

    public void setShowAxisMarkerY(boolean show) {
        this.painterY.setShowMarker(show);
    }

    public void setShowMinorTicksY(boolean show) {
        this.painterY.setShowMinorTicks(show);
    }

    public void setMarkerWidthY(int width) {
        this.painterY.setMarkerWidth(width);
    }

    public void setTickSpacingY(int spacing) {
        this.tickY.setTickSpacing(spacing);
    }

    public void setMinorTickCountY(int count) {
        this.tickY.setMinorTickCount(count);
    }

    public void validate() {
        this.axis.getAxisX().validate();
        this.axis.getAxisY().validate();
        this.axisZ.validate();
    }

    public void setAbsoluteMaxX(double value) {
        this.axis.getAxisX().setAbsoluteMax(value);
    }

    public void setAbsoluteMinX(double value) {
        this.axis.getAxisX().setAbsoluteMin(value);
    }

    public void setAbsoluteMaxY(double value) {
        this.axis.getAxisY().setAbsoluteMax(value);
    }

    public void setAbsoluteMinY(double value) {
        this.axis.getAxisY().setAbsoluteMin(value);
    }

    public void setAbsoluteMaxZ(double value) {
        this.axisZ.setAbsoluteMax(value);
    }

    public void setAbsoluteMinZ(double value) {
        this.axisZ.setAbsoluteMin(value);
    }

    public void setMaxX(double value) {
        this.axis.getAxisX().setMax(value);
    }

    public void setMinX(double value) {
        this.axis.getAxisX().setMin(value);
    }

    public void setMaxY(double value) {
        this.axis.getAxisY().setMax(value);
    }

    public void setMinY(double value) {
        this.axis.getAxisY().setMin(value);
    }

    public void setMaxZ(double value) {
        this.axisZ.setMax(value);
    }

    public void setMinZ(double value) {
        this.axisZ.setMin(value);
    }

    public void lockMaxX(double value) {
        this.axis.getAxisX().lockMax(value);
    }

    public void lockMinX(double value) {
        this.axis.getAxisX().lockMin(value);
    }

    public void lockMaxY(double value) {
        this.axis.getAxisY().lockMax(value);
    }

    public void lockMinY(double value) {
        this.axis.getAxisY().lockMin(value);
    }

    public void lockMaxZ(double value) {
        this.axisZ.lockMax(value);
    }

    public void lockMinZ(double value) {
        this.axisZ.lockMin(value);
    }

    public void unlockMaxX() {
        this.axis.getAxisX().unlockMax();
    }

    public void unlockMinX() {
        this.axis.getAxisX().unlockMin();
    }

    public void unlockMaxY() {
        this.axis.getAxisY().unlockMax();
    }

    public void unlockMinY() {
        this.axis.getAxisY().unlockMin();
    }

    public void unlockMaxZ() {
        this.axisZ.unlockMax();
    }

    public void unlockMinZ() {
        this.axisZ.unlockMin();
    }

    public void setSelectionSize(double value) {
        this.axis.getAxisX().setSelectionSize(value);
        this.axis.getAxisY().setSelectionSize(value);
    }

    public void lockAspectRatioXY(double x_to_y_ratio) {
        this.axis.lockAspectRatioXY(x_to_y_ratio);
    }

    public NumericAxisPainter getAxisPainterX() {
        return this.painterX;
    }

    public NumericAxisPainter getAxisPainterY() {
        return this.painterY;
    }

    public NumericAxisPainter getAxisPainterZ() {
        return this.painterZ;
    }

    public GridAxisLabelHandler getLabelHandlerX() {
        return this.tickX;
    }

    public GridAxisLabelHandler getLabelHandlerY() {
        return this.tickY;
    }

    public GridAxisLabelHandler getLabelHandlerZ() {
        return this.tickZ;
    }

    public GlimpseLayout getLayoutX() {
        return this.axisLayoutX;
    }

    public GlimpseLayout getLayoutY() {
        return this.axisLayoutY;
    }

    public GlimpseLayout getLayoutZ() {
        return this.axisLayoutZ;
    }

    public GlimpseAxisLayout2D getLayoutCenter() {
        return this.axisLayoutXY;
    }

    public GlimpseLayout getLayoutTitle() {
        return this.titleLayout;
    }

    public GlimpseTargetStack getTargetStackX() {
        return TargetStackUtil.newTargetStack(this, this.axisLayoutX);
    }

    public GlimpseTargetStack getTargetStackY() {
        return TargetStackUtil.newTargetStack(this, this.axisLayoutY);
    }

    public GlimpseTargetStack getTargetStackZ() {
        return TargetStackUtil.newTargetStack(this, this.axisLayoutZ);
    }

    public GlimpseTargetStack getTargetStackCenter() {
        return TargetStackUtil.newTargetStack(this, this.axisLayoutXY);
    }

    public GlimpseTargetStack getTargetStackTitle() {
        return TargetStackUtil.newTargetStack(this, this.titleLayout);
    }

    @Override
    public void addGlimpseMouseListener(GlimpseMouseListener listener) {
        this.axisLayoutXY.addGlimpseMouseListener(listener);
    }

    @Override
    public void addGlimpseMouseMotionListener(GlimpseMouseMotionListener listener) {
        this.axisLayoutXY.addGlimpseMouseMotionListener(listener);
    }

    @Override
    public void addGlimpseMouseWheelListener(GlimpseMouseWheelListener listener) {
        this.axisLayoutXY.addGlimpseMouseWheelListener(listener);
    }

    @Override
    public void addGlimpseMouseAllListener(GlimpseMouseAllListener listener) {
        this.axisLayoutXY.addGlimpseMouseAllListener(listener);
    }

    @Override
    public void removeGlimpseMouseAllListener(GlimpseMouseAllListener listener) {
        this.axisLayoutXY.removeGlimpseMouseAllListener(listener);
    }

    @Override
    public void removeGlimpseMouseListener(GlimpseMouseListener listener) {
        this.axisLayoutXY.removeGlimpseMouseListener(listener);
    }

    @Override
    public void removeGlimpseMouseMotionListener(GlimpseMouseMotionListener listener) {
        this.axisLayoutXY.removeGlimpseMouseMotionListener(listener);
    }

    @Override
    public void removeGlimpseMouseWheelListener(GlimpseMouseWheelListener listener) {
        this.axisLayoutXY.removeGlimpseMouseWheelListener(listener);
    }

    @Override
    public String toString() {
        return Plot2D.class.getSimpleName();
    }
}

