/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.treemap;

import com.metsci.glimpse.painter.treemap.TreeMapLayout;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import it.unimi.dsi.fastutil.ints.IntArrays;
import it.unimi.dsi.fastutil.ints.IntComparator;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;

public class SquarifiedLayout
implements TreeMapLayout {
    @Override
    public Rectangle2D[] layout(Rectangle2D boundary, double[] areas, int level) {
        int[] order = this.sortDescending(areas);
        double sumOfAreas = 0.0;
        for (int i = 0; i < areas.length; ++i) {
            sumOfAreas += areas[i];
        }
        double[] sorted = new double[areas.length];
        double normalizer = boundary.getWidth() * boundary.getHeight() / sumOfAreas;
        for (int i = 0; i < order.length; ++i) {
            sorted[i] = areas[order[i]] * normalizer;
        }
        ArrayList<Rectangle2D> rectList = new ArrayList<Rectangle2D>();
        if (sorted.length > 1) {
            double shortestSide = Math.min(boundary.getWidth(), boundary.getHeight());
            this.squarify(sorted, boundary, shortestSide, rectList);
        } else {
            rectList.add(boundary);
        }
        Rectangle2D[] rects = new Rectangle2D[areas.length];
        for (int i = 0; i < rectList.size(); ++i) {
            rects[order[i]] = (Rectangle2D)rectList.get(i);
        }
        return rects;
    }

    protected void squarify(double[] sortedSizes, Rectangle2D initialBoundary, double shortestSide, List<Rectangle2D> rects) {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        double totalArea = 0.0;
        DoubleArrayList row = new DoubleArrayList();
        Rectangle2D boundary = initialBoundary;
        int head = 0;
        while (head < sortedSizes.length) {
            boolean isBetter;
            double newArea = sortedSizes[head];
            boolean bl = isBetter = this.maxAspectRatio(min, max, totalArea, shortestSide) >= this.maxAspectRatio(min, max, totalArea + newArea, shortestSide);
            if (head == sortedSizes.length - 1 || row.isEmpty() || isBetter) {
                row.add(newArea);
                min = Math.min(min, newArea);
                max = Math.max(max, newArea);
                totalArea += newArea;
                if (++head != sortedSizes.length) continue;
                this.layoutRow(boundary, rects, (DoubleList)row);
                continue;
            }
            boundary = this.layoutRow(boundary, rects, (DoubleList)row);
            shortestSide = Math.min(boundary.getWidth(), boundary.getHeight());
            row = new DoubleArrayList();
            min = Double.POSITIVE_INFINITY;
            max = Double.NEGATIVE_INFINITY;
            totalArea = 0.0;
        }
    }

    protected Rectangle2D layoutRow(Rectangle2D boundary, List<Rectangle2D> rects, DoubleList row) {
        double sumOfAreas = 0.0;
        for (int i = 0; i < row.size(); ++i) {
            sumOfAreas += row.getDouble(i);
        }
        boolean vertical = boundary.getWidth() >= boundary.getHeight();
        double x = boundary.getMinX();
        double y = boundary.getMaxY();
        double width = sumOfAreas / boundary.getHeight();
        double height = sumOfAreas / boundary.getWidth();
        for (int i = 0; i < row.size(); ++i) {
            double area = row.getDouble(i);
            if (vertical) {
                height = area / width;
            } else {
                width = area / height;
            }
            Rectangle2D.Double rect = new Rectangle2D.Double(x, y - height, width, height);
            rects.add(rect);
            if (vertical) {
                y -= height;
                continue;
            }
            x += width;
        }
        if (vertical) {
            return new Rectangle2D.Double(boundary.getMinX() + width, boundary.getMinY(), boundary.getWidth() - width, boundary.getHeight());
        }
        return new Rectangle2D.Double(boundary.getMinX(), boundary.getMinY(), boundary.getWidth(), boundary.getHeight() - height);
    }

    protected double maxAspectRatio(double minArea, double maxArea, double totalArea, double fixedSide) {
        double ratio = totalArea * totalArea / (fixedSide * fixedSide);
        double worst = Math.max(maxArea / ratio, ratio / minArea);
        return worst;
    }

    protected int[] sortDescending(final double[] areas) {
        int[] indexes = new int[areas.length];
        for (int i = 0; i < areas.length; ++i) {
            indexes[i] = i;
        }
        IntArrays.quickSort((int[])indexes, (IntComparator)new IntComparator(){

            public int compare(Integer o1, Integer o2) {
                return this.compare((int)o1, (int)o2);
            }

            public int compare(int k1, int k2) {
                return Double.compare(areas[k2], areas[k1]);
            }
        });
        return indexes;
    }
}

