/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.treemap;

import com.metsci.glimpse.painter.treemap.TreeMapLayout;
import java.awt.geom.Rectangle2D;

public class SliceAndDiceLayout
implements TreeMapLayout {
    @Override
    public Rectangle2D[] layout(Rectangle2D boundary, double[] sizes, int level) {
        boolean horizontal = level % 2 == 0;
        double area = boundary.getWidth() * boundary.getHeight();
        double totalSize = 0.0;
        for (int i = 0; i < sizes.length; ++i) {
            totalSize += sizes[i];
        }
        Rectangle2D[] rects = new Rectangle2D[sizes.length];
        double xOffset = boundary.getMinX();
        double yOffset = boundary.getMinY();
        for (int i = 0; i < sizes.length; ++i) {
            double scaledSize = sizes[i] / totalSize * area;
            double height = boundary.getHeight();
            double width = boundary.getWidth();
            if (horizontal) {
                width = scaledSize / boundary.getHeight();
            } else {
                height = scaledSize / boundary.getWidth();
            }
            rects[i] = new Rectangle2D.Double(xOffset, yOffset, width, height);
            if (horizontal) {
                xOffset += width;
                continue;
            }
            yOffset += height;
        }
        return rects;
    }
}

