/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.treemap;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.treemap.AbstractTreeMapPainter;
import com.metsci.glimpse.support.font.FontUtils;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class SimpleTreeMapPainter
extends AbstractTreeMapPainter {
    protected float[] borderColor = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
    protected float[] selectedTitleBackgroundColor = new float[]{1.0f, 0.2f, 0.2f, 1.0f};
    protected float[] leafColor = new float[]{0.7f, 0.7f, 1.0f, 1.0f};
    protected float[] selectedLeafColor = new float[]{0.2f, 0.2f, 0.2f, 0.3f};
    protected float[] titleBorderColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected TextRenderer titleRenderer;
    protected TextRenderer textRenderer;
    protected Color titleColor = Color.white;
    protected Color textColor = Color.darkGray;
    protected Font titleFont = FontUtils.getDefaultBold(14.0f);
    protected Font textFont = FontUtils.getDefaultItalic(12.0f);

    public float[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(float[] borderColor) {
        this.borderColor = borderColor;
    }

    public Color getTitleColor() {
        return this.titleColor;
    }

    public void setTitleColor(Color titleColor) {
        this.titleColor = titleColor;
    }

    public float[] getTitleBorderColor() {
        return this.titleBorderColor;
    }

    public void setTitleBorderColor(float[] titleBorderColor) {
        this.titleBorderColor = titleBorderColor;
    }

    public float[] getSelectedTitleBackgroundColor() {
        return this.selectedTitleBackgroundColor;
    }

    public void setSelectedTitleBackgroundColor(float[] selectedTitleBackgroundColor) {
        this.selectedTitleBackgroundColor = selectedTitleBackgroundColor;
    }

    public float[] getLeafColor() {
        return this.leafColor;
    }

    public void setLeafColor(float[] leafColor) {
        this.leafColor = leafColor;
    }

    public float[] getSelectedLeafColor() {
        return this.selectedLeafColor;
    }

    public void setSelectedLeafColor(float[] selectedLeafColor) {
        this.selectedLeafColor = selectedLeafColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public Font getTextFont() {
        return this.textFont;
    }

    public void setTextFont(Font textFont) {
        this.textFont = textFont;
    }

    @Override
    public void dispose(GLContext context) {
        super.dispose(context);
        if (this.titleRenderer != null) {
            this.titleRenderer.dispose();
            this.titleRenderer = null;
        }
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
            this.textRenderer = null;
        }
    }

    @Override
    protected void drawBorder(GL gl, Axis2D axis, GlimpseBounds layoutBounds, Rectangle2D nodeBounds, int nodeId) {
        float[] color = this.getBorderColor(nodeId, this.isSelected(axis, nodeBounds));
        gl.glColor4f(color[0], color[1], color[2], color[3]);
        gl.glLineWidth(1.0f);
        gl.glBegin(2);
        gl.glVertex2d(nodeBounds.getMinX(), nodeBounds.getMinY());
        gl.glVertex2d(nodeBounds.getMinX(), nodeBounds.getMaxY());
        gl.glVertex2d(nodeBounds.getMaxX(), nodeBounds.getMaxY());
        gl.glVertex2d(nodeBounds.getMaxX(), nodeBounds.getMinY());
        gl.glEnd();
    }

    @Override
    protected void drawLeafBackground(GL gl, Axis2D axis, GlimpseBounds layoutBounds, Rectangle2D nodeBounds, int leafId) {
        float[] color = this.getLeafColor(leafId, false);
        gl.glColor4f(color[0], color[1], color[2], color[3]);
        gl.glRectd(nodeBounds.getMinX(), nodeBounds.getMinY(), nodeBounds.getMaxX(), nodeBounds.getMaxY());
        if (this.isSelected(axis, nodeBounds)) {
            color = this.getLeafColor(leafId, true);
            gl.glColor4f(color[0], color[1], color[2], color[3]);
            gl.glRectd(nodeBounds.getMinX(), nodeBounds.getMinY(), nodeBounds.getMaxX(), nodeBounds.getMaxY());
        }
    }

    @Override
    protected Rectangle2D drawTitle(GL gl, Axis2D axis, GlimpseBounds layoutBounds, Rectangle2D boundary, int nodeId) {
        String title = this.tree.getTitle(nodeId);
        if (title == null) {
            return boundary;
        }
        if (this.titleRenderer == null) {
            this.titleRenderer = new TextRenderer(this.titleFont);
        }
        boolean selected = this.isSelected(axis, boundary);
        Rectangle2D rect = this.titleRenderer.getBounds(title);
        int textBorderPx = 3;
        double borderHeightPx = rect.getHeight() + (double)(textBorderPx * 2);
        double borderHeight = borderHeightPx / axis.getAxisY().getPixelsPerValue();
        if (boundary.getHeight() < borderHeight || boundary.getWidth() < rect.getWidth() / axis.getAxisX().getPixelsPerValue()) {
            return boundary;
        }
        float[] color = this.getTitleBackgroundColor(nodeId, selected);
        gl.glColor4f(color[0], color[1], color[2], color[3]);
        gl.glRectd(boundary.getMinX(), boundary.getMaxY() - borderHeight, boundary.getMaxX(), boundary.getMaxY());
        color = this.getTitleBorderColor(nodeId, selected);
        gl.glColor4f(color[0], color[1], color[2], color[3]);
        gl.glLineWidth(0.5f);
        gl.glBegin(2);
        gl.glVertex2d(boundary.getMinX(), boundary.getMaxY() - borderHeight);
        gl.glVertex2d(boundary.getMinX(), boundary.getMaxY());
        gl.glVertex2d(boundary.getMaxX(), boundary.getMaxY());
        gl.glVertex2d(boundary.getMaxX(), boundary.getMaxY() - borderHeight);
        gl.glEnd();
        int textPosX = axis.getAxisX().valueToScreenPixel(boundary.getMinX());
        int textPosY = axis.getAxisY().valueToScreenPixel(boundary.getMaxY()) - (int)borderHeightPx;
        this.titleRenderer.setColor(this.titleColor);
        this.titleRenderer.beginRendering(layoutBounds.getWidth(), layoutBounds.getHeight());
        this.titleRenderer.draw(title, textPosX + textBorderPx, textPosY + textBorderPx);
        this.titleRenderer.endRendering();
        Rectangle2D.Double newBoundary = new Rectangle2D.Double(boundary.getMinX(), boundary.getMinY(), boundary.getWidth(), boundary.getHeight() - borderHeight);
        return newBoundary;
    }

    @Override
    protected void drawLeafInterior(GL gl, Axis2D axis, GlimpseBounds layoutBounds, Rectangle2D nodeBounds, int leafId) {
        String text = this.tree.getText(leafId);
        if (text == null) {
            return;
        }
        if (this.textRenderer == null) {
            this.textRenderer = new TextRenderer(this.textFont);
        }
        Rectangle2D rect = this.textRenderer.getBounds(text);
        int paddingTopPx = 10;
        int textPosX = axis.getAxisX().valueToScreenPixel(nodeBounds.getCenterX()) - (int)(rect.getWidth() / 2.0);
        textPosX = Math.max(textPosX, axis.getAxisX().valueToScreenPixel(nodeBounds.getMinX()));
        int textPosY = axis.getAxisY().valueToScreenPixel(nodeBounds.getMaxY()) - (int)rect.getHeight() - paddingTopPx;
        textPosY = Math.max(textPosY, axis.getAxisY().valueToScreenPixel(nodeBounds.getMinY()));
        if (nodeBounds.getWidth() < rect.getWidth() / axis.getAxisX().getPixelsPerValue() || nodeBounds.getHeight() - (double)paddingTopPx < rect.getHeight() / axis.getAxisY().getPixelsPerValue()) {
            return;
        }
        this.textRenderer.setColor(this.textColor);
        this.textRenderer.beginRendering(layoutBounds.getWidth(), layoutBounds.getHeight());
        this.textRenderer.draw(text, textPosX, textPosY);
        this.textRenderer.endRendering();
    }

    protected float[] getLeafColor(int nodeId, boolean selected) {
        if (selected) {
            return this.selectedLeafColor;
        }
        return this.leafColor;
    }

    protected float[] getBorderColor(int nodeId, boolean selected) {
        return this.borderColor;
    }

    protected float[] getTitleBackgroundColor(int nodeId, boolean selected) {
        if (selected) {
            return this.selectedTitleBackgroundColor;
        }
        return this.getBorderColor(nodeId, false);
    }

    protected float[] getTitleBorderColor(int nodeId, boolean selected) {
        return this.titleBorderColor;
    }
}

