/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.treemap;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.painter.treemap.NestedTreeMap;
import com.metsci.glimpse.painter.treemap.SquarifiedLayout;
import com.metsci.glimpse.painter.treemap.TreeMapLayout;
import it.unimi.dsi.fastutil.ints.Int2ObjectAVLTreeMap;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public abstract class AbstractTreeMapPainter
extends GlimpseDataPainter2D {
    protected NestedTreeMap tree;
    protected int treeVersionId;
    protected TreeMapLayout treeLayout = new SquarifiedLayout();
    protected LayoutCache layoutCache;

    public void setLayout(TreeMapLayout layout) {
        this.treeLayout = layout;
        this.flushLayoutCache();
    }

    public TreeMapLayout getTreeMapLayout() {
        return this.treeLayout;
    }

    public void setTreeMapData(NestedTreeMap tree) {
        this.tree = tree;
        this.flushLayoutCache();
    }

    public NestedTreeMap getTreeMapData() {
        return this.tree;
    }

    public Integer getLeafAt(Axis2D axis, double x, double y) {
        if (this.tree == null || this.tree.isEmpty() || this.treeLayout == null) {
            return null;
        }
        this.updateLayoutCache(axis);
        return this.getLeafAtHelper(new Point2D.Double(x, y), this.tree.getRoot());
    }

    protected Integer getLeafAtHelper(Point2D point, int node) {
        Rectangle2D[] rects = (Rectangle2D[])this.layoutCache.get(node);
        int[] children = this.tree.getChildren(node);
        for (int i = 0; i < children.length; ++i) {
            if (!rects[i].contains(point)) continue;
            return this.getLeafAtHelper(point, children[i]);
        }
        return node;
    }

    @Override
    public void paintTo(GL gl, GlimpseBounds layoutBounds, Axis2D axis) {
        if (this.tree == null || this.tree.isEmpty() || this.treeLayout == null) {
            return;
        }
        gl.glEnable(3089);
        this.updateLayoutCache(axis);
        double width = axis.getAxisX().getAbsoluteMax() - axis.getAxisY().getAbsoluteMin();
        double height = axis.getAxisY().getAbsoluteMax() - axis.getAxisY().getAbsoluteMin();
        Rectangle2D.Double nodeBounds = new Rectangle2D.Double(0.0, 0.0, width, height);
        this.displayNode(gl, axis, layoutBounds, nodeBounds, this.tree.getRoot());
    }

    @Override
    public void dispose(GLContext context) {
    }

    protected void flushLayoutCache() {
        if (this.tree != null) {
            this.treeVersionId = this.tree.getVersion() - 1;
        }
    }

    protected void updateLayoutCache(Axis2D axis) {
        if (this.layoutCache == null || !this.layoutCache.isValid(axis) || this.treeVersionId != this.tree.getVersion()) {
            double width = axis.getAxisX().getAbsoluteMax() - axis.getAxisY().getAbsoluteMin();
            double height = axis.getAxisY().getAbsoluteMax() - axis.getAxisY().getAbsoluteMin();
            Rectangle2D.Double boundary = new Rectangle2D.Double(0.0, 0.0, width, height);
            this.layoutCache = new LayoutCache(axis);
            this.populateLayout(this.tree.getRoot(), boundary);
            this.treeVersionId = this.tree.getVersion();
        }
    }

    protected void populateLayout(int nodeId, Rectangle2D boundary) {
        double[] sizes = this.tree.getSizesOfChildren(nodeId);
        if (sizes.length > 0) {
            Rectangle2D[] rects = this.getTreeMapLayout().layout(boundary, sizes, this.tree.getLevel(nodeId));
            rects = Arrays.copyOf(rects, rects.length + 1);
            rects[rects.length - 1] = boundary;
            this.layoutCache.put(nodeId, rects);
            int[] children = this.tree.getChildren(nodeId);
            for (int i = 0; i < children.length; ++i) {
                this.populateLayout(children[i], rects[i]);
            }
        }
    }

    protected Rectangle2D[] getLayout(Rectangle2D boundary, int nodeId) {
        Rectangle2D[] rects = (Rectangle2D[])this.layoutCache.get(nodeId);
        Rectangle2D origBound = rects[rects.length - 1];
        boolean isOutdated = Math.abs(boundary.getHeight() - origBound.getHeight()) > 1.0E-6;
        if (isOutdated |= Math.abs(boundary.getWidth() - origBound.getWidth()) > 1.0E-6) {
            double scaleX = boundary.getWidth() / origBound.getWidth();
            double scaleY = boundary.getHeight() / origBound.getHeight();
            Rectangle2D[] newRects = new Rectangle2D[rects.length];
            for (int i = 0; i < rects.length - 1; ++i) {
                Rectangle2D oldRect = rects[i];
                Rectangle2D.Double newRect = new Rectangle2D.Double((oldRect.getMinX() - origBound.getMinX()) * scaleX + boundary.getMinX(), (oldRect.getMinY() - origBound.getMinY()) * scaleY + boundary.getMinY(), oldRect.getWidth() * scaleX, oldRect.getHeight() * scaleY);
                newRects[i] = newRect;
            }
            rects = newRects;
            rects[rects.length - 1] = boundary;
            this.layoutCache.put(nodeId, rects);
        }
        return rects;
    }

    protected void displayNode(GL gl, Axis2D axis, GlimpseBounds layoutBounds, Rectangle2D nodeBounds, int nodeId) {
        if (axis.getMinX() >= nodeBounds.getMaxX() || axis.getMinY() >= nodeBounds.getMaxY() || nodeBounds.getMinX() >= axis.getMaxX() || nodeBounds.getMinY() >= axis.getMaxY()) {
            return;
        }
        if (nodeBounds.getWidth() <= 0.0 || nodeBounds.getHeight() <= 0.0) {
            return;
        }
        int pxX = axis.getAxisX().valueToScreenPixel(nodeBounds.getMinX());
        int pxY = axis.getAxisY().valueToScreenPixel(nodeBounds.getMinY());
        int width = (int)Math.ceil(nodeBounds.getWidth() * axis.getAxisX().getPixelsPerValue());
        int height = (int)Math.ceil(nodeBounds.getHeight() * axis.getAxisY().getPixelsPerValue());
        gl.glScissor(pxX + layoutBounds.getX(), pxY + layoutBounds.getY(), width, height);
        if (this.tree.isLeaf(nodeId)) {
            this.drawLeaf(gl, axis, layoutBounds, nodeBounds, nodeId);
        } else {
            this.drawParent(gl, axis, layoutBounds, nodeBounds, nodeId);
        }
    }

    protected void drawParent(GL gl, Axis2D axis, GlimpseBounds layoutBounds, Rectangle2D nodeBounds, int nodeId) {
        Rectangle2D newBoundary = this.drawTitle(gl, axis, layoutBounds, nodeBounds, nodeId);
        if (newBoundary.getWidth() <= 0.0 || newBoundary.getHeight() <= 0.0) {
            return;
        }
        int[] children = this.tree.getChildren(nodeId);
        Rectangle2D[] childRects = this.getLayout(newBoundary, nodeId);
        for (int i = 0; i < children.length; ++i) {
            Rectangle2D childRect = childRects[i];
            int childId = children[i];
            this.displayNode(gl, axis, layoutBounds, childRect, childId);
        }
    }

    protected void drawLeaf(GL gl, Axis2D axis, GlimpseBounds layoutBounds, Rectangle2D nodeBounds, int leafId) {
        this.drawLeafBackground(gl, axis, layoutBounds, nodeBounds, leafId);
        Rectangle2D newBoundary = this.drawTitle(gl, axis, layoutBounds, nodeBounds, leafId);
        if (newBoundary.getWidth() <= 0.0 || newBoundary.getHeight() <= 0.0) {
            return;
        }
        this.drawBorder(gl, axis, layoutBounds, nodeBounds, leafId);
        this.drawLeafInterior(gl, axis, layoutBounds, newBoundary, leafId);
    }

    protected boolean isSelected(Axis2D axis, Rectangle2D boundary) {
        return boundary.contains(axis.getAxisX().getSelectionCenter(), axis.getAxisY().getSelectionCenter());
    }

    protected abstract Rectangle2D drawTitle(GL var1, Axis2D var2, GlimpseBounds var3, Rectangle2D var4, int var5);

    protected abstract void drawLeafInterior(GL var1, Axis2D var2, GlimpseBounds var3, Rectangle2D var4, int var5);

    protected abstract void drawLeafBackground(GL var1, Axis2D var2, GlimpseBounds var3, Rectangle2D var4, int var5);

    protected abstract void drawBorder(GL var1, Axis2D var2, GlimpseBounds var3, Rectangle2D var4, int var5);

    protected class LayoutCache
    extends Int2ObjectAVLTreeMap<Rectangle2D[]> {
        private double absoluteMinX;
        private double absoluteMaxX;
        private double absoluteMinY;
        private double absoluteMaxY;

        public LayoutCache(Axis2D axis) {
            this.absoluteMinX = axis.getAxisX().getAbsoluteMin();
            this.absoluteMaxX = axis.getAxisX().getAbsoluteMax();
            this.absoluteMinY = axis.getAxisY().getAbsoluteMin();
            this.absoluteMaxY = axis.getAxisY().getAbsoluteMax();
        }

        public boolean isValid(Axis2D axis) {
            return this.absoluteMinX == axis.getAxisX().getAbsoluteMin() && this.absoluteMaxX == axis.getAxisX().getAbsoluteMax() && this.absoluteMinY == axis.getAxisY().getAbsoluteMin() && this.absoluteMaxY == axis.getAxisY().getAbsoluteMax();
        }
    }
}

