/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.track;

import com.metsci.glimpse.painter.track.TrackPainter;
import com.metsci.glimpse.util.primitives.IntsArray;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class Pulsator {
    protected TrackPainter painter;
    protected long delayMillis;
    protected float min;
    protected float max;
    protected float start;
    protected float step;
    protected float size;
    protected float direction;
    protected boolean paused;
    protected IntsArray ids;
    protected ReentrantLock lock;
    protected Condition pauseCondition;

    public Pulsator(TrackPainter painter, long delayMillis, float minSize, float stepSize, float maxSize) {
        this.painter = painter;
        this.delayMillis = delayMillis;
        this.min = minSize;
        this.max = maxSize;
        this.step = stepSize;
        this.start = maxSize;
        this.direction = -1.0f;
        this.paused = false;
        this.ids = new IntsArray();
        this.lock = new ReentrantLock();
        this.pauseCondition = this.lock.newCondition();
    }

    public Pulsator(TrackPainter painter) {
        this(painter, 10L, 10.0f, 0.1f, 15.0f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetSize() {
        this.lock.lock();
        try {
            this.size = this.start;
            this.direction = -1.0f;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPaused(boolean paused) {
        this.lock.lock();
        try {
            this.paused = paused;
            if (!this.paused) {
                this.pauseCondition.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDelayMillis() {
        this.lock.lock();
        try {
            long l = this.delayMillis;
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDelayMillis(long delayMillis) {
        this.lock.lock();
        try {
            this.delayMillis = delayMillis;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMin() {
        this.lock.lock();
        try {
            float f = this.min;
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMin(float min) {
        this.lock.lock();
        try {
            this.min = min;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getMax() {
        this.lock.lock();
        try {
            float f = this.max;
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMax(float max) {
        this.lock.lock();
        try {
            this.max = max;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getStep() {
        this.lock.lock();
        try {
            float f = this.step;
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStep(float step) {
        this.lock.lock();
        try {
            this.step = step;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float getSize() {
        this.lock.lock();
        try {
            float f = this.size;
            return f;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSize(float size) {
        this.lock.lock();
        try {
            this.size = size;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addId(int id) {
        this.lock.lock();
        try {
            this.ids.append(id);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeId(int id) {
        this.lock.lock();
        try {
            this.ids.remove(id);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void start() {
        Thread t = new Thread("Pulsator"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (true) {
                    Pulsator.this.lock.lock();
                    try {
                        while (Pulsator.this.paused) {
                            try {
                                Pulsator.this.pauseCondition.await();
                            }
                            catch (InterruptedException e) {}
                        }
                        if (Pulsator.this.size > Pulsator.this.max) {
                            Pulsator.this.direction = -1.0f;
                            Pulsator.this.size = Pulsator.this.max;
                        } else if (Pulsator.this.size < Pulsator.this.min) {
                            Pulsator.this.direction = 1.0f;
                            Pulsator.this.size = Pulsator.this.min;
                        }
                        Pulsator.this.size += Pulsator.this.step * Pulsator.this.direction;
                        for (int i = 0; i < Pulsator.this.ids.n; ++i) {
                            Pulsator.this.painter.setPointSize(Pulsator.this.ids.a[i], Pulsator.this.size);
                        }
                    }
                    finally {
                        Pulsator.this.lock.unlock();
                    }
                    try {
                        Thread.sleep(Pulsator.this.delayMillis);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
        };
        t.start();
    }
}

