/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.texture;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.listener.AxisListener1D;
import com.metsci.glimpse.axis.tagged.Tag;
import com.metsci.glimpse.axis.tagged.TaggedAxis1D;
import com.metsci.glimpse.axis.tagged.shader.TaggedColorScaleShader;
import com.metsci.glimpse.gl.shader.Pipeline;
import com.metsci.glimpse.gl.texture.FloatTexture1D;
import com.metsci.glimpse.painter.texture.HeatMapPainter;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.List;

public class TaggedHeatMapPainter
extends HeatMapPainter
implements AxisListener1D {
    protected static final int DEFAULT_DATA_COORD_UNIT = 2;
    protected static final int DEFAULT_TEX_COORD_UNIT = 3;
    private FloatTexture1D vertexCoordTex;
    private FloatTexture1D textureCoordTex;
    private TaggedColorScaleShader fragShader;
    private TaggedAxis1D taggedAxis;

    public TaggedHeatMapPainter(TaggedAxis1D taggedAxis) {
        super(taggedAxis);
        this.taggedAxis = taggedAxis;
        this.updateTextureArrays();
        this.taggedAxis.addAxisListener(this);
    }

    @Override
    protected void loadDefaultPipeline(Axis1D axis) throws IOException {
        this.fragShader = new TaggedColorScaleShader((TaggedAxis1D)axis, 0, 1, 2, 3);
        this.setPipeline(new Pipeline("colormap", null, null, this.fragShader));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAlpha(float alpha) {
        this.lock.lock();
        try {
            this.fragShader.setAlpha(alpha);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscardNaN(boolean discard) {
        this.lock.lock();
        try {
            this.fragShader.setDiscardNaN(discard);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscardAbove(boolean discard) {
        this.lock.lock();
        try {
            this.fragShader.setDiscardAbove(discard);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscardBelow(boolean discard) {
        this.lock.lock();
        try {
            this.fragShader.setDiscardBelow(discard);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void axisUpdated(Axis1D axis) {
        this.updateTextureArrays();
    }

    protected void updateTextureArrays() {
        final List<Tag> tags = this.taggedAxis.getSortedTags();
        int count = 0;
        for (Tag tag : tags) {
            if (!tag.hasAttribute("TexCoord")) continue;
            ++count;
        }
        if (this.vertexCoordTex == null || this.vertexCoordTex.getDimensionSize(0) != count) {
            this.removeNonDrawableTexture(this.vertexCoordTex);
            this.vertexCoordTex = new FloatTexture1D(count);
            this.addNonDrawableTexture(this.vertexCoordTex, 2);
        }
        this.vertexCoordTex.mutate(new FloatTexture1D.MutatorFloat1D(){

            @Override
            public void mutate(FloatBuffer data, int n0) {
                int size = Math.min(tags.size(), n0);
                for (int i = size - 1; i >= 0; --i) {
                    Tag tag = (Tag)tags.get(i);
                    if (!tag.hasAttribute("TexCoord")) continue;
                    data.put((float)tag.getValue());
                }
            }
        });
        if (this.textureCoordTex == null || this.textureCoordTex.getDimensionSize(0) != count) {
            this.removeNonDrawableTexture(this.textureCoordTex);
            this.textureCoordTex = new FloatTexture1D(count);
            this.addNonDrawableTexture(this.textureCoordTex, 3);
        }
        this.textureCoordTex.mutate(new FloatTexture1D.MutatorFloat1D(){

            @Override
            public void mutate(FloatBuffer data, int n0) {
                int size = Math.min(tags.size(), n0);
                for (int i = size - 1; i >= 0; --i) {
                    Tag tag = (Tag)tags.get(i);
                    Object attribute = tag.getAttribute("TexCoord");
                    if (attribute == null) continue;
                    data.put(((Float)attribute).floatValue());
                }
            }
        });
    }
}

