/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.texture;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.gl.shader.Pipeline;
import com.metsci.glimpse.gl.texture.DrawableTexture;
import com.metsci.glimpse.gl.texture.Texture;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class ShadedTexturePainter
extends GlimpsePainter2D {
    protected static final int DEFAULT_DRAWABLE_TEXTURE_UNIT = 0;
    protected static final int DEFAULT_NONDRAWABLE_TEXTURE_UNIT = 1;
    protected final ReentrantLock lock = new ReentrantLock();
    protected Set<TextureUnit<Texture>> nonDrawableTextures = new HashSet<TextureUnit<Texture>>();
    protected Set<TextureUnit<DrawableTexture>> drawableTextures = new HashSet<TextureUnit<DrawableTexture>>();
    protected Pipeline pipeline;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPipeline(Pipeline pipeline) {
        this.lock.lock();
        try {
            this.pipeline = pipeline;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addDrawableTexture(DrawableTexture texture) {
        this.addDrawableTexture(texture, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDrawableTexture(DrawableTexture texture, int textureUnit) {
        this.lock.lock();
        try {
            this.drawableTextures.add(new TextureUnit<DrawableTexture>(textureUnit, texture));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDrawableTexture(DrawableTexture texture) {
        this.lock.lock();
        try {
            this.drawableTextures.remove(new TextureUnit<DrawableTexture>(texture));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllDrawableTextures() {
        this.lock.lock();
        try {
            this.drawableTextures.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void addNonDrawableTexture(Texture texture) {
        this.addNonDrawableTexture(texture, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNonDrawableTexture(Texture texture, int textureUnit) {
        this.lock.lock();
        try {
            this.nonDrawableTextures.add(new TextureUnit<Texture>(textureUnit, texture));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNonDrawableTexture(Texture texture) {
        this.lock.lock();
        try {
            this.nonDrawableTextures.remove(new TextureUnit<Texture>(texture));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllNonDrawableTextures() {
        this.lock.lock();
        try {
            this.nonDrawableTextures.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        GL gl = context.getGL();
        this.lock.lock();
        try {
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glOrtho(axis.getMinX(), axis.getMaxX(), axis.getMinY(), axis.getMaxY(), -1.0, 1.0);
            if (this.pipeline != null) {
                this.pipeline.beginUse(gl);
            }
            try {
                for (TextureUnit<Texture> textureUnit : this.nonDrawableTextures) {
                    this.prepare(textureUnit, gl);
                }
                for (TextureUnit<Texture> textureUnit : this.drawableTextures) {
                    this.draw(textureUnit, gl);
                }
            }
            finally {
                if (this.pipeline != null) {
                    this.pipeline.endUse(gl);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void draw(TextureUnit<DrawableTexture> textureUnit, GL gl) {
        ((DrawableTexture)textureUnit.texture).draw(gl, textureUnit.textureUnit);
    }

    protected void prepare(TextureUnit<Texture> textureUnit, GL gl) {
        textureUnit.texture.prepare(gl, textureUnit.textureUnit);
    }

    @Override
    public void dispose(GLContext context) {
        if (this.pipeline != null) {
            this.pipeline.dispose(context);
        }
    }

    static class TextureUnit<D extends Texture> {
        protected int textureUnit;
        protected D texture;

        public TextureUnit(D texture) {
            this(0, texture);
        }

        public TextureUnit(int textureUnit, D texture) {
            this.textureUnit = textureUnit;
            this.texture = texture;
        }

        public int getTextureUnit() {
            return this.textureUnit;
        }

        public D getTexture() {
            return this.texture;
        }

        public int hashCode() {
            return 31 + (this.texture == null ? 0 : this.texture.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TextureUnit other = (TextureUnit)obj;
            if (this.texture == null) {
                return other.texture == null;
            }
            return this.texture.equals(other.texture);
        }
    }
}

