/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.shape;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.support.colormap.ColorMap;
import com.metsci.glimpse.util.quadtree.QuadTreeXys;
import com.metsci.glimpse.util.quadtree.Xy;
import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class PointSetPainter
extends GlimpseDataPainter2D {
    public static final int QUAD_TREE_BIN_MAX = 1000;
    public static final long SPATIAL_SELECTION_UPDATE_RATE = 50L;
    protected float[] pointColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected float pointSize = 2.0f;
    protected int dataSize = 0;
    protected int[] colorHandle = null;
    protected FloatBuffer colorBuffer = null;
    protected boolean useColorDevice = false;
    protected boolean useColorHost = false;
    protected int[] bufferHandle = null;
    protected FloatBuffer dataBuffer = null;
    protected ReentrantLock dataBufferLock = new ReentrantLock();
    protected volatile boolean newData = false;
    protected volatile boolean bufferInitialized = false;
    protected QuadTreeXys<IdXy> spatialIndex;
    protected boolean enableSpatialIndex;

    public PointSetPainter(boolean enableSpatialIndex) {
        this.enableSpatialIndex = enableSpatialIndex;
    }

    public void setData(float[] dataX, float[] dataY) {
        int dataSize = Math.min(dataX.length, dataY.length);
        this.setData(dataX, dataY, dataSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(float[] dataX, float[] dataY, int dataSize) {
        if (dataSize < 0 || dataSize > dataX.length || dataSize > dataY.length) {
            throw new IllegalArgumentException("Illegal dataSize: dataSize = " + dataSize + ", dataX.length = " + dataX.length + ", dataY.length = " + dataY.length);
        }
        this.dataBufferLock.lock();
        try {
            int i;
            this.dataSize = dataSize;
            if (this.dataBuffer == null || this.dataBuffer.rewind().capacity() < dataSize * 2) {
                this.dataBuffer = BufferUtil.newFloatBuffer((int)(dataSize * 2));
            }
            for (i = 0; i < dataSize; ++i) {
                this.dataBuffer.put(dataX[i]).put(dataY[i]);
            }
            if (this.enableSpatialIndex) {
                this.spatialIndex = new QuadTreeXys(1000);
                for (i = 0; i < dataSize; ++i) {
                    this.spatialIndex.add((Xy)new IdXy(i, dataX[i], dataY[i]));
                }
            }
            this.newData = true;
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColor(float[] dataZ, ColorMap scale) {
        this.dataBufferLock.lock();
        try {
            if (this.colorBuffer == null || this.colorBuffer.rewind().capacity() < this.dataSize * 4) {
                this.colorBuffer = BufferUtil.newFloatBuffer((int)(this.dataSize * 4));
            }
            float[] color = new float[4];
            for (int i = 0; i < this.dataSize; ++i) {
                scale.toColor(dataZ[i], color);
                this.colorBuffer.put(color[0]).put(color[1]).put(color[2]).put(color[3]);
            }
            this.useColorHost = true;
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    public Collection<IdXy> selectGeoRange(double minX, double maxX, double minY, double maxY) {
        return this.enableSpatialIndex ? this.spatialIndex.search((float)minX, (float)maxX, (float)minY, (float)maxY) : null;
    }

    public Collection<IdXy> currentSelection(Axis2D axis) {
        double centerX = axis.getAxisX().getSelectionCenter();
        double sizeX = axis.getAxisX().getSelectionSize() / 2.0;
        double centerY = axis.getAxisY().getSelectionCenter();
        double sizeY = axis.getAxisY().getSelectionSize() / 2.0;
        double minX = centerX - sizeX;
        double maxX = centerX + sizeX;
        double minY = centerY - sizeY;
        double maxY = centerY + sizeY;
        return this.selectGeoRange(minX, maxX, minY, maxY);
    }

    public void setPointColor(float r, float g, float b, float a) {
        this.pointColor[0] = r;
        this.pointColor[1] = g;
        this.pointColor[2] = b;
        this.pointColor[3] = a;
    }

    public void setPointSize(float pointSize) {
        this.pointSize = pointSize;
    }

    @Override
    public void dispose(GLContext context) {
        if (this.bufferInitialized) {
            context.getGL().glDeleteBuffers(1, this.colorHandle, 0);
            context.getGL().glDeleteBuffers(1, this.bufferHandle, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        if (this.dataSize == 0) {
            return;
        }
        if (!this.bufferInitialized) {
            this.bufferHandle = new int[1];
            gl.glGenBuffers(1, this.bufferHandle, 0);
            this.colorHandle = new int[1];
            gl.glGenBuffers(1, this.colorHandle, 0);
            this.bufferInitialized = true;
        }
        if (this.newData) {
            this.dataBufferLock.lock();
            try {
                gl.glBindBuffer(34962, this.bufferHandle[0]);
                gl.glBufferData(34962, this.dataSize * 2 * 4, this.dataBuffer.rewind(), 35048);
                this.glHandleError(gl);
                this.useColorDevice = this.useColorHost;
                if (this.useColorDevice) {
                    gl.glBindBuffer(34962, this.colorHandle[0]);
                    gl.glBufferData(34962, this.dataSize * 4 * 4, this.colorBuffer.rewind(), 35048);
                    this.glHandleError(gl);
                }
                this.newData = false;
            }
            finally {
                this.dataBufferLock.unlock();
            }
        }
        if (this.useColorDevice) {
            gl.glBindBuffer(34962, this.colorHandle[0]);
            gl.glColorPointer(4, 5126, 0, 0L);
            gl.glEnableClientState(32886);
        }
        gl.glBindBuffer(34962, this.bufferHandle[0]);
        gl.glVertexPointer(2, 5126, 0, 0L);
        gl.glEnableClientState(32884);
        gl.glColor4fv(this.pointColor, 0);
        gl.glPointSize(this.pointSize);
        gl.glDrawArrays(0, 0, this.dataSize);
    }

    public static class IdXy
    implements Xy {
        private float x;
        private float y;
        private int id;

        public IdXy(int id, float x, float y) {
            this.id = id;
            this.x = x;
            this.y = y;
        }

        public int id() {
            return this.id;
        }

        public float x() {
            return this.x;
        }

        public float y() {
            return this.y;
        }
    }
}

