/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.shape;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer;
import com.metsci.glimpse.gl.attribute.GLFloatBuffer2D;
import com.metsci.glimpse.gl.attribute.GLVertexAttribute;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.util.primitives.FloatsArray;
import com.metsci.glimpse.util.primitives.IntsArray;
import com.metsci.glimpse.util.primitives.IntsModifiable;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;

public class DynamicPointSetPainter
extends GlimpseDataPainter2D {
    protected static final double GROWTH_FACTOR = 1.3;
    protected static final float DEFAULT_POINT_SIZE = 5.0f;
    protected static final int DEFAULT_INITIAL_SIZE = 2000;
    protected static final float[] DEFAULT_COLOR = GlimpseColor.getBlack();
    protected float pointSize = 5.0f;
    protected int bufferSize;
    protected GLFloatBuffer colorBuffer;
    protected GLFloatBuffer2D pointBuffer;
    protected Map<Object, Integer> idMap;
    protected Map<Integer, Object> indexMap;
    protected ReentrantLock lock;
    protected IntsArray searchResults;

    public DynamicPointSetPainter() {
        this(2000);
    }

    public DynamicPointSetPainter(int initialSize) {
        this.bufferSize = initialSize;
        this.lock = new ReentrantLock();
        this.idMap = new LinkedHashMap<Object, Integer>();
        this.indexMap = new LinkedHashMap<Integer, Object>();
        this.pointBuffer = new GLFloatBuffer2D(initialSize, true);
        this.colorBuffer = new GLFloatBuffer(initialSize, 4);
        this.searchResults = new IntsArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Object> getGeoRange(double minX, double maxX, double minY, double maxY) {
        this.lock.lock();
        try {
            this.searchResults.n = 0;
            this.pointBuffer.search((float)minX, (float)maxX, (float)minY, (float)maxY, (IntsModifiable)this.searchResults);
            LinkedList<Object> resultList = new LinkedList<Object>();
            for (int i = 0; i < this.searchResults.n; ++i) {
                int index = this.searchResults.a[i];
                Object id = this.indexMap.get(index);
                if (id == null) continue;
                resultList.add(id);
            }
            LinkedList<Object> linkedList = resultList;
            return linkedList;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPointSize(float size) {
        this.lock.lock();
        try {
            this.pointSize = size;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPoints(BulkPointAccumulator accumulator) {
        this.lock.lock();
        try {
            int newPoints = accumulator.getSize();
            int currentSize = this.idMap.size();
            if (this.bufferSize < currentSize + newPoints) {
                this.growBuffers(currentSize + newPoints);
            }
            this.mutatePositions(accumulator);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putColors(BulkColorAccumulator accumulator) {
        this.lock.lock();
        try {
            this.mutateColors(accumulator);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void putPoint(Object id, float posX, float posY) {
        this.putPoint(id, posX, posY, DEFAULT_COLOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putPoint(Object id, float posX, float posY, float[] color) {
        this.lock.lock();
        try {
            int currentSize = this.idMap.size();
            if (this.bufferSize < currentSize + 1) {
                this.growBuffers(currentSize + 1);
            }
            int index = this.getIndex(id, true);
            this.mutatePosition(index, posX, posY);
            this.mutateColor(index, color);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putColor(Object id, float[] color) {
        this.lock.lock();
        try {
            int index = this.getIndex(id, false);
            this.mutateColor(index, color);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removePoint(Object id) {
        throw new UnsupportedOperationException("removePoint() is not yet supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        this.lock.lock();
        try {
            this.colorBuffer.bind(GLVertexAttribute.ATTRIB_COLOR_4D, gl);
            this.pointBuffer.bind(GLVertexAttribute.ATTRIB_POSITION_2D, gl);
            try {
                gl.glPointSize(this.pointSize);
                gl.glDrawArrays(0, 0, this.idMap.size());
            }
            finally {
                this.colorBuffer.unbind(gl);
                this.pointBuffer.unbind(gl);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected void mutateColor(final int index, final float[] color) {
        this.colorBuffer.mutate(new GLFloatBuffer.Mutator(){

            @Override
            public void mutate(FloatBuffer data, int length) {
                data.position(index * length);
                data.put(color[0]);
                data.put(color[1]);
                data.put(color[2]);
                data.put(color.length == 4 ? color[3] : 1.0f);
            }
        });
    }

    protected void mutatePosition(final int index, final float posX, final float posY) {
        this.pointBuffer.mutateIndexed(new GLFloatBuffer2D.IndexedMutator(){

            @Override
            public int getUpdateIndex() {
                return index;
            }

            @Override
            public void mutate(FloatBuffer data, int length) {
                data.position(index * length);
                data.put(posX);
                data.put(posY);
            }
        });
    }

    protected int getIndexArray(List<Object> ids, boolean grow, int[] listIndex) {
        int size;
        int minIndex = size = ids.size();
        for (int i = 0; i < size; ++i) {
            int index;
            listIndex[i] = index = this.getIndex(ids.get(i), grow);
            if (minIndex <= index) continue;
            minIndex = index;
        }
        return minIndex;
    }

    protected void mutatePositions(BulkPointAccumulator accumulator) {
        List<Object> ids = accumulator.getIds();
        final float[] v = accumulator.getVertices();
        final int stride = accumulator.getStride();
        final int size = accumulator.getSize();
        final int[] indexList = new int[size];
        final int minIndex = this.getIndexArray(ids, true, indexList);
        this.pointBuffer.mutateIndexed(new GLFloatBuffer2D.IndexedMutator(){

            @Override
            public int getUpdateIndex() {
                return minIndex;
            }

            @Override
            public void mutate(FloatBuffer data, int length) {
                for (int i = 0; i < size; ++i) {
                    data.position(indexList[i] * length);
                    data.put(v, i * stride, length);
                }
            }
        });
        this.colorBuffer.mutate(new GLFloatBuffer.Mutator(){

            @Override
            public void mutate(FloatBuffer data, int length) {
                for (int i = 0; i < size; ++i) {
                    data.position(indexList[i] * length);
                    data.put(v, i * stride + 2, length);
                }
            }
        });
    }

    protected void mutateColors(BulkColorAccumulator accumulator) {
        List<Object> ids = accumulator.getIds();
        final float[] v = accumulator.getVertices();
        final int stride = accumulator.getStride();
        final int size = accumulator.getSize();
        final int[] indexList = new int[size];
        this.getIndexArray(ids, false, indexList);
        this.colorBuffer.mutate(new GLFloatBuffer.Mutator(){

            @Override
            public void mutate(FloatBuffer data, int length) {
                for (int i = 0; i < size; ++i) {
                    data.position(indexList[i] * length);
                    data.put(v, i * stride, length);
                }
            }
        });
    }

    protected int getIndex(Object id, boolean grow) {
        Integer index = this.idMap.get(id);
        if (index == null) {
            if (grow) {
                index = this.idMap.size();
                this.idMap.put(id, index);
                this.indexMap.put(index, id);
            } else {
                throw new IllegalArgumentException(String.format("Id %s does not exist.", id));
            }
        }
        return index;
    }

    protected void growBuffers(int minSize) {
        this.bufferSize = Math.max((int)((double)this.bufferSize * 1.3), minSize);
        this.pointBuffer.ensureCapacity(this.bufferSize);
        this.colorBuffer.ensureCapacity(this.bufferSize);
    }

    public static class BulkPointAccumulator {
        List<Object> ids = new ArrayList<Object>();
        FloatsArray v = new FloatsArray();

        public void add(Object id, float x, float y, float[] color) {
            if (color.length != 3 && color.length != 4) {
                throw new IllegalArgumentException("Color array must be size 3 or 4");
            }
            if (this.v.n == this.v.a.length) {
                this.v.ensureCapacity((int)Math.max((double)(this.v.n + this.getStride()), (double)this.v.n * 1.3));
            }
            this.ids.add(id);
            this.v.append(x);
            this.v.append(y);
            this.v.append(color);
            if (color.length == 3) {
                this.v.append(1.0f);
            }
        }

        public void add(Object id, float x, float y) {
            this.add(id, x, y, DEFAULT_COLOR);
        }

        int getStride() {
            return 6;
        }

        List<Object> getIds() {
            return this.ids;
        }

        float[] getVertices() {
            return this.v.a;
        }

        int getSize() {
            return this.ids.size();
        }
    }

    public static class BulkColorAccumulator {
        List<Object> ids = new ArrayList<Object>();
        FloatsArray v = new FloatsArray();

        public void add(Object id, float[] color) {
            if (color.length != 3 && color.length != 4) {
                throw new IllegalArgumentException("Color array must be size 3 or 4");
            }
            if (this.v.n == this.v.a.length) {
                this.v.ensureCapacity((int)Math.max((double)(this.v.n + this.getStride()), (double)this.v.n * 1.3));
            }
            this.ids.add(id);
            this.v.append(color);
            if (color.length == 3) {
                this.v.append(1.0f);
            }
        }

        int getStride() {
            return 4;
        }

        List<Object> getIds() {
            return this.ids;
        }

        float[] getVertices() {
            return this.v.a;
        }

        int getSize() {
            return this.ids.size();
        }
    }
}

