/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.plot;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.sun.opengl.util.BufferUtil;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import it.unimi.dsi.fastutil.floats.Float2IntOpenHashMap;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class StackedHistogramPainter
extends GlimpseDataPainter2D {
    public static final int FLOATS_PER_BAR = 8;
    protected float[] defaultSeriesColor = new float[]{1.0f, 0.0f, 0.0f, 0.6f};
    protected int[] bufferHandle = null;
    protected FloatBuffer dataBuffer = null;
    protected List<HistogramEntry> dataSeries = null;
    protected ReentrantLock dataBufferLock = new ReentrantLock();
    protected volatile boolean newData = false;
    protected volatile boolean bufferInitialized = false;
    protected float binSize;
    protected float binStart;
    protected float minY;
    protected float maxY;
    protected float minX;
    protected float maxX;

    public void setDefaultSeriesColor(float[] rgba) {
        if (rgba == null) {
            throw new NullPointerException("rgba cannot be null");
        }
        this.defaultSeriesColor = rgba;
    }

    public void setSeriesColor(int series, float[] rgba) {
        if (rgba == null) {
            throw new NullPointerException("rgba cannot be null");
        }
        this.dataSeries.get((int)series).color = rgba;
    }

    public void autoAdjustAxisBounds(Axis2D axis) {
        axis.getAxisX().setMin(this.minX);
        axis.getAxisX().setMax(this.maxX);
        axis.getAxisY().setMin(this.minY);
        axis.getAxisY().setMax(this.maxY);
    }

    public void setData(float[] ... data) {
        int size = 0;
        for (int i = 0; i < data.length; ++i) {
            size = Math.max(size, data[i].length);
        }
        this.setData(size, data);
    }

    public void setData(int totalNumValues, float[] ... data) {
        if (data == null || data.length == 0) {
            return;
        }
        float min = Float.MAX_VALUE;
        float max = -3.4028235E38f;
        for (int i = 0; i < data.length; ++i) {
            for (int j = 0; j < data[i].length; ++j) {
                float value = data[i][j];
                if (value > max) {
                    max = value;
                }
                if (!(value < min)) continue;
                min = value;
            }
        }
        float binSize = (max - min) / (float)Math.sqrt(totalNumValues);
        this.setData(totalNumValues, binSize, min, data);
    }

    public void setData(int totalNumValues, float binSize, float binStart, float[] ... data) {
        this.binStart = binStart;
        Float2IntMap[] counts = new Float2IntMap[data.length];
        for (int i = 0; i < data.length; ++i) {
            counts[i] = new Float2IntOpenHashMap(data[i].length);
            for (int j = 0; j < data[i].length; ++j) {
                float value = data[i][j];
                float bin = StackedHistogramPainter.getBin(value, binSize, binStart);
                if (!counts[i].containsKey(bin)) {
                    counts[i].put(bin, 1);
                    continue;
                }
                counts[i].put(bin, counts[i].get(bin) + 1);
            }
        }
        this.setData(totalNumValues, binSize, counts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setData(int totalNumValues, float binSize, Float2IntMap ... counts) {
        this.binSize = binSize;
        this.dataBufferLock.lock();
        try {
            this.minY = 0.0f;
            this.maxY = 0.0f;
            this.minX = Float.POSITIVE_INFINITY;
            this.maxX = Float.NEGATIVE_INFINITY;
            int numQuads = 0;
            int numBars = 0;
            for (Float2IntMap countMap : counts) {
                numQuads += countMap.size();
                numBars = Math.max(numBars, countMap.size());
            }
            if (this.dataBuffer == null || this.dataBuffer.rewind().capacity() < numQuads * 8) {
                this.dataBuffer = BufferUtil.newFloatBuffer((int)(numQuads * 8));
            }
            Float2FloatOpenHashMap lastBarHeights = new Float2FloatOpenHashMap(numBars);
            lastBarHeights.defaultReturnValue(0.0f);
            this.dataSeries = new ArrayList<HistogramEntry>();
            for (Float2IntMap countMap : counts) {
                int quadFloatsStart = this.dataBuffer.position();
                for (Float2IntMap.Entry entry : countMap.float2IntEntrySet()) {
                    float bin = entry.getFloatKey();
                    int count = entry.getIntValue();
                    float height = this.getBarHeight(bin, count, totalNumValues);
                    float lastHeight = lastBarHeights.get(bin);
                    float top = lastHeight + height;
                    this.maxY = Math.max(top, this.maxY);
                    this.minX = Math.min(bin, this.minX);
                    this.maxX = Math.max(bin, this.maxX);
                    this.dataBuffer.put(bin).put(lastHeight);
                    this.dataBuffer.put(bin).put(top);
                    this.dataBuffer.put(bin + this.binSize).put(top);
                    this.dataBuffer.put(bin + this.binSize).put(lastHeight);
                    lastBarHeights.put(bin, top);
                }
                int numQuadsForSeries = (this.dataBuffer.position() - quadFloatsStart) / 8;
                this.dataSeries.add(new HistogramEntry(this.defaultSeriesColor, quadFloatsStart / 2, numQuadsForSeries));
            }
            this.newData = true;
        }
        finally {
            this.dataBufferLock.unlock();
        }
    }

    protected float getBarHeight(float bin, int count, int totalValues) {
        return count;
    }

    public float getBinSize() {
        return this.binSize;
    }

    public float getBinStart() {
        return this.binStart;
    }

    public float getMinY() {
        return this.minY;
    }

    public float getMaxY() {
        return this.maxY;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMaxX() {
        return this.maxX;
    }

    protected static float getBin(double data, double binSize, double binStart) {
        return (float)(Math.floor((data - binStart) / binSize) * binSize + binStart);
    }

    @Override
    public void dispose(GLContext context) {
        if (this.bufferInitialized) {
            context.getGL().glDeleteBuffers(1, this.bufferHandle, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        if (this.dataSeries == null || this.dataSeries.isEmpty()) {
            return;
        }
        if (!this.bufferInitialized) {
            this.bufferHandle = new int[1];
            gl.glGenBuffers(1, this.bufferHandle, 0);
            this.bufferInitialized = true;
        }
        gl.glBindBuffer(34962, this.bufferHandle[0]);
        if (this.newData) {
            this.dataBufferLock.lock();
            try {
                gl.glBufferData(34962, this.dataBuffer.position() * 4, this.dataBuffer.rewind(), 35044);
                this.glHandleError(gl);
                this.newData = false;
            }
            finally {
                this.dataBufferLock.unlock();
            }
        }
        gl.glBindBuffer(34962, this.bufferHandle[0]);
        gl.glVertexPointer(2, 5126, 0, 0L);
        gl.glEnableClientState(32884);
        for (HistogramEntry entry : this.dataSeries) {
            gl.glColor4fv(entry.color, 0);
            gl.glDrawArrays(7, entry.quadsFloatStart, entry.numQuads * 4);
        }
    }

    protected static class HistogramEntry {
        public float[] color;
        public final int quadsFloatStart;
        public final int numQuads;

        public HistogramEntry(float[] color, int quadsFloatStart, int numQuads) {
            this.color = color;
            this.quadsFloatStart = quadsFloatStart;
            this.numQuads = numQuads;
        }
    }
}

