/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.info;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.painter.info.SimpleTextPainter;
import com.metsci.glimpse.support.atlas.TextureAtlas;
import com.metsci.glimpse.support.atlas.support.ImageData;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.SimpleTextLayout;
import com.metsci.glimpse.support.font.SimpleTextLayoutCenter;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.text.BreakIterator;
import java.util.List;
import javax.media.opengl.GL;

public class TooltipPainter
extends SimpleTextPainter {
    protected boolean isFixedWidth = false;
    protected int fixedWidth = 50;
    protected int borderSize = 4;
    protected float lineSpacing = 2.0f;
    protected boolean breakOnEol = true;
    protected int offsetX = 14;
    protected int offsetY = -10;
    protected boolean clampToScreenEdges = true;
    protected SimpleTextLayout textLayout;
    protected BreakIterator breakIterator = BreakIterator.getWordInstance();
    protected List<SimpleTextLayout.TextBoundingBox> lines;
    protected Bounds linesBounds;
    protected TextureAtlas atlas;
    protected Object iconId;
    protected ImageData icon;
    protected boolean wrapTextAroundIcon = false;
    protected int x;
    protected int y;

    public TooltipPainter(TextureAtlas atlas) {
        this.paintBackground = true;
        this.paintBorder = true;
        this.atlas = atlas;
    }

    public TooltipPainter() {
        this(null);
    }

    public TooltipPainter setIcon(Object iconId) {
        this.iconId = iconId;
        this.icon = iconId != null ? this.atlas.getImageData(iconId) : null;
        this.lines = null;
        return this;
    }

    public TooltipPainter setWrapTextAroundIcon(boolean wrap) {
        this.wrapTextAroundIcon = wrap;
        this.lines = null;
        return this;
    }

    public TooltipPainter setLocation(int x, int y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public TooltipPainter setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        return this;
    }

    public TooltipPainter setLocation(GlimpseMouseEvent e) {
        return this.setLocation(e.getScreenPixelsX(), e.getScreenPixelsY());
    }

    public TooltipPainter setBorderSize(int size) {
        this.borderSize = size;
        this.lines = null;
        return this;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public TooltipPainter setFixedWidth(int fixedWidth) {
        this.fixedWidth = fixedWidth;
        this.isFixedWidth = true;
        this.lines = null;
        return this;
    }

    public TooltipPainter setUnlimitedWidth() {
        this.isFixedWidth = false;
        this.lines = null;
        return this;
    }

    public void setClampToScreenEdges(boolean clamp) {
        this.clampToScreenEdges = clamp;
    }

    public int getFixedWidth() {
        return this.fixedWidth;
    }

    public boolean isFixedWidth() {
        return this.isFixedWidth;
    }

    public TooltipPainter setBreakOnEol(boolean breakOnEol) {
        this.breakOnEol = breakOnEol;
        this.textLayout = null;
        return this;
    }

    public boolean getBreakOnEol() {
        return this.breakOnEol;
    }

    public TooltipPainter setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
        this.textLayout = null;
        return this;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public TooltipPainter setBreakIterator(BreakIterator breakIterator) {
        this.breakIterator = breakIterator;
        this.textLayout = null;
        return this;
    }

    @Override
    public TooltipPainter setText(String text) {
        this.text = text;
        this.lines = null;
        return this;
    }

    protected void updateTextLayout() {
        Font font = this.textRenderer.getFont();
        FontRenderContext frc = this.textRenderer.getFontRenderContext();
        this.textLayout = new SimpleTextLayoutCenter(font, frc, this.breakIterator);
        this.textLayout.setBreakOnEol(this.breakOnEol);
        this.textLayout.setLineSpacing(this.lineSpacing);
    }

    protected float getIconSize() {
        return (float)this.textLayout.getAscent();
    }

    protected float getIconSpacing(int i) {
        return (float)(this.iconId != null && (!this.wrapTextAroundIcon || i == 0) ? this.textLayout.getAscent() + (double)this.borderSize : 0.0);
    }

    protected void updateLayout() {
        this.textLayout.doLayout(this.text, 0.0f, 0.0f, this.isFixedWidth ? (float)this.fixedWidth : Float.MAX_VALUE);
        this.lines = this.textLayout.getLines();
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        if (!this.lines.isEmpty()) {
            for (int i = 0; i < this.lines.size(); ++i) {
                SimpleTextLayout.TextBoundingBox line = this.lines.get(i);
                float iconSize = this.getIconSpacing(i);
                minX = Math.min(minX, line.getMinX());
                minY = Math.min(minY, line.getMinY());
                maxX = Math.max(maxX, line.getMaxX() + iconSize);
                maxY = Math.max(maxY, line.getMaxY());
            }
        }
        double overallMinX = minX - (float)this.borderSize;
        double overallMaxX = maxX + (float)this.borderSize;
        double overallMinY = (double)minY - this.textLayout.getDescent() * 0.5 - (double)this.borderSize;
        double overallMaxY = maxY + (float)this.borderSize;
        this.linesBounds = new Bounds(overallMinX, overallMaxX, overallMinY, overallMaxY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintTo(GlimpseContext context, GlimpseBounds bounds) {
        if (this.newFont != null) {
            this.updateTextRenderer();
        }
        if (this.textLayout == null && this.textRenderer != null) {
            this.updateTextLayout();
        }
        if (this.lines == null && this.textLayout != null && this.text != null) {
            this.updateLayout();
        }
        if (this.textRenderer == null || this.lines == null) {
            return;
        }
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        double clampX = 0.0;
        double clampY = 0.0;
        if (this.clampToScreenEdges) {
            double minY;
            double maxY;
            double minX;
            double maxX = (double)this.x + this.linesBounds.maxX + (double)this.offsetX;
            if (maxX > (double)width) {
                clampX = (double)width - maxX;
            }
            if ((minX = (double)this.x + this.linesBounds.minX + (double)this.offsetX) < 0.0) {
                clampX = -minX;
            }
            if ((maxY = (double)(height - this.y) + this.linesBounds.maxY + (double)this.offsetY) > (double)height) {
                clampY = (double)height - maxY;
            }
            if ((minY = (double)(height - this.y) + this.linesBounds.minY + (double)this.offsetY) < 0.0) {
                clampY = -minY;
            }
        }
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(-0.5, (double)(width - 1) + 0.5, -0.5, (double)(height - 1) + 0.5, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        if (this.paintBackground || this.paintBorder) {
            if (this.paintBackground) {
                gl.glColor4fv(this.backgroundColor, 0);
                gl.glBegin(7);
                try {
                    this.borderVertices(gl, height, clampX + (double)this.offsetX, clampY + (double)this.offsetY);
                }
                finally {
                    gl.glEnd();
                }
            }
            if (this.paintBorder) {
                gl.glColor4fv(this.borderColor, 0);
                gl.glEnable(2848);
                gl.glBegin(2);
                try {
                    this.borderVertices(gl, height, clampX + (double)this.offsetX, clampY + (double)this.offsetY);
                }
                finally {
                    gl.glEnd();
                }
            }
        }
        gl.glDisable(3042);
        GlimpseColor.setColor(this.textRenderer, this.textColor);
        this.textRenderer.beginRendering(width, height);
        try {
            for (int i = 0; i < this.lines.size(); ++i) {
                SimpleTextLayout.TextBoundingBox line = this.lines.get(i);
                float iconSize = this.getIconSpacing(i);
                int posX = (int)((double)((float)this.x + line.leftX + iconSize) + clampX + (double)this.offsetX);
                int posY = (int)((double)((float)(height - this.y) + line.getMinY()) + clampY + (double)this.offsetY);
                this.textRenderer.draw(line.text, posX, posY);
            }
        }
        finally {
            this.textRenderer.endRendering();
        }
        if (!this.lines.isEmpty() && this.iconId != null) {
            SimpleTextLayout.TextBoundingBox line = this.lines.get(0);
            float iconSize = this.getIconSize();
            this.atlas.beginRendering();
            try {
                ImageData iconData = this.atlas.getImageData(this.iconId);
                double iconScale = (double)iconSize / (double)iconData.getWidth();
                int posX = (int)((double)((float)this.x + line.leftX) + clampX + (double)this.offsetX);
                int posY = (int)((double)((float)(height - this.y) + line.getMinY()) + clampY + (double)this.offsetY - this.textLayout.getDescent() * 0.25);
                this.atlas.drawImage(gl, this.iconId, posX, posY, iconScale, iconScale, 0, iconData.getHeight());
            }
            finally {
                this.atlas.endRendering();
            }
        }
    }

    protected void borderVertices(GL gl, int height, double offsetX, double offsetY) {
        double posX = (double)this.x + this.linesBounds.minX + offsetX;
        double posY = (double)(height - this.y) + this.linesBounds.minY + offsetY;
        gl.glVertex2d(posX, posY);
        posX = (double)this.x + this.linesBounds.maxX + offsetX;
        posY = (double)(height - this.y) + this.linesBounds.minY + offsetY;
        gl.glVertex2d(posX, posY);
        posX = (double)this.x + this.linesBounds.maxX + offsetX;
        posY = (double)(height - this.y) + this.linesBounds.maxY + offsetY;
        gl.glVertex2d(posX, posY);
        posX = (double)this.x + this.linesBounds.minX + offsetX;
        posY = (double)(height - this.y) + this.linesBounds.maxY + offsetY;
        gl.glVertex2d(posX, posY);
    }

    protected static class Bounds {
        public double minX;
        public double maxX;
        public double minY;
        public double maxY;

        public Bounds(double minX, double maxX, double minY, double maxY) {
            this.minX = minX;
            this.maxX = maxX;
            this.minY = minY;
            this.maxY = maxY;
        }

        public String toString() {
            return String.format("%f %f %f %f", this.minX, this.maxX, this.minY, this.maxY);
        }
    }
}

