/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.info;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainterImpl;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.support.settings.AbstractLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;

public class SimpleTextPainter
extends GlimpsePainterImpl {
    protected float[] textColor = GlimpseColor.getWhite();
    protected float[] textColorNoBackground = GlimpseColor.getBlack();
    protected boolean textColorSet = false;
    protected boolean paintBackground = false;
    protected float[] backgroundColor = GlimpseColor.getBlack(0.7f);
    protected boolean backgroundColorSet = false;
    protected boolean paintBorder = false;
    protected float[] borderColor = GlimpseColor.getWhite(1.0f);
    protected boolean borderColorSet = false;
    protected int horizontalPadding = 5;
    protected int verticalPadding = 5;
    protected HorizontalPosition hPos;
    protected VerticalPosition vPos;
    protected TextRenderer textRenderer;
    protected boolean fontSet = false;
    protected String sizeText;
    protected String text;
    protected boolean horizontal = true;
    protected volatile Font newFont = FontUtils.getDefaultBold(12.0f);
    protected volatile boolean antialias = false;

    public SimpleTextPainter() {
        this.hPos = HorizontalPosition.Left;
        this.vPos = VerticalPosition.Bottom;
    }

    public SimpleTextPainter setHorizontalLabels(boolean horizontal) {
        this.horizontal = horizontal;
        return this;
    }

    public SimpleTextPainter setPaintBackground(boolean paintBackground) {
        this.paintBackground = paintBackground;
        return this;
    }

    public SimpleTextPainter setBackgroundColor(float[] backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.backgroundColorSet = true;
        return this;
    }

    public SimpleTextPainter setPaintBorder(boolean paintBorder) {
        this.paintBorder = paintBorder;
        return this;
    }

    public SimpleTextPainter setBorderColor(float[] borderColor) {
        this.borderColor = borderColor;
        this.borderColorSet = true;
        return this;
    }

    public SimpleTextPainter setHorizontalPosition(HorizontalPosition hPos) {
        this.hPos = hPos;
        return this;
    }

    public SimpleTextPainter setVerticalPosition(VerticalPosition vPos) {
        this.vPos = vPos;
        return this;
    }

    public SimpleTextPainter setFont(Font font) {
        this.setFont(font, false);
        return this;
    }

    public SimpleTextPainter setFont(Font font, boolean antialias) {
        this.newFont = font;
        this.antialias = antialias;
        this.fontSet = true;
        return this;
    }

    public SimpleTextPainter setFont(int size, boolean bold) {
        this.setFont(size, bold, false);
        return this;
    }

    public SimpleTextPainter setFont(int size, boolean bold, boolean antialias) {
        if (bold) {
            this.setFont(FontUtils.getDefaultBold(size), antialias);
        } else {
            this.setFont(FontUtils.getDefaultPlain(size), antialias);
        }
        return this;
    }

    public SimpleTextPainter setSizeText(String sizeText) {
        this.sizeText = sizeText;
        return this;
    }

    public SimpleTextPainter setText(String text) {
        this.text = text;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public SimpleTextPainter setPadding(int padding) {
        this.verticalPadding = padding;
        this.horizontalPadding = padding;
        return this;
    }

    public SimpleTextPainter setVerticalPadding(int padding) {
        this.verticalPadding = padding;
        return this;
    }

    public SimpleTextPainter setHorizontalPadding(int padding) {
        this.horizontalPadding = padding;
        return this;
    }

    public SimpleTextPainter setColor(float[] rgba) {
        this.textColor = rgba;
        this.textColorSet = true;
        return this;
    }

    public SimpleTextPainter setColor(float r, float g, float b, float a) {
        this.textColor[0] = r;
        this.textColor[1] = g;
        this.textColor[2] = b;
        this.textColor[3] = a;
        return this;
    }

    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    public int getHorizontalPadding() {
        return this.horizontalPadding;
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        if (!this.fontSet) {
            this.setFont(laf.getFont(AbstractLookAndFeel.TITLE_FONT), false);
            this.fontSet = false;
        }
        if (!this.textColorSet) {
            this.textColor = laf.getColor(AbstractLookAndFeel.TOOLTIP_TEXT_COLOR);
            this.textColorNoBackground = laf.getColor(AbstractLookAndFeel.AXIS_TEXT_COLOR);
            this.textColorSet = false;
        }
        if (!this.backgroundColorSet) {
            this.setBackgroundColor(laf.getColor(AbstractLookAndFeel.TOOLTIP_BACKGROUND_COLOR));
            this.backgroundColorSet = false;
        }
        if (!this.borderColorSet) {
            this.setBorderColor(laf.getColor(AbstractLookAndFeel.BORDER_COLOR));
            this.borderColorSet = false;
        }
    }

    @Override
    public void dispose(GlimpseContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }

    public Rectangle2D getTextBounds() {
        return this.sizeText == null ? this.textRenderer.getBounds(this.text) : this.textRenderer.getBounds(this.sizeText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintToHorizontal(GL gl, int width, int height, Rectangle2D textBounds) {
        int xText = this.horizontalPadding;
        int yText = this.verticalPadding;
        switch (this.hPos) {
            case Left: {
                xText = this.horizontalPadding;
                break;
            }
            case Center: {
                xText = (int)((double)width / 2.0 - textBounds.getWidth() * 0.3);
                break;
            }
            case Right: {
                xText = (int)((double)width - textBounds.getWidth() - (double)this.horizontalPadding);
            }
        }
        switch (this.vPos) {
            case Bottom: {
                yText = this.verticalPadding;
                break;
            }
            case Center: {
                yText = (int)((double)height / 2.0 - textBounds.getHeight() * 0.3);
                break;
            }
            case Top: {
                yText = (int)((double)height - textBounds.getHeight() - (double)this.verticalPadding);
            }
        }
        if (this.paintBackground || this.paintBorder) {
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glOrtho(-0.5, (double)(width - 1) + 0.5, -0.5, (double)(height - 1) + 0.5, -1.0, 1.0);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            gl.glBlendFunc(770, 771);
            gl.glEnable(3042);
            Rectangle2D bound = this.sizeText == null ? this.textRenderer.getBounds(this.text) : this.textRenderer.getBounds(this.sizeText);
            int xTextMax = (int)((double)xText + bound.getWidth() + bound.getMinX() - 1.0);
            int yTextMax = (int)((double)yText + bound.getHeight() - 3.0);
            if (this.paintBackground) {
                gl.glColor4fv(this.backgroundColor, 0);
                gl.glBegin(7);
                try {
                    gl.glVertex2f((float)xText - 0.5f - 2.0f, (float)yText - 0.5f - 2.0f);
                    gl.glVertex2f((float)xTextMax + 0.5f + 2.0f, (float)yText - 0.5f - 2.0f);
                    gl.glVertex2f((float)xTextMax + 0.5f + 2.0f, (float)yTextMax + 0.5f + 2.0f);
                    gl.glVertex2f((float)xText - 0.5f - 2.0f, (float)yTextMax + 0.5f + 2.0f);
                }
                finally {
                    gl.glEnd();
                }
            }
            if (this.paintBorder) {
                gl.glColor4fv(this.borderColor, 0);
                gl.glEnable(2848);
                gl.glBegin(3);
                try {
                    gl.glVertex2f((float)xText - 0.5f - 2.0f, (float)yText - 0.5f - 2.0f);
                    gl.glVertex2f((float)xTextMax + 0.5f + 2.0f, (float)yText - 0.5f - 2.0f);
                    gl.glVertex2f((float)xTextMax + 0.5f + 2.0f, (float)yTextMax + 0.5f + 2.0f);
                    gl.glVertex2f((float)xText - 0.5f - 2.0f, (float)yTextMax + 0.5f + 2.0f);
                    gl.glVertex2f((float)xText - 0.5f - 2.0f, (float)yText - 0.5f - 2.0f);
                }
                finally {
                    gl.glEnd();
                }
            }
        }
        gl.glDisable(3042);
        this.textRenderer.beginRendering(width, height);
        try {
            if (!this.textColorSet && !this.paintBackground) {
                GlimpseColor.setColor(this.textRenderer, this.textColorNoBackground);
            } else {
                GlimpseColor.setColor(this.textRenderer, this.textColor);
            }
            this.textRenderer.draw(this.text, xText, yText);
        }
        finally {
            this.textRenderer.endRendering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintToVertical(GL gl, int width, int height, Rectangle2D textBounds) {
        int xText = this.horizontalPadding;
        int yText = this.verticalPadding;
        double textWidth = textBounds.getWidth();
        double textHeight = textBounds.getHeight();
        int halfTextWidth = (int)(textWidth / 2.0);
        int halfTextHeight = (int)(textHeight / 2.0);
        switch (this.hPos) {
            case Left: {
                xText = this.horizontalPadding - halfTextWidth + halfTextHeight;
                break;
            }
            case Center: {
                xText = (int)((double)width / 2.0 - (double)halfTextWidth);
                break;
            }
            case Right: {
                xText = width - halfTextWidth - halfTextHeight - this.horizontalPadding;
            }
        }
        switch (this.vPos) {
            case Bottom: {
                yText = this.verticalPadding - halfTextHeight + halfTextWidth;
                break;
            }
            case Center: {
                yText = (int)((double)height / 2.0 - (double)halfTextHeight);
                break;
            }
            case Top: {
                yText = height - halfTextHeight - halfTextWidth - this.verticalPadding;
            }
        }
        if (this.paintBackground || this.paintBorder) {
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
            gl.glMatrixMode(5888);
            gl.glLoadIdentity();
            gl.glBlendFunc(770, 771);
            gl.glEnable(3042);
            int buffer = 2;
            int xTextMin = xText + halfTextWidth - halfTextHeight - buffer;
            int yTextMin = yText + halfTextWidth + halfTextHeight + buffer;
            int xTextMax = xText + halfTextWidth + halfTextHeight + buffer + 3;
            int yTextMax = yText - halfTextWidth + halfTextHeight - buffer;
            if (this.paintBackground) {
                gl.glColor4fv(this.backgroundColor, 0);
                gl.glBegin(7);
                try {
                    gl.glVertex2f((float)xTextMin, (float)yTextMin);
                    gl.glVertex2f((float)xTextMax, (float)yTextMin);
                    gl.glVertex2f((float)xTextMax, (float)yTextMax);
                    gl.glVertex2f((float)xTextMin, (float)yTextMax);
                }
                finally {
                    gl.glEnd();
                }
            }
            if (this.paintBorder) {
                gl.glColor4fv(this.borderColor, 0);
                gl.glEnable(2848);
                gl.glBegin(3);
                try {
                    gl.glVertex2f((float)xTextMin, (float)yTextMin);
                    gl.glVertex2f((float)xTextMax, (float)yTextMin);
                    gl.glVertex2f((float)xTextMax, (float)yTextMax);
                    gl.glVertex2f((float)xTextMin, (float)yTextMax);
                    gl.glVertex2f((float)xTextMin, (float)yTextMin);
                }
                finally {
                    gl.glEnd();
                }
            }
        }
        gl.glDisable(3042);
        this.textRenderer.beginRendering(width, height);
        try {
            double xShift = xText + halfTextWidth;
            double yShift = yText + halfTextHeight;
            gl.glMatrixMode(5889);
            gl.glTranslated(xShift, yShift, 0.0);
            gl.glRotated(90.0, 0.0, 0.0, 1.0);
            gl.glTranslated(-xShift, -yShift, 0.0);
            GlimpseColor.setColor(this.textRenderer, this.textColor);
            this.textRenderer.draw(this.text, xText, yText);
        }
        finally {
            this.textRenderer.endRendering();
        }
    }

    @Override
    protected void paintTo(GlimpseContext context, GlimpseBounds bounds) {
        Rectangle2D textBounds;
        if (this.newFont != null) {
            this.updateTextRenderer();
        }
        if (this.text == null || this.textRenderer == null) {
            return;
        }
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        Rectangle2D rectangle2D = textBounds = this.sizeText == null ? this.textRenderer.getBounds(this.text) : this.textRenderer.getBounds(this.sizeText);
        if (this.horizontal) {
            this.paintToHorizontal(gl, width, height, textBounds);
        } else {
            this.paintToVertical(gl, width, height, textBounds);
        }
    }

    protected void updateTextRenderer() {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = new TextRenderer(this.newFont, this.antialias, false);
        this.newFont = null;
    }

    public static enum VerticalPosition {
        Bottom,
        Center,
        Top;

    }

    public static enum HorizontalPosition {
        Left,
        Center,
        Right;

    }
}

