/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.info;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.factory.DefaultAxisFactory2D;
import com.metsci.glimpse.axis.factory.FixedAxisFactory2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.context.TargetStackUtil;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.GlimpseMouseListener;
import com.metsci.glimpse.event.mouse.GlimpseMouseMotionListener;
import com.metsci.glimpse.event.mouse.MouseButton;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import com.metsci.glimpse.painter.decoration.BorderPainter;
import com.metsci.glimpse.plot.Plot2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import javax.media.opengl.GL;

public class MinimapLayout
extends GlimpseAxisLayout2D {
    protected GlimpseAxisLayout2D delegateLayer;

    public MinimapLayout() {
        Axis2D minimapAxis = new Axis2D();
        this.setAxis(minimapAxis);
        this.delegateLayer = new GlimpseAxisLayout2D();
        this.delegateLayer.setAxisFactory(new DefaultAxisFactory2D());
        this.delegateLayer.setEventConsumer(false);
        this.delegateLayer.setEventGenerator(true);
        this.addLayout(this.delegateLayer);
        this.delegateLayer.addPainter((GlimpsePainter)new MiniMapBoundsPainter(), Plot2D.FOREGROUND_LAYER);
        this.delegateLayer.addPainter((GlimpsePainter)new BorderPainter(), Plot2D.FOREGROUND_LAYER);
        this.addGlimpseMouseMotionListener(new GlimpseMouseMotionListener(){

            @Override
            public void mouseMoved(GlimpseMouseEvent event) {
                if (event.isButtonDown(MouseButton.Button1)) {
                    MinimapLayout.this.recenterMiniMap0(event);
                }
            }
        });
        this.addGlimpseMouseListener(new GlimpseMouseListener(){

            @Override
            public void mousePressed(GlimpseMouseEvent event) {
                MinimapLayout.this.recenterMiniMap0(event);
            }

            @Override
            public void mouseEntered(GlimpseMouseEvent event) {
            }

            @Override
            public void mouseExited(GlimpseMouseEvent event) {
            }

            @Override
            public void mouseReleased(GlimpseMouseEvent event) {
            }
        });
    }

    @Override
    public void addPainter(GlimpsePainter painter) {
        this.delegateLayer.addPainter(painter);
    }

    @Override
    public void removePainter(GlimpsePainter painter) {
        this.delegateLayer.removePainter(painter);
    }

    public void setPosition(int xOffset, int yOffset, int width, int height) {
        String y2;
        String y;
        String x2;
        String x;
        if (xOffset >= 0) {
            x = String.format("%d", xOffset);
            x2 = String.format("%d", xOffset + width);
        } else {
            x = String.format("(container.w-%d)", -xOffset - 1 + width);
            x2 = String.format("(container.w-%d)", -xOffset - 1);
        }
        if (yOffset >= 0) {
            y = String.format("%d", yOffset);
            y2 = String.format("%d", yOffset + height);
        } else {
            y = String.format("(container.h-%d)", -yOffset - 1 + height);
            y2 = String.format("(container.h-%d)", -yOffset - 1);
        }
        this.setLayoutData(String.format("pos %s %s %s %s", x, y, x2, y2));
    }

    public void setBounds(double minX, double maxX, double minY, double maxY) {
        this.setAxis(this.axis, minX, maxX, minY, maxY);
        this.setAxisFactory(new FixedAxisFactory2D(minX, maxX, minY, maxY));
        this.axis.getAxisX().validate();
        this.axis.getAxisY().validate();
    }

    protected void setAxis(Axis2D axis, double minX, double maxX, double minY, double maxY) {
        axis.getAxisX().setMin(minX);
        axis.getAxisX().setMax(maxX);
        axis.getAxisY().setMin(minY);
        axis.getAxisY().setMax(maxY);
        axis.getAxisX().lockMin(minX);
        axis.getAxisX().lockMax(maxX);
        axis.getAxisY().lockMin(minY);
        axis.getAxisY().lockMax(maxY);
    }

    protected Axis2D getMiniMapAxis0(GlimpseContext context) {
        return this.getAxis0(context.getTargetStack());
    }

    protected Axis2D getMiniMapAxis0(GlimpseTargetStack stack) {
        return this.getAxis0(stack);
    }

    protected Axis2D getMainMapAxis0(GlimpseContext context) {
        return this.getAxis0(this.getMainMapTargetStack(context.getTargetStack()));
    }

    protected Axis2D getMainMapAxis0(GlimpseTargetStack stack) {
        return this.getAxis0(this.getMainMapTargetStack(stack));
    }

    protected GlimpseTargetStack getMainMapTargetStack(GlimpseTargetStack stack) {
        return TargetStackUtil.newTargetStack(stack).pop().pop();
    }

    protected Axis2D getAxis0(GlimpseTargetStack stack) {
        GlimpseTarget target = stack.getTarget();
        Axis2D axis = null;
        if (target instanceof GlimpseAxisLayout2D) {
            axis = ((GlimpseAxisLayout2D)target).getAxis(stack);
        }
        return axis;
    }

    protected void recenterMiniMap0(GlimpseMouseEvent event) {
        Axis2D miniMapAxis = this.getMiniMapAxis0(event.getTargetStack());
        Axis2D mainMapAxis = this.getMainMapAxis0(event.getTargetStack());
        double x = miniMapAxis.getAxisX().screenPixelToValue(event.getX());
        double y = miniMapAxis.getAxisY().screenPixelToValue(miniMapAxis.getAxisY().getSizePixels() - event.getY());
        double width = mainMapAxis.getMaxX() - mainMapAxis.getMinX();
        double height = mainMapAxis.getMaxY() - mainMapAxis.getMinY();
        mainMapAxis.getAxisX().setMin(x - width / 2.0);
        mainMapAxis.getAxisX().setMax(x + width / 2.0);
        mainMapAxis.getAxisX().validate();
        mainMapAxis.getAxisY().setMin(y - height / 2.0);
        mainMapAxis.getAxisY().setMax(y + height / 2.0);
        mainMapAxis.getAxisY().validate();
    }

    public class MiniMapBoundsPainter
    extends GlimpsePainter2D {
        protected float[] cursorColor = GlimpseColor.getBlack();
        protected float[] shadeColor = new float[]{0.0f, 0.769f, 1.0f, 0.25f};

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
            Axis2D miniMapAxis = MinimapLayout.this.getMiniMapAxis0(context);
            Axis2D mainMapAxis = MinimapLayout.this.getMainMapAxis0(context);
            GL gl = context.getGL();
            gl.glMatrixMode(5889);
            gl.glLoadIdentity();
            gl.glOrtho(miniMapAxis.getMinX(), miniMapAxis.getMaxX(), miniMapAxis.getMinY(), miniMapAxis.getMaxY(), -1.0, 1.0);
            gl.glBlendFunc(770, 771);
            gl.glEnable(3042);
            double minX = mainMapAxis.getMinX();
            double maxX = mainMapAxis.getMaxX();
            double minY = mainMapAxis.getMinY();
            double maxY = mainMapAxis.getMaxY();
            float lineWidth = 1.0f;
            gl.glLineWidth(lineWidth);
            gl.glColor4fv(this.cursorColor, 0);
            gl.glBegin(2);
            try {
                gl.glVertex2d(minX, minY);
                gl.glVertex2d(minX, maxY);
                gl.glVertex2d(maxX, maxY);
                gl.glVertex2d(maxX, minY);
            }
            finally {
                gl.glEnd();
            }
            gl.glColor4fv(this.shadeColor, 0);
            gl.glBegin(7);
            try {
                gl.glVertex2d(minX, minY);
                gl.glVertex2d(minX, maxY);
                gl.glVertex2d(maxX, maxY);
                gl.glVertex2d(maxX, minY);
            }
            finally {
                gl.glEnd();
            }
        }
    }
}

