/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.info;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class MeasurementPainter
extends GlimpseDataPainter2D {
    private static final double RADIANS_PER_VERTEX = 0.05235987755982988;
    private static final double RAD_TO_DEG = 57.29577951308232;
    private static final double ANGLE_WEDGE_RADIUS_FRACTION = 0.8;
    private static final int DIST_TEXT_OFFSET_X = 10;
    private static final int DIST_TEXT_OFFSET_Y = 0;
    private static final int ANGLE_TEXT_OFFSET_X = 20;
    private static final int ANGLE_TEXT_OFFSET_Y = 5;
    protected float[] protractorColor = new float[]{0.0f, 0.769f, 1.0f, 0.6f};
    protected float[] rulerColor = new float[]{0.0f, 0.769f, 1.0f, 1.0f};
    protected float[] textColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected float rulerWidth = 1.5f;
    protected TextRenderer textRenderer = new TextRenderer(FontUtils.getDefaultBold(16.0f));
    protected DecimalFormat angleFormatter;
    protected DecimalFormat distanceFormatter;

    public MeasurementPainter() {
        this("");
    }

    public MeasurementPainter(String units) {
        this(new DecimalFormat(" ##0.0\u00b0"), new DecimalFormat(" ##0 " + units));
    }

    public MeasurementPainter(DecimalFormat angleFormatter, DecimalFormat distanceFormatter) {
        this.angleFormatter = angleFormatter;
        this.distanceFormatter = distanceFormatter;
    }

    public void setRulerWidth(float width) {
        this.rulerWidth = width;
    }

    public void setTextColor(float[] rgba) {
        this.textColor = rgba;
    }

    public void setTextColor(float r, float g, float b, float a) {
        this.textColor[0] = r;
        this.textColor[1] = g;
        this.textColor[2] = b;
        this.textColor[3] = a;
    }

    public void setRulerColor(float[] rgba) {
        this.rulerColor = rgba;
    }

    public void setRulerColor(float r, float g, float b, float a) {
        this.rulerColor[0] = r;
        this.rulerColor[1] = g;
        this.rulerColor[2] = b;
        this.rulerColor[3] = a;
    }

    public void setProtractorColor(float[] rgba) {
        this.protractorColor = rgba;
    }

    public void setProtractorColor(float r, float g, float b, float a) {
        this.protractorColor[0] = r;
        this.protractorColor[1] = g;
        this.protractorColor[2] = b;
        this.protractorColor[3] = a;
    }

    @Override
    public void dispose(GLContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        if (this.textRenderer == null) {
            return;
        }
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        Axis1D axisX = axis.getAxisX();
        Axis1D axisY = axis.getAxisY();
        boolean lockedX = axisX.isSelectionLocked();
        boolean lockedY = axisY.isSelectionLocked();
        if (!lockedX && !lockedY) {
            return;
        }
        double lockX = axisX.getSelectionCenter();
        double lockY = axisY.getSelectionCenter();
        double mouseX = axisX.getMouseValue();
        double mouseY = axisY.getMouseValue();
        double diffX = mouseX - lockX;
        double diffY = mouseY - lockY;
        double distance = Math.sqrt(diffX * diffX + diffY * diffY);
        double angle = Math.atan2(mouseY - lockY, mouseX - lockX);
        int sign = angle < 0.0 ? -1 : 1;
        double step = 0.05235987755982988;
        double radius = distance * 0.8;
        gl.glLineWidth(this.rulerWidth);
        gl.glColor4fv(this.rulerColor, 0);
        gl.glBegin(1);
        try {
            gl.glVertex2d(lockX, lockY);
            gl.glVertex2d(mouseX, mouseY);
        }
        finally {
            gl.glEnd();
        }
        gl.glColor4fv(this.protractorColor, 0);
        gl.glBegin(6);
        try {
            gl.glVertex2d(lockX, lockY);
            for (double a = 0.0; a < angle * (double)sign; a += step) {
                double x = lockX + Math.cos(a * (double)sign) * radius;
                double y = lockY + Math.sin(a * (double)sign) * radius;
                gl.glVertex2d(x, y);
            }
            double x = lockX + Math.cos(angle) * radius;
            double y = lockY + Math.sin(angle) * radius;
            gl.glVertex2d(x, y);
        }
        finally {
            gl.glEnd();
        }
        String angleString = this.angleFormatter.format(angle * 57.29577951308232);
        int anglePosX = axisX.valueToScreenPixel(lockX);
        int anglePosY = axisY.valueToScreenPixel(lockY);
        if (sign > 0) {
            anglePosX += 20;
            anglePosY += 5;
        } else {
            Rectangle2D rec = this.textRenderer.getBounds(angleString);
            anglePosX += 20;
            anglePosY += -((int)rec.getHeight()) - 5;
        }
        this.textRenderer.beginRendering(width, height);
        try {
            GlimpseColor.setColor(this.textRenderer, this.textColor);
            this.textRenderer.draw(angleString, anglePosX, anglePosY);
        }
        finally {
            this.textRenderer.endRendering();
        }
        String distanceString = this.distanceFormatter.format(distance);
        int distancePosX = axisX.valueToScreenPixel(mouseX) + 10;
        int distancePosY = axisY.valueToScreenPixel(mouseY) + 0;
        this.textRenderer.beginRendering(width, height);
        try {
            GlimpseColor.setColor(this.textRenderer, this.textColor);
            this.textRenderer.draw(distanceString, distancePosX, distancePosY);
        }
        finally {
            this.textRenderer.endRendering();
        }
    }
}

