/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.info;

import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import java.awt.geom.Rectangle2D;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class CursorTextPainter
extends GlimpsePainter2D {
    protected TextRenderer textRenderer;
    protected int textSpacerX = 1;
    protected int textSpacerY = 2;
    protected int verticalBarSpacer = 6;
    protected int horizontalBarSpacer = 6;
    protected boolean zTextGap = true;
    protected boolean offsetBySelectionSize = true;
    protected boolean clampToScreenEdges = true;
    protected float[] fontColor = new float[]{0.85f, 0.85f, 0.85f, 1.0f};
    protected float[] textBackgroundColor = new float[]{0.2f, 0.2f, 0.2f, 0.7f};

    public CursorTextPainter(Font font) {
        this.textRenderer = new TextRenderer(font);
    }

    public CursorTextPainter() {
        this(FontUtils.getDefaultPlain(12.0f));
    }

    public void setTextColor(float[] color) {
        this.fontColor = color;
    }

    public void setTextBackgroundColor(float[] color) {
        this.textBackgroundColor = color;
    }

    public void setOffsetBySelectionSize(boolean offset) {
        this.offsetBySelectionSize = offset;
    }

    public void setClampToScreenEdges(boolean clamp) {
        this.clampToScreenEdges = clamp;
    }

    public void setTextGapZ(boolean gap) {
        this.zTextGap = gap;
    }

    protected float getPositionX(Axis2D axis) {
        return (float)axis.getAxisX().getSelectionCenter();
    }

    protected float getPositionY(Axis2D axis) {
        return (float)axis.getAxisY().getSelectionCenter();
    }

    protected Rectangle2D[] getBackgroundBounds(Rectangle2D xTextBounds, Rectangle2D yTextBounds, Rectangle2D zTextBounds) {
        float maxWidth = (float)Math.max(Math.max(xTextBounds.getWidth(), yTextBounds.getWidth()), zTextBounds == null ? 0.0 : zTextBounds.getWidth());
        return new Rectangle2D[]{new Rectangle2D.Float(0.0f, 0.0f, maxWidth + (float)(this.textSpacerX * 2), (float)xTextBounds.getHeight() + (float)(this.textSpacerY * 2)), new Rectangle2D.Float(0.0f, 0.0f, maxWidth + (float)(this.textSpacerX * 2), (float)yTextBounds.getHeight() + (float)(this.textSpacerY * 2)), zTextBounds == null ? null : new Rectangle2D.Float(0.0f, 0.0f, maxWidth + (float)(this.textSpacerX * 2), (float)zTextBounds.getHeight() + (float)(this.textSpacerY * 2))};
    }

    protected float[] getCorners(Axis2D axis, Rectangle2D boundsX, Rectangle2D boundsY, Rectangle2D boundsZ) {
        float[] corners = new float[6];
        int widthPixels = axis.getAxisX().valueToScreenPixel(axis.getMaxX());
        int heightPixels = axis.getAxisY().valueToScreenPixel(axis.getMaxY());
        float centerX = this.getPositionX(axis);
        float centerY = this.getPositionY(axis);
        int centerPixelsX = axis.getAxisX().valueToScreenPixel(centerX);
        int centerPixelsY = axis.getAxisY().valueToScreenPixel(centerY);
        int selectionSizePixelsX = (int)(axis.getAxisX().getSelectionSize() / 2.0 * axis.getAxisX().getPixelsPerValue());
        double x = centerPixelsX + this.horizontalBarSpacer + (this.offsetBySelectionSize ? selectionSizePixelsX : 0);
        double y = (double)(centerPixelsY + this.verticalBarSpacer) + boundsY.getHeight() + (boundsZ == null || this.zTextGap ? 0.0 : boundsZ.getHeight());
        if (this.clampToScreenEdges) {
            x = Math.min(x, (double)widthPixels - boundsX.getWidth());
            x = Math.max(0.0, x);
            y = Math.min(y, (double)heightPixels - boundsX.getHeight());
            if (boundsZ != null) {
                y = Math.max(y, boundsZ.getHeight() + boundsY.getHeight());
            }
        }
        corners[0] = (float)x;
        corners[1] = (float)y;
        corners[2] = (float)x;
        corners[3] = (float)(y -= boundsY.getHeight());
        if (boundsZ != null) {
            if (this.zTextGap) {
                y = (double)(centerPixelsY - this.verticalBarSpacer) - boundsZ.getHeight();
                if (this.clampToScreenEdges) {
                    y = Math.min(y, (double)heightPixels - boundsX.getHeight() - boundsY.getHeight() - boundsZ.getHeight());
                    y = Math.max(y, 0.0);
                }
                corners[4] = (float)x;
                corners[5] = (float)y;
            } else {
                corners[4] = (float)x;
                corners[5] = (float)(y -= boundsZ.getHeight());
            }
        }
        return corners;
    }

    protected String getTextX(Axis2D axis) {
        return String.format("x: %.2f", Float.valueOf(this.getPositionX(axis)));
    }

    protected String getTextY(Axis2D axis) {
        return String.format("y: %.2f", Float.valueOf(this.getPositionY(axis)));
    }

    protected String getTextZ(Axis2D axis) {
        return null;
    }

    @Override
    public void dispose(GLContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        if (this.textRenderer == null) {
            return;
        }
        GL gl = context.getGL();
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        String xText = this.getTextX(axis);
        String yText = this.getTextY(axis);
        String zText = this.getTextZ(axis);
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        gl.glColor4fv(this.textBackgroundColor, 0);
        Rectangle2D xTextBounds = this.textRenderer.getBounds(xText);
        Rectangle2D yTextBounds = this.textRenderer.getBounds(yText);
        Rectangle2D zTextBounds = zText != null ? this.textRenderer.getBounds(zText) : null;
        Rectangle2D[] backBounds = this.getBackgroundBounds(xTextBounds, yTextBounds, zTextBounds);
        Rectangle2D xBackBounds = backBounds[0];
        Rectangle2D yBackBounds = backBounds[1];
        Rectangle2D zBackBounds = backBounds[2];
        float[] corners = this.getCorners(axis, xBackBounds, yBackBounds, zBackBounds);
        gl.glBegin(7);
        try {
            gl.glVertex2f(corners[0], corners[1]);
            gl.glVertex2f(corners[0], corners[1] + (float)xBackBounds.getHeight());
            gl.glVertex2f(corners[0] + (float)xBackBounds.getWidth(), corners[1] + (float)xBackBounds.getHeight());
            gl.glVertex2f(corners[0] + (float)xBackBounds.getWidth(), corners[1]);
            gl.glVertex2f(corners[2], corners[3]);
            gl.glVertex2f(corners[2], corners[3] + (float)yBackBounds.getHeight());
            gl.glVertex2f(corners[2] + (float)yBackBounds.getWidth(), corners[3] + (float)yBackBounds.getHeight());
            gl.glVertex2f(corners[2] + (float)yBackBounds.getWidth(), corners[3]);
            if (zText != null) {
                gl.glVertex2f(corners[4], corners[5]);
                gl.glVertex2f(corners[4], corners[5] + (float)zBackBounds.getHeight());
                gl.glVertex2f(corners[4] + (float)zBackBounds.getWidth(), corners[5] + (float)zBackBounds.getHeight());
                gl.glVertex2f(corners[4] + (float)zBackBounds.getWidth(), corners[5]);
            }
        }
        finally {
            gl.glEnd();
        }
        gl.glDisable(3042);
        gl.glTranslatef(0.375f, 0.375f, 0.0f);
        this.textRenderer.beginRendering(width, height);
        try {
            GlimpseColor.setColor(this.textRenderer, this.fontColor);
            this.textRenderer.draw(xText, (int)corners[0] + this.textSpacerX, (int)(corners[1] + (float)this.textSpacerY));
            this.textRenderer.draw(yText, (int)corners[2] + this.textSpacerX, (int)(corners[3] + (float)(this.textSpacerY * 2)));
            if (zText != null) {
                this.textRenderer.draw(zText, (int)corners[4] + this.textSpacerX, (int)(corners[5] + (float)this.textSpacerY));
            }
        }
        finally {
            this.textRenderer.endRendering();
            gl.glMatrixMode(5888);
            gl.glPopMatrix();
        }
    }
}

