/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.group;

import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.support.settings.LookAndFeel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class DelegatePainter
implements GlimpsePainter {
    private List<GlimpsePainter> painters = new CopyOnWriteArrayList<GlimpsePainter>();
    private boolean isVisible = true;
    private boolean isDisposed = false;

    public void addPainter(GlimpsePainter painter) {
        this.painters.add(painter);
    }

    public void removePainter(GlimpsePainter painter) {
        this.painters.remove(painter);
    }

    public void removeAll() {
        this.painters.clear();
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    @Override
    public void paintTo(GlimpseContext context) {
        if (!this.isVisible) {
            return;
        }
        for (GlimpsePainter painter : this.painters) {
            painter.paintTo(context);
        }
    }

    @Override
    public void dispose(GlimpseContext context) {
        if (!this.isDisposed) {
            this.isDisposed = true;
            for (GlimpsePainter painter : this.painters) {
                painter.dispose(context);
            }
        }
    }

    @Override
    public boolean isDisposed() {
        return this.isDisposed;
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        for (GlimpsePainter painter : this.painters) {
            painter.setLookAndFeel(laf);
        }
    }
}

