/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.geo;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.AxisNotSetException;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverter;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.painter.base.GlimpsePainterImpl;
import com.metsci.glimpse.support.color.GlimpseColor;
import com.metsci.glimpse.support.font.FontUtils;
import com.metsci.glimpse.util.units.Length;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.geom.Rectangle2D;
import java.text.NumberFormat;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class ScalePainter
extends GlimpsePainterImpl {
    protected float[] borderColor = GlimpseColor.fromColorRgba(0.0f, 0.0f, 0.0f, 1.0f);
    protected float[] primaryColor = GlimpseColor.fromColorRgba(1.0f, 1.0f, 1.0f, 0.5f);
    protected float[] secondaryColor = GlimpseColor.fromColorRgba(0.6f, 0.6f, 0.6f, 0.5f);
    protected float[] textColor = GlimpseColor.fromColorRgba(0.0f, 0.0f, 0.0f, 1.0f);
    protected int bufferX;
    protected int bufferY;
    protected int pixelHeight;
    protected int pixelWidth;
    protected AxisUnitConverter converter;
    protected String unitLabel;
    protected TextRenderer tickTextRenderer = this.createTickTextRenderer();
    protected TextRenderer overallTextRenderer = this.createOverallTextRenderer();
    protected NumberFormat formatter;
    protected boolean showTickLength = true;
    protected boolean showOverallLength = true;

    public ScalePainter() {
        this.converter = new AxisUnitConverter(){

            @Override
            public double fromAxisUnits(double value) {
                return Length.fromNauticalMiles((double)value);
            }

            @Override
            public double toAxisUnits(double value) {
                return Length.toNauticalMiles((double)value);
            }
        };
        this.formatter = NumberFormat.getNumberInstance();
        this.formatter.setGroupingUsed(false);
        this.unitLabel = "nmi";
        this.bufferX = 0;
        this.bufferY = 0;
        this.pixelHeight = 20;
        this.pixelWidth = 300;
    }

    protected TextRenderer createTickTextRenderer() {
        return new TextRenderer(FontUtils.getDefaultBold(11.0f), false, false);
    }

    protected TextRenderer createOverallTextRenderer() {
        return new TextRenderer(FontUtils.getDefaultBold(16.0f), false, false);
    }

    public float[] getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(float[] borderColor) {
        this.borderColor = borderColor;
    }

    public float[] getPrimaryColor() {
        return this.primaryColor;
    }

    public void setPrimaryColor(float[] primaryColor) {
        this.primaryColor = primaryColor;
    }

    public float[] getSecondaryColor() {
        return this.secondaryColor;
    }

    public void setSecondaryColor(float[] secondaryColor) {
        this.secondaryColor = secondaryColor;
    }

    public float[] getTextColor() {
        return this.textColor;
    }

    public void setTextColor(float[] textColor) {
        this.textColor = textColor;
    }

    public int getPixelBufferX() {
        return this.bufferX;
    }

    public void setPixelBufferX(int buffer) {
        this.bufferX = buffer;
    }

    public int getPixelBufferY() {
        return this.bufferY;
    }

    public void setPixelBufferY(int buffer) {
        this.bufferY = buffer;
    }

    public int getScaleHeight() {
        return this.pixelHeight;
    }

    public void setPixelHeight(int pixelHeight) {
        this.pixelHeight = pixelHeight;
    }

    public int getPixelHeight() {
        return this.pixelWidth;
    }

    public void setPixelWidth(int pixelWidth) {
        this.pixelWidth = pixelWidth;
    }

    public AxisUnitConverter getUnitConverter() {
        return this.converter;
    }

    public void setUnitConverter(AxisUnitConverter converter) {
        this.converter = converter;
    }

    public String getUnitLabel() {
        return this.unitLabel;
    }

    public void setUnitLabel(String unitLabel) {
        this.unitLabel = unitLabel;
    }

    public void setShowTickLength(boolean show) {
        this.showTickLength = show;
    }

    public void setShowOverallLength(boolean show) {
        this.showOverallLength = show;
    }

    @Override
    public void dispose(GLContext context) {
        if (this.tickTextRenderer != null) {
            this.tickTextRenderer.dispose();
        }
        if (this.overallTextRenderer != null) {
            this.overallTextRenderer.dispose();
        }
        this.overallTextRenderer = null;
        this.tickTextRenderer = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintTo(GlimpseContext context, GlimpseBounds bounds) {
        int posX;
        GlimpseLayout layout;
        if (this.tickTextRenderer == null) {
            return;
        }
        if (this.overallTextRenderer == null) {
            return;
        }
        Axis1D axis = null;
        GlimpseTarget target = context.getTargetStack().getTarget();
        if (target instanceof GlimpseAxisLayout2D) {
            layout = (GlimpseAxisLayout2D)target;
            axis = this.getAxis(((GlimpseAxisLayout2D)layout).getAxis(context));
        } else if (target instanceof GlimpseAxisLayout1D) {
            layout = (GlimpseAxisLayout1D)target;
            axis = ((GlimpseAxisLayout1D)layout).getAxis(context);
        }
        if (axis == null) {
            throw new AxisNotSetException((GlimpsePainter)this, context);
        }
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        context.getTargetStack();
        double diff = axis.getMax() - axis.getMin();
        double ratio = (double)axis.getSizePixels() / this.converter.toAxisUnits(diff);
        double hintValue = (double)this.pixelWidth / ratio;
        double hintOrder = Math.log10(hintValue);
        int order = (int)Math.ceil(hintOrder);
        double scaleValueSize = Math.pow(10.0, order - 1);
        double scalePixelSize = scaleValueSize * ratio;
        int tickCount = (int)Math.floor((double)this.pixelWidth / scalePixelSize);
        if (tickCount < 5) {
            scalePixelSize = (scaleValueSize /= 2.0) * ratio;
            tickCount = (int)Math.floor((double)this.pixelWidth / scalePixelSize);
        }
        double totalSize = scalePixelSize * (double)tickCount;
        GL gl = context.getGL();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        gl.glBegin(7);
        try {
            for (int i = 0; i < tickCount; ++i) {
                if (i % 2 == 0) {
                    gl.glColor4fv(this.secondaryColor, 0);
                } else {
                    gl.glColor4fv(this.primaryColor, 0);
                }
                double offset1 = totalSize * ((double)i / (double)tickCount);
                double offset2 = totalSize * ((double)(i + 1) / (double)tickCount);
                gl.glVertex2d((double)(width - this.bufferX) - offset1, (double)this.bufferY);
                gl.glVertex2d((double)(width - this.bufferX) - offset2, (double)this.bufferY);
                gl.glVertex2d((double)(width - this.bufferX) - offset2, (double)(this.bufferY + this.pixelHeight));
                gl.glVertex2d((double)(width - this.bufferX) - offset1, (double)(this.bufferY + this.pixelHeight));
            }
        }
        finally {
            gl.glEnd();
        }
        gl.glLineWidth(1.0f);
        gl.glColor4fv(this.borderColor, 0);
        gl.glBegin(2);
        try {
            gl.glVertex2d((double)(width - this.bufferX), (double)this.bufferY);
            gl.glVertex2d((double)(width - this.bufferX) - totalSize, (double)this.bufferY);
            gl.glVertex2d((double)(width - this.bufferX) - totalSize, (double)(this.bufferY + this.pixelHeight));
            gl.glVertex2d((double)(width - this.bufferX), (double)(this.bufferY + this.pixelHeight));
        }
        finally {
            gl.glEnd();
        }
        gl.glDisable(3042);
        gl.glTranslatef(0.375f, 0.375f, 0.0f);
        if (order < 2) {
            this.formatter.setMaximumFractionDigits(Math.abs(order - 2));
        } else {
            this.formatter.setMaximumFractionDigits(0);
        }
        if (this.showTickLength) {
            String tickText = this.formatter.format(scaleValueSize) + " " + this.unitLabel;
            Rectangle2D textBounds = this.tickTextRenderer.getBounds(tickText);
            posX = (int)((double)(width - 1 - this.bufferX) - textBounds.getWidth() - 1.0);
            int posY = (int)((double)(this.bufferY + this.pixelHeight / 2) - textBounds.getHeight() / 2.0);
            this.tickTextRenderer.beginRendering(width, height);
            try {
                GlimpseColor.setColor(this.tickTextRenderer, this.textColor);
                this.tickTextRenderer.draw(tickText, posX, posY);
            }
            finally {
                this.tickTextRenderer.endRendering();
            }
        }
        if (this.showOverallLength) {
            String overallText = this.formatter.format(scaleValueSize * (double)tickCount) + " " + this.unitLabel;
            Rectangle2D overallTextBounds = this.overallTextRenderer.getBounds(overallText);
            posX = (int)((double)(width - this.pixelWidth / 2) - overallTextBounds.getWidth() / 2.0);
            int posY = (int)((double)(this.bufferY + this.pixelHeight / 2) - overallTextBounds.getHeight() / 2.0);
            this.overallTextRenderer.beginRendering(width, height);
            try {
                GlimpseColor.setColor(this.overallTextRenderer, this.textColor);
                this.overallTextRenderer.draw(overallText, posX, posY);
            }
            finally {
                this.overallTextRenderer.endRendering();
            }
        }
    }

    protected Axis1D getAxis(Axis2D axis) {
        if (axis != null) {
            return axis.getAxisX();
        }
        return null;
    }
}

