/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.decoration;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainterImpl;
import com.metsci.glimpse.util.GeneralUtils;
import com.metsci.glimpse.util.io.StreamOpener;
import com.metsci.glimpse.util.logging.LoggerUtils;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.media.opengl.GL;

public class WatermarkPainter
extends GlimpsePainterImpl {
    private static final Logger logger = LoggerUtils.getLogger(WatermarkPainter.class);
    protected static final double maxWidthPixels = 350.0;
    protected static final double maxHeightPixels = 350.0;
    protected static final double maxAreaFraction = 0.04;
    protected static final double maxWidthFraction = 0.28;
    protected static final double maxHeightFraction = 0.28;
    protected static final double maxPaddingPixels = 10.0;
    protected final Supplier<BufferedImage> imageSupplier;
    protected Texture texture;
    protected boolean initialized;

    public WatermarkPainter(BufferedImage image) {
        this((Supplier<BufferedImage>)Suppliers.ofInstance((Object)image));
    }

    public WatermarkPainter(StreamOpener imageOpener, String imageLocation) {
        this(WatermarkPainter.newImageLoader(imageOpener, imageLocation));
    }

    public WatermarkPainter(Supplier<BufferedImage> imageSupplier) {
        this.imageSupplier = imageSupplier;
        this.texture = null;
        this.initialized = false;
    }

    public static Supplier<BufferedImage> newImageLoader(final StreamOpener opener, final String location) {
        return new Supplier<BufferedImage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public BufferedImage get() {
                BufferedImage bufferedImage;
                block6: {
                    InputStream stream = null;
                    try {
                        stream = opener.openForRead(location);
                        bufferedImage = ImageIO.read(stream);
                        if (stream == null) break block6;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (stream != null) {
                                stream.close();
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    stream.close();
                }
                return bufferedImage;
            }
        };
    }

    protected void initIfNecessary() {
        if (this.initialized) {
            return;
        }
        try {
            BufferedImage image = (BufferedImage)this.imageSupplier.get();
            this.texture = TextureIO.newTexture((TextureData)new TextureData(0, 0, false, image));
        }
        catch (Exception e) {
            LoggerUtils.logWarning((Logger)logger, (String)"Failed to create watermark image texture", (Throwable)e, (Object[])new Object[0]);
        }
        this.initialized = true;
    }

    protected double[] computeQuadGeometry(double wImage, double hImage, double wBounds, double hBounds) {
        double maxArea = 0.04 * wBounds * hBounds;
        double w = 350.0;
        w = Math.min(w, 0.28 * wBounds);
        w = Math.min(w, Math.sqrt(maxArea * wImage / hImage));
        double h = 350.0;
        h = Math.min(h, 0.28 * hBounds);
        h = Math.min(h, Math.sqrt(maxArea * hImage / wImage));
        w = Math.min(w, h * wImage / hImage);
        h = w * hImage / wImage;
        double p = 0.0;
        p = Math.max(p, w / 350.0);
        p = Math.max(p, h / 350.0);
        double padding = p * 10.0;
        return GeneralUtils.doubles((double[])new double[]{w, h, padding});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintTo(GlimpseContext context, GlimpseBounds bounds) {
        this.initIfNecessary();
        if (this.texture == null) {
            return;
        }
        GL gl = context.getGL();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)bounds.getWidth(), 0.0, (double)bounds.getHeight(), -1.0, 1.0);
        gl.glMatrixMode(5890);
        gl.glActiveTexture(33984);
        gl.glLoadIdentity();
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.texture.setTexParameteri(10240, 9728);
        this.texture.setTexParameteri(10241, 9728);
        this.texture.enable();
        this.texture.bind();
        gl.glEnable(3042);
        gl.glBlendFunc(1, 771);
        gl.glTexEnvi(8960, 8704, 7681);
        gl.glBegin(7);
        try {
            double[] quadGeometry = this.computeQuadGeometry(this.texture.getWidth(), this.texture.getHeight(), bounds.getWidth(), bounds.getHeight());
            double wQuad = quadGeometry[0];
            double hQuad = quadGeometry[1];
            double padding = quadGeometry[2];
            float xRight = (float)((double)bounds.getWidth() - padding);
            float xLeft = (float)((double)xRight - wQuad);
            float yBottom = (float)padding;
            float yTop = (float)((double)yBottom + hQuad);
            gl.glTexCoord2f(0.0f, 1.0f);
            gl.glVertex2f(xLeft, yBottom);
            gl.glTexCoord2f(1.0f, 1.0f);
            gl.glVertex2f(xRight, yBottom);
            gl.glTexCoord2f(1.0f, 0.0f);
            gl.glVertex2f(xRight, yTop);
            gl.glTexCoord2f(0.0f, 0.0f);
            gl.glVertex2f(xLeft, yTop);
        }
        finally {
            gl.glEnd();
            this.texture.disable();
        }
    }
}

