/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.decoration;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter2D;
import javax.media.opengl.GL;

public class MapBorderPainter
extends GlimpsePainter2D {
    protected float[] outerColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    protected float[] innerColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    protected int borderSize = 20;
    protected AxisLabelHandler ticksX;
    protected AxisLabelHandler ticksY;
    protected double savedValueX = -1.0;
    protected boolean savedOrientX = false;
    protected double savedValueY = -1.0;
    protected boolean savedOrientY = false;

    public MapBorderPainter(AxisLabelHandler ticksX, AxisLabelHandler ticksY) {
        this.ticksX = ticksX;
        this.ticksY = ticksY;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public void setBorderSize(int size) {
        this.borderSize = size;
    }

    public void setInnerColor(float r, float g, float b, float a) {
        this.innerColor[0] = r;
        this.innerColor[1] = g;
        this.innerColor[2] = b;
        this.innerColor[3] = a;
    }

    public void setInnerColor(float[] rgba) {
        this.innerColor = rgba;
    }

    public void setOuterColor(float r, float g, float b, float a) {
        this.outerColor[0] = r;
        this.outerColor[1] = g;
        this.outerColor[2] = b;
        this.outerColor[3] = a;
    }

    public void setOuterColor(float[] rgba) {
        this.outerColor = rgba;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void glDrawCorners(GL gl, int type, int width, int height) {
        gl.glBegin(type);
        try {
            gl.glVertex2d(0.0, 0.0);
            gl.glVertex2d(0.0, (double)this.borderSize);
            gl.glVertex2d((double)this.borderSize, (double)this.borderSize);
            gl.glVertex2d((double)this.borderSize, 0.0);
        }
        finally {
            gl.glEnd();
        }
        gl.glBegin(type);
        try {
            gl.glVertex2d(0.0, (double)height);
            gl.glVertex2d(0.0, (double)(height - this.borderSize));
            gl.glVertex2d((double)this.borderSize, (double)(height - this.borderSize));
            gl.glVertex2d((double)this.borderSize, (double)height);
        }
        finally {
            gl.glEnd();
        }
        gl.glBegin(type);
        try {
            gl.glVertex2d((double)width, 0.0);
            gl.glVertex2d((double)width, (double)this.borderSize);
            gl.glVertex2d((double)(width - this.borderSize), (double)this.borderSize);
            gl.glVertex2d((double)(width - this.borderSize), 0.0);
        }
        finally {
            gl.glEnd();
        }
        gl.glBegin(type);
        try {
            gl.glVertex2d((double)width, (double)height);
            gl.glVertex2d((double)width, (double)(height - this.borderSize));
            gl.glVertex2d((double)(width - this.borderSize), (double)(height - this.borderSize));
            gl.glVertex2d((double)(width - this.borderSize), (double)height);
        }
        finally {
            gl.glEnd();
        }
    }

    private void glSetColor(GL gl, int i, boolean orient) {
        if (i % 2 == 0) {
            if (orient) {
                gl.glColor4fv(this.outerColor, 0);
            } else {
                gl.glColor4fv(this.innerColor, 0);
            }
        } else if (orient) {
            gl.glColor4fv(this.innerColor, 0);
        } else {
            gl.glColor4fv(this.outerColor, 0);
        }
    }

    private boolean innerOrOuterFirstX(double[] ticks) {
        for (int i = 0; i < ticks.length; ++i) {
            if (ticks[i] != this.savedValueX) continue;
            if (i % 2 == 0) {
                return this.savedOrientX;
            }
            return !this.savedOrientX;
        }
        this.savedValueX = ticks[ticks.length / 2];
        this.savedOrientX = true;
        return this.savedOrientX;
    }

    private boolean innerOrOuterFirstY(double[] ticks) {
        for (int i = 0; i < ticks.length; ++i) {
            if (ticks[i] != this.savedValueY) continue;
            if (i % 2 == 0) {
                return this.savedOrientY;
            }
            return !this.savedOrientY;
        }
        this.savedValueY = ticks[ticks.length / 2];
        this.savedOrientY = true;
        return this.savedOrientY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GlimpseContext context, GlimpseBounds bounds, Axis2D axis) {
        int i;
        if (this.ticksX == null || this.ticksY == null) {
            return;
        }
        Axis1D axisX = axis.getAxisX();
        Axis1D axisY = axis.getAxisY();
        if (axisX == null || axisY == null) {
            return;
        }
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        GL gl = context.getGL();
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        gl.glOrtho(0.0, (double)width, 0.0, (double)height, -1.0, 1.0);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        double[] xPositions = this.ticksX.getTickPositions(axis.getAxisX());
        double[] yPositions = this.ticksY.getTickPositions(axis.getAxisY());
        boolean orientX = this.innerOrOuterFirstX(xPositions);
        boolean orientY = this.innerOrOuterFirstY(yPositions);
        for (i = 0; i < xPositions.length; ++i) {
            this.glSetColor(gl, i, orientX);
            int pos1X = axisX.valueToScreenPixel(xPositions[i]);
            int pos2X = i == xPositions.length - 1 ? width : axisX.valueToScreenPixel(xPositions[i + 1]);
            gl.glBegin(9);
            try {
                gl.glVertex2d((double)pos1X, (double)this.borderSize);
                gl.glVertex2d((double)pos1X, 0.0);
                gl.glVertex2d((double)pos2X, 0.0);
                gl.glVertex2d((double)pos2X, (double)this.borderSize);
            }
            finally {
                gl.glEnd();
            }
            this.glSetColor(gl, i, !orientX);
            gl.glBegin(9);
            try {
                gl.glVertex2d((double)pos1X, (double)(height - this.borderSize));
                gl.glVertex2d((double)pos1X, (double)height);
                gl.glVertex2d((double)pos2X, (double)height);
                gl.glVertex2d((double)pos2X, (double)(height - this.borderSize));
                continue;
            }
            finally {
                gl.glEnd();
            }
        }
        for (i = 0; i < yPositions.length; ++i) {
            this.glSetColor(gl, i, orientY);
            int pos1Y = axisY.valueToScreenPixel(yPositions[i]);
            int pos2Y = i == yPositions.length - 1 ? height : axisY.valueToScreenPixel(yPositions[i + 1]);
            gl.glBegin(9);
            try {
                gl.glVertex2d((double)this.borderSize, (double)pos1Y);
                gl.glVertex2d(0.0, (double)pos1Y);
                gl.glVertex2d(0.0, (double)pos2Y);
                gl.glVertex2d((double)this.borderSize, (double)pos2Y);
            }
            finally {
                gl.glEnd();
            }
            this.glSetColor(gl, i, !orientY);
            gl.glBegin(9);
            try {
                gl.glVertex2d((double)(width - this.borderSize), (double)pos1Y);
                gl.glVertex2d((double)width, (double)pos1Y);
                gl.glVertex2d((double)width, (double)pos2Y);
                gl.glVertex2d((double)(width - this.borderSize), (double)pos2Y);
                continue;
            }
            finally {
                gl.glEnd();
            }
        }
        gl.glColor4fv(this.innerColor, 0);
        this.glDrawCorners(gl, 9, width, height);
        gl.glColor4fv(this.outerColor, 0);
        this.glDrawCorners(gl, 2, width, height);
        gl.glBegin(2);
        try {
            gl.glVertex2d((double)this.borderSize, (double)this.borderSize);
            gl.glVertex2d((double)this.borderSize, (double)(height - this.borderSize));
            gl.glVertex2d((double)(width - this.borderSize), (double)(height - this.borderSize));
            gl.glVertex2d((double)(width - this.borderSize), (double)this.borderSize);
        }
        finally {
            gl.glEnd();
        }
        gl.glBegin(2);
        try {
            gl.glVertex2d(0.5, 0.5);
            gl.glVertex2d(0.5, (double)height - 0.5);
            gl.glVertex2d((double)width - 0.5, (double)height - 0.5);
            gl.glVertex2d((double)width - 0.5, 0.5);
        }
        finally {
            gl.glEnd();
        }
    }
}

