/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.decoration;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.painter.label.AxisLabelHandler;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverter;
import com.metsci.glimpse.axis.painter.label.AxisUnitConverters;
import com.metsci.glimpse.axis.painter.label.GridAxisLabelHandler;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.painter.base.GlimpseDataPainter2D;
import com.metsci.glimpse.support.color.GlimpseColor;
import javax.media.opengl.GL;

public class GridPainter
extends GlimpseDataPainter2D {
    protected static final short CASE3 = (short)Integer.parseInt("1100110011001100", 2);
    protected static final short CASE2 = (short)Integer.parseInt("0110011001100110", 2);
    protected static final short CASE1 = (short)Integer.parseInt("0011001100110011", 2);
    protected static final short CASE0 = (short)Integer.parseInt("1001100110011001", 2);
    protected float[] majorLineColor = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
    protected int majorLineThickness = 1;
    protected float[] minorLineColor = new float[]{0.5f, 0.5f, 0.5f, 0.15f};
    protected int minorLineThickness = 1;
    protected boolean showHorizontal = true;
    protected boolean showVertical = true;
    protected boolean showMinorTicks = true;
    protected boolean stipple = true;
    protected AxisLabelHandler ticksX;
    protected AxisLabelHandler ticksY;

    public GridPainter(AxisLabelHandler ticksX, AxisLabelHandler ticksY) {
        this.ticksX = ticksX;
        this.ticksY = ticksY;
    }

    public GridPainter() {
        this(new GridAxisLabelHandler(), new GridAxisLabelHandler());
    }

    public void setDotted(boolean dotted) {
        this.stipple = dotted;
    }

    public GridPainter setLineColor(float r, float g, float b, float a) {
        this.majorLineColor[0] = r;
        this.majorLineColor[1] = g;
        this.majorLineColor[2] = b;
        this.majorLineColor[3] = a;
        return this;
    }

    public GridPainter setLineColor(float[] rgba) {
        this.majorLineColor = rgba;
        return this;
    }

    public GridPainter setMinorLineColor(float[] rgba) {
        this.minorLineColor = rgba;
        return this;
    }

    public GridPainter setShowMinorGrid(boolean showMinorTicks) {
        this.showMinorTicks = showMinorTicks;
        return this;
    }

    public GridPainter setShowVerticalLines(boolean show) {
        this.showVertical = show;
        return this;
    }

    public GridPainter setShowHorizontalLines(boolean show) {
        this.showHorizontal = show;
        return this;
    }

    public GridPainter setTickHandlerX(AxisLabelHandler ticksX) {
        this.ticksX = ticksX;
        return this;
    }

    public GridPainter setTickHandlerY(AxisLabelHandler ticksY) {
        this.ticksY = ticksY;
        return this;
    }

    protected void glLineStipple(GL gl, Axis1D axis, AxisUnitConverter converter) {
        int stipplePhase = (int)axis.valueToScreenPixelUnits(converter.fromAxisUnits(0.0)) % 4;
        stipplePhase = stipplePhase < 0 ? stipplePhase + 4 : stipplePhase;
        this.glLineStipple(gl, stipplePhase);
    }

    protected void glLineStipple(GL gl, int stipplePhase) {
        switch (stipplePhase) {
            case 3: {
                gl.glLineStipple(1, CASE3);
                break;
            }
            case 2: {
                gl.glLineStipple(1, CASE2);
                break;
            }
            case 1: {
                gl.glLineStipple(1, CASE1);
                break;
            }
            case 0: {
                gl.glLineStipple(1, CASE0);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintTo(GL gl, GlimpseBounds bounds, Axis2D axis) {
        int i;
        gl.glDisable(2848);
        gl.glDisable(2832);
        if (this.stipple) {
            gl.glEnable(2852);
        }
        if (this.ticksX == null || this.ticksY == null) {
            return;
        }
        double[] xTicks = this.ticksX.getTickPositions(axis.getAxisX());
        AxisUnitConverter converterX = this.ticksX.getAxisUnitConverter();
        converterX = converterX == null ? AxisUnitConverters.identity : converterX;
        Axis1D axisX = axis.getAxisX();
        double[] yTicks = this.ticksY.getTickPositions(axis.getAxisY());
        AxisUnitConverter converterY = this.ticksY.getAxisUnitConverter();
        converterY = converterY == null ? AxisUnitConverters.identity : converterY;
        Axis1D axisY = axis.getAxisY();
        if (this.showVertical) {
            gl.glLineWidth((float)this.majorLineThickness);
            gl.glColor4fv(this.majorLineColor, 0);
            if (this.stipple) {
                this.glLineStipple(gl, axisY, converterY);
            }
            gl.glBegin(1);
            try {
                for (i = 0; i < xTicks.length; ++i) {
                    double iTick = converterX.fromAxisUnits(xTicks[i]);
                    gl.glVertex2d(iTick, axis.getMinY());
                    gl.glVertex2d(iTick, axis.getMaxY());
                }
            }
            finally {
                gl.glEnd();
            }
            if (this.showMinorTicks) {
                GlimpseColor.glColor(gl, this.majorLineColor, 0.1f);
                double[] xMinor = this.ticksX.getMinorTickPositions(xTicks);
                gl.glBegin(1);
                try {
                    for (int i2 = 0; i2 < xMinor.length; ++i2) {
                        double iTick = converterX.fromAxisUnits(xMinor[i2]);
                        gl.glVertex2d(iTick, axis.getMinY());
                        gl.glVertex2d(iTick, axis.getMaxY());
                    }
                }
                finally {
                    gl.glEnd();
                }
            }
        }
        if (this.showHorizontal) {
            gl.glLineWidth((float)this.majorLineThickness);
            gl.glColor4fv(this.majorLineColor, 0);
            if (this.stipple) {
                this.glLineStipple(gl, axisX, converterX);
            }
            gl.glBegin(1);
            try {
                for (i = 0; i < yTicks.length; ++i) {
                    double jTick = converterY.fromAxisUnits(yTicks[i]);
                    gl.glVertex2d(axis.getMinX(), jTick);
                    gl.glVertex2d(axis.getMaxX(), jTick);
                }
            }
            finally {
                gl.glEnd();
            }
            if (this.showMinorTicks) {
                GlimpseColor.glColor(gl, this.majorLineColor, 0.1f);
                double[] yMinor = this.ticksY.getMinorTickPositions(yTicks);
                gl.glBegin(1);
                try {
                    for (int i3 = 0; i3 < yMinor.length; ++i3) {
                        double jTick = converterY.fromAxisUnits(yMinor[i3]);
                        gl.glVertex2d(axis.getMinX(), jTick);
                        gl.glVertex2d(axis.getMaxX(), jTick);
                    }
                }
                finally {
                    gl.glEnd();
                }
            }
        }
    }
}

