/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.decoration;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainterImpl;
import com.metsci.glimpse.support.font.FontUtils;
import com.sun.opengl.util.j2d.TextRenderer;
import java.awt.Font;
import javax.media.opengl.GLContext;

public class CopyrightPainter
extends GlimpsePainterImpl {
    private static final String copyrightSymbol = "\u00a9";
    private static final Font textFont = FontUtils.getDefaultPlain(15.0f);
    private static float[] textColor = new float[]{0.5f, 0.5f, 0.5f, 1.0f};
    private static final int padding = 5;
    private TextRenderer textRenderer;
    private String text;

    public CopyrightPainter(String company, int year) {
        this.text = String.format("%s %s %d", company, copyrightSymbol, year);
        this.textRenderer = new TextRenderer(textFont, true, false);
    }

    public CopyrightPainter() {
        this("Metron", 2012);
    }

    @Override
    public void dispose(GLContext context) {
        if (this.textRenderer != null) {
            this.textRenderer.dispose();
        }
        this.textRenderer = null;
    }

    @Override
    protected void paintTo(GlimpseContext context, GlimpseBounds bounds) {
        if (this.textRenderer == null) {
            return;
        }
        int width = bounds.getWidth();
        int height = bounds.getHeight();
        double wText = this.textRenderer.getBounds(this.text).getWidth();
        int xText = (int)Math.round((double)width - wText - 5.0);
        int yText = 5;
        this.textRenderer.beginRendering(width, height);
        this.textRenderer.setColor(textColor[0], textColor[1], textColor[2], textColor[3]);
        this.textRenderer.draw(this.text, xText, yText);
        this.textRenderer.endRendering();
    }
}

