/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.painter.decoration;

import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.painter.base.GlimpsePainter;
import com.metsci.glimpse.support.settings.AbstractLookAndFeel;
import com.metsci.glimpse.support.settings.LookAndFeel;
import javax.media.opengl.GL;

public class BackgroundPainter
implements GlimpsePainter {
    protected float[] backgroundColor = new float[4];
    protected boolean colorSet = false;
    protected String lafColorKey;
    protected boolean displayOn = true;

    public BackgroundPainter() {
        this(false);
    }

    public BackgroundPainter(boolean isFrameBackground) {
        this.setLookAndFeelKey(isFrameBackground ? AbstractLookAndFeel.FRAME_BACKGROUND_COLOR : AbstractLookAndFeel.PLOT_BACKGROUND_COLOR);
    }

    @Override
    public void setVisible(boolean show) {
        this.displayOn = show;
    }

    @Override
    public boolean isVisible() {
        return this.displayOn;
    }

    public BackgroundPainter setColor(float[] rgba) {
        this.backgroundColor = rgba;
        this.colorSet = true;
        return this;
    }

    public BackgroundPainter setColor(float r, float g, float b, float a) {
        this.backgroundColor[0] = r;
        this.backgroundColor[1] = g;
        this.backgroundColor[2] = b;
        this.backgroundColor[3] = a;
        this.colorSet = true;
        return this;
    }

    public void setLookAndFeelKey(String key) {
        this.lafColorKey = key;
    }

    @Override
    public void paintTo(GlimpseContext context) {
        if (!this.displayOn) {
            return;
        }
        GL gl = context.getGL();
        gl.glClearColor(this.backgroundColor[0], this.backgroundColor[1], this.backgroundColor[2], this.backgroundColor[3]);
        gl.glClear(16640);
    }

    @Override
    public void setLookAndFeel(LookAndFeel laf) {
        if (!this.colorSet) {
            this.setColor(laf.getColor(this.lafColorKey));
            this.colorSet = false;
        }
    }

    @Override
    public void dispose(GlimpseContext context) {
    }

    @Override
    public boolean isDisposed() {
        return false;
    }
}

