/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.layout;

import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.util.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GlimpseLayoutCache<D> {
    protected Map<List<GlimpseTarget>, Pair<List<GlimpseBounds>, D>> map = new HashMap<List<GlimpseTarget>, Pair<List<GlimpseBounds>, D>>();

    public D getValue(GlimpseContext context) {
        return this.getValue(context.getTargetStack());
    }

    public D getValue(GlimpseTargetStack layoutStack) {
        List<GlimpseBounds> contextBounds;
        List cachedBounds;
        Pair<List<GlimpseBounds>, D> entry = this.map.get(layoutStack.getTargetList());
        if (entry != null && GlimpseLayoutCache.compareBounds(cachedBounds = (List)entry.first(), contextBounds = layoutStack.getBoundsList())) {
            return (D)entry.second();
        }
        return null;
    }

    public D getValueNoBoundsCheck(GlimpseContext context) {
        return this.getValueNoBoundsCheck(context.getTargetStack());
    }

    public D getValueNoBoundsCheck(GlimpseTargetStack layoutStack) {
        Pair<List<GlimpseBounds>, D> entry = this.map.get(layoutStack.getTargetList());
        if (entry != null) {
            return (D)entry.second();
        }
        return null;
    }

    public void setValue(GlimpseTargetStack stack, D value) {
        List<GlimpseTarget> targetList = Collections.unmodifiableList(new ArrayList<GlimpseTarget>(stack.getTargetList()));
        List<GlimpseBounds> boundsList = Collections.unmodifiableList(new ArrayList<GlimpseBounds>(stack.getBoundsList()));
        this.map.put(targetList, new Pair(boundsList, value));
    }

    public void setValue(GlimpseContext context, D value) {
        this.setValue(context.getTargetStack(), value);
    }

    public void clear() {
        this.map.clear();
    }

    public static boolean compareBounds(List<GlimpseBounds> list1, List<GlimpseBounds> list2) {
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<GlimpseBounds> iter1 = list1.iterator();
        Iterator<GlimpseBounds> iter2 = list2.iterator();
        while (iter1.hasNext()) {
            GlimpseBounds bounds2;
            GlimpseBounds bounds1 = iter1.next();
            if (bounds1.equals(bounds2 = iter2.next())) continue;
            return false;
        }
        return true;
    }
}

