/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.layout;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.axis.AxisNotSetException;
import com.metsci.glimpse.axis.factory.AxisFactory2D;
import com.metsci.glimpse.axis.factory.DefaultAxisFactory2D;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseContext;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseLayout;
import com.metsci.glimpse.layout.GlimpseLayoutCache;

public class GlimpseAxisLayout2D
extends GlimpseLayout {
    protected GlimpseLayoutCache<Axis2D> cache;
    protected Axis2D axis;
    protected boolean defaultSet = false;
    protected AxisFactory2D factory;

    public GlimpseAxisLayout2D(GlimpseLayout parent, String name, Axis2D axis) {
        super(parent, name);
        this.axis = axis;
        this.cache = new GlimpseLayoutCache();
    }

    public GlimpseAxisLayout2D(GlimpseLayout parent, Axis2D axis) {
        this(parent, null, axis);
    }

    public GlimpseAxisLayout2D(String name, Axis2D axis) {
        this(null, name, axis);
    }

    public GlimpseAxisLayout2D(Axis2D axis) {
        this(null, null, axis);
    }

    public GlimpseAxisLayout2D(Axis1D axisX, Axis1D axisY) {
        this(null, null, new Axis2D(axisX, axisY));
    }

    public GlimpseAxisLayout2D(GlimpseLayout parent, String name) {
        this(parent, name, null);
    }

    public GlimpseAxisLayout2D(GlimpseLayout parent) {
        this(parent, null, null);
    }

    public GlimpseAxisLayout2D(String name) {
        this(null, name, null);
    }

    public GlimpseAxisLayout2D() {
        this(null, null, null);
    }

    @Override
    protected void preLayout(GlimpseTargetStack stack, GlimpseBounds bounds) {
        Axis2D contextAxis = this.getAxis(stack);
        if (contextAxis == null) {
            throw new AxisNotSetException(stack);
        }
        contextAxis.setSizePixels(bounds);
    }

    public void clearCache() {
        this.cache.clear();
        for (GlimpseTarget target : this.getTargetChildren()) {
            GlimpseLayout layout;
            if (target instanceof GlimpseAxisLayout1D) {
                layout = (GlimpseAxisLayout1D)target;
                if (((GlimpseAxisLayout1D)layout).isAxisSet()) continue;
                ((GlimpseAxisLayout1D)layout).clearCache();
                continue;
            }
            if (!(target instanceof GlimpseAxisLayout2D) || ((GlimpseAxisLayout2D)(layout = (GlimpseAxisLayout2D)target)).isAxisSet()) continue;
            ((GlimpseAxisLayout2D)layout).clearCache();
        }
    }

    public void setAxis(Axis2D axis) {
        this.clearCache();
        this.defaultSet = false;
        this.axis = axis;
    }

    public void setAxis(GlimpseTargetStack stack, Axis2D axis) {
        this.cache.setValue(stack, axis);
    }

    public void setAxis(GlimpseContext context, Axis2D axis) {
        this.cache.setValue(context, axis);
    }

    public AxisFactory2D getAxisFactory() {
        return this.factory;
    }

    public void setAxisFactory(AxisFactory2D factory) {
        this.factory = factory;
    }

    public boolean isAxisSet() {
        return this.axis != null;
    }

    public boolean isAxisFactorySet() {
        return this.factory != null;
    }

    public Axis2D getAxis() {
        return this.axis;
    }

    public Axis2D getAxis(GlimpseContext context) {
        return this.getAxis(context.getTargetStack());
    }

    public Axis2D getAxis(GlimpseTargetStack stack) {
        AxisFactory2D factory = this.getAxisFactory0(stack);
        for (GlimpseTarget target : stack.getTargetList()) {
            GlimpseAxisLayout2D layout;
            if (!(target instanceof GlimpseAxisLayout2D) || !(layout = (GlimpseAxisLayout2D)target).isAxisSet()) continue;
            return this.getCachedAxis0(layout.getAxis(), factory, stack);
        }
        return null;
    }

    protected AxisFactory2D getAxisFactory0(GlimpseTargetStack stack) {
        for (GlimpseTarget target : stack.getTargetList()) {
            GlimpseAxisLayout2D layout;
            if (!(target instanceof GlimpseAxisLayout2D) || !(layout = (GlimpseAxisLayout2D)target).isAxisFactorySet()) continue;
            return layout.getAxisFactory();
        }
        return null;
    }

    protected Axis2D getCachedAxis0(Axis2D parent_axis, AxisFactory2D factory, GlimpseTargetStack stack) {
        Axis2D newAxis = null;
        if (!this.defaultSet) {
            this.defaultSet = true;
            newAxis = parent_axis;
            this.cache.setValue(stack, newAxis);
        } else {
            newAxis = this.cache.getValueNoBoundsCheck(stack);
            if (newAxis == null) {
                newAxis = factory != null ? factory.newAxis(stack, parent_axis) : DefaultAxisFactory2D.newAxis(parent_axis);
                newAxis.setSizePixels(stack.getBounds());
                this.cache.setValue(stack, newAxis);
            }
        }
        return newAxis;
    }

    protected Axis2D getCachedAxis0(Axis2D parent_axis, AxisFactory2D factory, GlimpseContext context) {
        return this.getCachedAxis0(parent_axis, factory, context.getTargetStack());
    }
}

