/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.texture;

import com.metsci.glimpse.gl.texture.AbstractTexture;
import com.metsci.glimpse.support.colormap.ColorGradient;
import com.sun.opengl.util.BufferUtil;
import java.nio.FloatBuffer;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;

public class ColorTexture1D
extends AbstractTexture {
    protected final ReentrantLock lock = new ReentrantLock();
    protected FloatBuffer rgba = BufferUtil.newFloatBuffer((int)(4 * this.dim[0]));

    public ColorTexture1D(int n) {
        super(n);
    }

    @Override
    protected void prepare_setTexParameters(GL gl) {
        gl.glTexParameteri(3552, 10240, 9728);
        gl.glTexParameteri(3552, 10241, 9728);
        gl.glTexParameteri(3552, 10242, 10496);
    }

    @Override
    protected void prepare_setPixelStore(GL gl) {
        gl.glPixelStorei(3317, 1);
    }

    @Override
    protected void prepare_setData(GL gl) {
        gl.glTexImage1D(3552, 0, 6408, this.dim[0], 0, 6408, 5126, this.rgba.rewind());
    }

    public void setColorGradient(ColorGradient gradient) {
        this.mutate(new ColorGradientBuilder(gradient));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mutate(MutatorColor1D mutator) {
        this.lock.lock();
        try {
            this.rgba.rewind();
            mutator.mutate(this.rgba, this.dim[0]);
            this.makeDirty();
        }
        finally {
            this.lock.unlock();
        }
    }

    public static abstract class Builder
    implements MutatorColor1D {
        public abstract void getColor(int var1, int var2, float[] var3);

        @Override
        public void mutate(FloatBuffer floatBuffer, int dim) {
            float[] rgbaBytes = new float[4];
            for (int i = 0; i < dim; ++i) {
                this.getColor(i, dim, rgbaBytes);
                floatBuffer.put(rgbaBytes[0]);
                floatBuffer.put(rgbaBytes[1]);
                floatBuffer.put(rgbaBytes[2]);
                floatBuffer.put(rgbaBytes[3]);
            }
        }
    }

    public static class ColorGradientBuilder
    extends Builder {
        ColorGradient gradient;

        public ColorGradientBuilder(ColorGradient gradient) {
            this.gradient = gradient;
        }

        @Override
        public void getColor(int index, int size, float[] rgba) {
            this.gradient.toColor((float)index / (float)(size - 1), rgba);
        }
    }

    public static interface MutatorColor1D {
        public void mutate(FloatBuffer var1, int var2);
    }
}

