/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.shader;

import com.metsci.glimpse.gl.shader.ShaderArgInOut;
import com.metsci.glimpse.gl.shader.ShaderArgQualifier;
import com.metsci.glimpse.gl.shader.ShaderArgType;
import com.metsci.glimpse.util.logging.LoggerUtils;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.media.opengl.GL;

public class ShaderArg {
    private static final Logger logger = Logger.getLogger(ShaderArg.class.getName());
    private final ReentrantLock lock = new ReentrantLock();
    private final String name;
    private String toStringResult;
    private final ShaderArgType type;
    private final ShaderArgQualifier qual;
    private final ShaderArgInOut inout;
    private Object lastPushedValue;
    private Object currentValue;
    private boolean dirty;

    public ShaderArg(String name, ShaderArgType type, ShaderArgQualifier qual, ShaderArgInOut inout) {
        this.name = name;
        this.type = type;
        this.qual = qual;
        this.inout = inout;
        this.makeDirty();
    }

    public String getName() {
        return this.name;
    }

    public ShaderArgType getType() {
        return this.type;
    }

    public ShaderArgQualifier getQual() {
        return this.qual;
    }

    public ShaderArgInOut getInOut() {
        return this.inout;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void makeDirty() {
        this.dirty = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(Object val) {
        this.lock.lock();
        try {
            this.currentValue = val;
            if (this.lastPushedValue != null && !this.currentValue.equals(this.lastPushedValue)) {
                this.makeDirty();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(GL gl, int glArgHandle) {
        this.lock.lock();
        try {
            if (this.lastPushedValue != null && this.currentValue.equals(this.lastPushedValue)) {
                this.dirty = false;
                return;
            }
            switch (this.type) {
                case SAMPLER_CUBE: 
                case SAMPLER_2D: 
                case ISAMPLER_2D: 
                case USAMPLER_2D: 
                case SAMPLER_1D: 
                case ISAMPLER_1D: 
                case USAMPLER_1D: 
                case INT: {
                    LoggerUtils.logFine((Logger)logger, (String)"Updating %s to %s.", (Object[])new Object[]{this.toString(), this.currentValue.toString()});
                    gl.glUniform1i(glArgHandle, this.getIntValue());
                    break;
                }
                case FLOAT: {
                    LoggerUtils.logFine((Logger)logger, (String)"Updating %s to %s.", (Object[])new Object[]{this.toString(), this.currentValue.toString()});
                    gl.glUniform1f(glArgHandle, this.getFloatValue());
                    break;
                }
                case BOOLEAN: {
                    LoggerUtils.logFine((Logger)logger, (String)"Updating %s to %s.", (Object[])new Object[]{this.toString(), this.currentValue.toString()});
                    gl.glUniform1i(glArgHandle, this.getBooleanValue() ? 1 : 0);
                    break;
                }
                case VEC2: {
                    gl.glUniform2fv(glArgHandle, 1, this.getFloatArrayValue(), 0);
                    break;
                }
                case VEC3: {
                    gl.glUniform3fv(glArgHandle, 1, this.getFloatArrayValue(), 0);
                    break;
                }
                case VEC4: {
                    gl.glUniform4fv(glArgHandle, 1, this.getFloatArrayValue(), 0);
                    break;
                }
                case MAT2: {
                    gl.glUniformMatrix2fv(glArgHandle, 1, false, this.getFloatArrayValue(), 0);
                    break;
                }
                case MAT3: {
                    gl.glUniformMatrix3fv(glArgHandle, 1, false, this.getFloatArrayValue(), 0);
                    break;
                }
                case MAT4: {
                    gl.glUniformMatrix4fv(glArgHandle, 1, false, this.getFloatArrayValue(), 0);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported type.");
                }
            }
            this.lastPushedValue = this.currentValue;
            this.dirty = false;
        }
        finally {
            this.lock.unlock();
        }
    }

    private int getIntValue() {
        return ((Number)this.currentValue).intValue();
    }

    private float getFloatValue() {
        return ((Number)this.currentValue).floatValue();
    }

    private boolean getBooleanValue() {
        return (Boolean)this.currentValue;
    }

    private float[] getFloatArrayValue() {
        return (float[])this.currentValue;
    }

    public String toString() {
        if (this.toStringResult == null) {
            StringBuilder b = new StringBuilder();
            b.append("'");
            if (this.inout != null) {
                b.append((Object)this.inout).append(" ");
            }
            if (this.qual != null) {
                b.append((Object)this.qual).append(" ");
            }
            if (this.type != null) {
                b.append((Object)this.type).append(" ");
            }
            if (this.name != null) {
                b.append(this.name);
            }
            b.append("'");
            this.toStringResult = b.toString();
        }
        return this.toStringResult;
    }
}

