/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.shader;

import com.metsci.glimpse.gl.shader.GLShaderUtils;
import com.metsci.glimpse.gl.shader.Shader;
import com.metsci.glimpse.gl.shader.ShaderType;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import javax.media.opengl.GLException;

public class Pipeline {
    private static final Logger logger = Logger.getLogger(Pipeline.class.getName());
    private final String name;
    private Shader geometryShader;
    private Shader vertexShader;
    private Shader fragmentShader;
    private int glProgramHandle;
    private boolean isEmpty;
    private boolean isDirty;
    private boolean isLinked;
    public static final Pipeline empty = new Pipeline("null", null, null, null);

    public Pipeline(String name, Shader geom, Shader vert, Shader frag) {
        Pipeline.verify(geom, vert, frag);
        this.name = name;
        this.geometryShader = geom;
        this.vertexShader = vert;
        this.fragmentShader = frag;
        this.isDirty = true;
        if (geom == null && vert == null && frag == null) {
            this.isEmpty = true;
            this.isDirty = false;
            this.isLinked = true;
        }
    }

    private static void verify(Shader geom, Shader vert, Shader frag) {
        if (geom != null && vert == null) {
            throw new GLException("Geometry shader present w/o accompanying vertex shader.");
        }
        if (geom != null && geom.getType() != ShaderType.geometry || vert != null && vert.getType() != ShaderType.vertex || frag != null && frag.getType() != ShaderType.fragment) {
            throw new IllegalArgumentException("Incorrect shader type supplied in pipeline construction.");
        }
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "'PIPELINE " + this.getName() + "'";
    }

    public boolean isLinked(GL gl) {
        return this.isLinked;
    }

    public void beginUse(GL gl) {
        if (this.isEmpty) {
            return;
        }
        if (this.isDirty) {
            this.isLinked = this.compileAndLink(gl);
        }
        this.isDirty = false;
        if (!this.isLinked) {
            return;
        }
        gl.glUseProgram(this.glProgramHandle);
        if (this.vertexShader != null) {
            this.vertexShader.preDisplay(gl);
            this.vertexShader.updateArgValues(gl);
        }
        if (this.geometryShader != null) {
            this.geometryShader.preDisplay(gl);
            this.geometryShader.updateArgValues(gl);
        }
        if (this.fragmentShader != null) {
            this.fragmentShader.preDisplay(gl);
            this.fragmentShader.updateArgValues(gl);
        }
    }

    public void endUse(GL gl) {
        if (this.isEmpty) {
            return;
        }
        if (!this.isLinked) {
            return;
        }
        if (this.fragmentShader != null) {
            this.fragmentShader.postDisplay(gl);
        }
        if (this.geometryShader != null) {
            this.geometryShader.postDisplay(gl);
        }
        if (this.vertexShader != null) {
            this.vertexShader.postDisplay(gl);
        }
        gl.glUseProgram(0);
    }

    private boolean compileAndLink(GL gl) {
        if (this.isEmpty) {
            return true;
        }
        this.isLinked = false;
        logger.info("Compiling " + this.toString() + "...");
        this.glProgramHandle = gl.glCreateProgram();
        if (this.geometryShader != null && !this.geometryShader.compileAndAttach(gl, this.glProgramHandle)) {
            return false;
        }
        if (this.vertexShader != null && !this.vertexShader.compileAndAttach(gl, this.glProgramHandle)) {
            return false;
        }
        if (this.fragmentShader != null && !this.fragmentShader.compileAndAttach(gl, this.glProgramHandle)) {
            return false;
        }
        logger.info("Linking " + this.toString() + "...");
        gl.glLinkProgram(this.glProgramHandle);
        boolean success = GLShaderUtils.logGLProgramInfoLog(logger, gl, this.glProgramHandle, this.toString());
        if (!success) {
            return false;
        }
        this.isLinked = true;
        if (this.geometryShader != null) {
            this.geometryShader.getShaderArgHandles(gl, this.glProgramHandle);
        }
        if (this.vertexShader != null) {
            this.vertexShader.getShaderArgHandles(gl, this.glProgramHandle);
        }
        if (this.fragmentShader != null) {
            this.fragmentShader.getShaderArgHandles(gl, this.glProgramHandle);
        }
        return true;
    }

    public void dispose(GLContext context) {
        GL gl = context.getGL();
        gl.glDeleteProgram(this.glProgramHandle);
        if (this.geometryShader != null) {
            this.geometryShader.dispose(context);
        }
        if (this.vertexShader != null) {
            this.vertexShader.dispose(context);
        }
        if (this.fragmentShader != null) {
            this.fragmentShader.dispose(context);
        }
    }
}

