/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl.layout;

import com.metsci.glimpse.gl.GLSimpleListener;
import com.metsci.glimpse.gl.GLSimpleListenerAbstract;
import com.metsci.glimpse.gl.layout.GLDisplayCallback;
import com.metsci.glimpse.gl.layout.GLLayoutManagerMig;
import com.metsci.glimpse.gl.layout.GLLayoutManger;
import com.metsci.glimpse.gl.layout.GLLayoutUpdateListener;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;

public class GLLayoutPainter
extends GLSimpleListenerAbstract
implements ComponentWrapper,
ContainerWrapper {
    public ReentrantLock lock = new ReentrantLock();
    public static final int DEFAULT = -1;
    public static final int DEFAULT_WIDTH = 100;
    public static final int DEFAULT_HEIGHT = 100;
    private String name = "";
    private int x;
    private int y;
    private int width;
    private int height;
    private boolean hovered = false;
    private boolean visible = true;
    private static boolean visualPadding = false;
    private static boolean zeroMinSize = true;
    private GLLayoutManger layoutManager = new GLLayoutManagerMig();
    private Object layoutData = null;
    private boolean validLayout = false;
    private boolean validListenerShapes = false;
    private GLLayoutPainter layoutParent;
    private List<GLLayoutPainter> layoutChildren;
    private List<Member> members;
    private List<Member> newMembers;
    private List<Member> deletedMembers;
    private List<GLLayoutUpdateListener> updateListeners;

    public GLLayoutPainter(GLLayoutPainter parent) {
        this.layoutParent = parent;
        this.layoutChildren = new CopyOnWriteArrayList<GLLayoutPainter>();
        this.members = new CopyOnWriteArrayList<Member>();
        this.newMembers = new CopyOnWriteArrayList<Member>();
        this.deletedMembers = new CopyOnWriteArrayList<Member>();
        this.updateListeners = new CopyOnWriteArrayList<GLLayoutUpdateListener>();
        if (parent != null) {
            parent.addLayoutPainter(this);
        }
    }

    public GLLayoutPainter() {
        this(null);
    }

    public void addLayoutUpdateListener(GLLayoutUpdateListener listener) {
        this.updateListeners.add(listener);
        listener.layoutEvent(this.x, this.y, this.width, this.height);
    }

    public void removeLayoutPainter(GLLayoutPainter layout) {
        this.deletedMembers.add(new Member(layout, null, true));
        this.invalidateLayout();
    }

    public void removeSimpleListener(GLSimpleListener layout) {
        this.deletedMembers.add(new Member(layout, null, false));
        this.invalidateLayout();
    }

    public void addLayoutPainter(GLLayoutPainter layout) {
        this.addLayoutPainter(layout, null);
    }

    public void addLayoutPainter(GLLayoutPainter layout, GLDisplayCallback c) {
        if (layout == null) {
            throw new IllegalArgumentException("Null value for layout object.");
        }
        this.newMembers.add(new Member(layout, c, true));
        this.invalidateLayout();
    }

    public void addSimpleListener(GLSimpleListener listener) {
        this.addSimpleListener(listener, null);
    }

    public void addSimpleListener(GLSimpleListener listener, GLDisplayCallback c) {
        if (listener == null) {
            throw new IllegalArgumentException("Null value for listener object.");
        }
        this.newMembers.add(new Member(listener, c, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose(GLContext context) {
        this.lock.lock();
        try {
            for (GLLayoutPainter child : this.layoutChildren) {
                child.dispose(context);
            }
            for (Member member : this.members) {
                member.listener.dispose(context);
            }
            for (Member member : this.newMembers) {
                member.listener.dispose(context);
            }
            for (Member member : this.deletedMembers) {
                member.listener.dispose(context);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNewMembers(GLContext context, boolean reshape) {
        this.lock.lock();
        try {
            GLLayoutPainter child;
            for (Member m : this.newMembers) {
                if (m.layoutParticipant) {
                    child = (GLLayoutPainter)m.listener;
                    child.layoutParent = this;
                    this.layoutChildren.add(child);
                    child.init(context);
                    this.invalidateLayout();
                } else {
                    m.listener.init(context);
                    if (reshape) {
                        m.listener.reshape(context, this.x, this.y, this.width, this.height);
                    }
                }
                this.members.add(m);
            }
            this.newMembers.clear();
            for (Member m : this.deletedMembers) {
                if (m.layoutParticipant) {
                    child = (GLLayoutPainter)m.listener;
                    this.layoutChildren.remove(child);
                    child.dispose(context);
                    this.invalidateLayout();
                }
                this.members.remove(m);
            }
            this.deletedMembers.clear();
            if (!reshape) {
                this.invalidateListenerShapes();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void init(GLContext context) {
        this.initializeNewMembers(context, false);
        this.invalidateListenerShapes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void display(GLContext context) {
        this.initializeNewMembers(context, true);
        this.validateLayout(context);
        this.validateListenerShapes(context);
        Rectangle b = this.getBounds();
        if (b.width == 0 || b.height == 0) {
            return;
        }
        GL gl = context.getGL();
        try {
            gl.glEnable(3089);
            gl.glViewport(b.x, b.y, b.width, b.height);
            gl.glScissor(b.x, b.y, b.width, b.height);
            for (Member m : this.members) {
                if (m.callback != null) {
                    m.callback.preDisplay(m.listener, context, this.isHovered());
                }
                m.listener.display(context);
                if (m.callback == null) continue;
                m.callback.postDisplay(m.listener, context, this.isHovered());
            }
        }
        finally {
            gl.glDisable(3089);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reshape(GLContext context, int x, int y, int width, int height) {
        this.lock.lock();
        try {
            if (this.layoutParent != null) {
                throw new IllegalStateException("Should never be called when a parent exists.");
            }
            this.setBounds(x, y, width, height);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBounds(int x, int y, int width, int height) {
        this.lock.lock();
        try {
            if (this.x != x || this.y != y || this.width != width || this.height != height) {
                this.x = x;
                this.y = y;
                this.width = width;
                this.height = height;
                this.invalidateLayout();
                this.invalidateListenerShapes();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void displayChanged(GLContext context, boolean modeChanged, boolean deviceChanged) {
        this.lock.lock();
        try {
            this.initializeNewMembers(context, true);
            for (Member m : this.members) {
                m.listener.displayChanged(context, modeChanged, deviceChanged);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void invalidate() {
        this.invalidateLayout();
        this.invalidateListenerShapes();
    }

    void invalidateListenerShapes() {
        this.validListenerShapes = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateListenerShapes(GLContext context) {
        this.lock.lock();
        try {
            if (!this.validListenerShapes) {
                for (Member m : this.members) {
                    if (m.layoutParticipant) {
                        ((GLLayoutPainter)m.listener).validateListenerShapes(context);
                        continue;
                    }
                    m.listener.reshape(context, this.x, this.y, this.width, this.height);
                }
                this.validListenerShapes = true;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateLayout() {
        this.lock.lock();
        try {
            this.validLayout = false;
            if (this.layoutParent != null && this.layoutParent.validLayout) {
                this.layoutParent.invalidateLayout();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void validateLayout(GLContext context) {
        assert (context != null);
        this.lock.lock();
        try {
            if (!this.validLayout) {
                this.layoutManager.layout(context, this);
                for (Member m : this.members) {
                    if (!m.layoutParticipant) continue;
                    ((GLLayoutPainter)m.listener).validateLayout(context);
                }
                this.validLayout = true;
                this.invalidateListenerShapes();
            }
            for (GLLayoutUpdateListener l : this.updateListeners) {
                l.layoutEvent(this.x, this.y, this.width, this.height);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setHovered(boolean value) {
        this.hovered = value;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public Object getLayoutData() {
        return this.layoutData;
    }

    public void setLayout(GLLayoutManger manager) {
        this.layoutManager = manager;
    }

    public void setLayoutData(Object layoutData) {
        this.layoutData = layoutData;
    }

    public GLLayoutPainter getComponent() {
        return this;
    }

    public int getX() {
        return this.getBounds().x;
    }

    public int getY() {
        return this.getBounds().y;
    }

    public int getWidth() {
        return this.getBounds().width;
    }

    public int getHeight() {
        return this.getBounds().height;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Dimension computeSize(int wHint, int hHint) {
        this.lock.lock();
        try {
            int width = wHint == -1 ? 100 : wHint;
            int height = hHint == -1 ? 100 : hHint;
            int border = 0;
            Dimension dimension = new Dimension(width += border * 2, height += border * 2);
            return dimension;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getMinimumWidth(int hHint) {
        return zeroMinSize ? 0 : this.getPreferredWidth(hHint);
    }

    public int getMinimumHeight(int wHint) {
        return zeroMinSize ? 0 : this.getPreferredHeight(wHint);
    }

    public int getPreferredWidth(int hHint) {
        return this.computeSize((int)-1, (int)hHint).width;
    }

    public int getPreferredHeight(int wHint) {
        return this.computeSize((int)wHint, (int)-1).height;
    }

    public int getMaximumWidth(int hHint) {
        return Short.MAX_VALUE;
    }

    public int getMaximumHeight(int wHint) {
        return Short.MAX_VALUE;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getBaseline(int width, int height) {
        return -1;
    }

    public boolean hasBaseline() {
        return false;
    }

    public GLLayoutPainter getParent() {
        return this.layoutParent;
    }

    public String getLinkId() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLayoutHashCode() {
        int h;
        this.lock.lock();
        try {
            String id;
            Rectangle b = this.getBounds();
            h = b.x + (b.y << 12) + (b.width << 22) + (b.height << 16);
            if (this.isVisible()) {
                h |= 0x2000000;
            }
            if ((id = this.getLinkId()) != null) {
                h += id.hashCode();
            }
            if (this.isLeftToRight()) {
                h |= 0x4000000;
            }
        }
        finally {
            this.lock.unlock();
        }
        return h;
    }

    public boolean isPadded() {
        return visualPadding;
    }

    public void setPadding(boolean v) {
        visualPadding = v;
    }

    public int[] getVisualPadding() {
        return null;
    }

    public int getComponetType(boolean disregardScrollPane) {
        return 1;
    }

    RuntimeException screenAccessException() {
        return new UnsupportedOperationException("GL layout parameters cannot use screen parameters.");
    }

    public void paintDebugOutline() {
        throw this.screenAccessException();
    }

    public float getPixelUnitFactor(boolean isHor) {
        return 1.0f;
    }

    public int getHorizontalScreenDPI() {
        throw this.screenAccessException();
    }

    public int getVerticalScreenDPI() {
        throw this.screenAccessException();
    }

    public int getScreenWidth() {
        throw this.screenAccessException();
    }

    public int getScreenHeight() {
        throw this.screenAccessException();
    }

    public int getScreenLocationX() {
        throw this.screenAccessException();
    }

    public int getScreenLocationY() {
        throw this.screenAccessException();
    }

    public ComponentWrapper[] getComponents() {
        return this.layoutChildren.toArray(new ComponentWrapper[0]);
    }

    public int getComponentCount() {
        return this.layoutChildren.size();
    }

    public GLLayoutManger getLayout() {
        return this.layoutManager;
    }

    public boolean isLeftToRight() {
        return true;
    }

    public void paintDebugCell(int x, int y, int width, int height) {
        throw this.screenAccessException();
    }

    private static class Member {
        public boolean layoutParticipant;
        public GLSimpleListener listener;
        public GLDisplayCallback callback;

        public Member(GLSimpleListener listener, GLDisplayCallback callback, boolean layoutParticipant) {
            this.listener = listener;
            this.callback = callback;
            this.layoutParticipant = layoutParticipant;
        }

        public int hashCode() {
            return 31 + (this.listener == null ? 0 : this.listener.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Member other = (Member)obj;
            if (this.listener == null && other.listener != null) {
                return false;
            }
            return this.listener.equals(other.listener);
        }
    }
}

