/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.gl;

import com.metsci.glimpse.gl.GLRunnable;
import com.metsci.glimpse.gl.GLSimpleFboListenerEntry;
import com.metsci.glimpse.gl.GLSimpleListener;
import com.metsci.glimpse.support.texture.ExternalTextureProjected2D;
import com.metsci.glimpse.support.texture.TextureProjected2D;
import com.metsci.glimpse.util.logging.LoggerUtils;
import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureIO;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class GLSimpleFrameBufferObject {
    private static final Logger logger = Logger.getLogger(GLSimpleFrameBufferObject.class.getName());
    private GLContext context;
    private boolean initialized;
    private int width;
    private int height;
    private boolean useStencil;
    private boolean useDepth;
    private int[] textureId;
    private int[] renderBufferId;
    private int[] frameBufferId;
    private List<GLSimpleFboListenerEntry> listeners;
    private ReentrantLock lock;

    public GLSimpleFrameBufferObject(int width, int height, GLContext context) {
        this(width, height, true, false, context);
    }

    public GLSimpleFrameBufferObject(int width, int height, boolean useDepth, boolean useStencil, GLContext context) {
        this.context = context;
        this.width = width;
        this.height = height;
        this.useDepth = useDepth;
        this.useStencil = useStencil;
        this.listeners = new CopyOnWriteArrayList<GLSimpleFboListenerEntry>();
        this.lock = new ReentrantLock();
    }

    public void resize(int width, int height) {
        this.initialized = false;
        this.width = width;
        this.height = height;
    }

    public Object glSyncExec(final GLRunnable runnable) {
        this.context.makeCurrent();
        Object result = new GLRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run(GLContext context) {
                GLSimpleFrameBufferObject.this.lock.lock();
                try {
                    Object object;
                    GLSimpleFrameBufferObject.this.bind(context);
                    try {
                        object = runnable.run(context);
                    }
                    catch (Throwable throwable) {
                        context.getGL().glFlush();
                        GLSimpleFrameBufferObject.this.unbind(context);
                        throw throwable;
                    }
                    context.getGL().glFlush();
                    GLSimpleFrameBufferObject.this.unbind(context);
                    return object;
                }
                finally {
                    GLSimpleFrameBufferObject.this.lock.unlock();
                }
            }
        }.run(this.context);
        this.context.release();
        return result;
    }

    public void draw() {
        final Rectangle bounds = this.getBounds();
        final ArrayList<GLSimpleFboListenerEntry> entries = new ArrayList<GLSimpleFboListenerEntry>(this.listeners);
        this.glSyncExec(new GLRunnable(){

            @Override
            public Object run(GLContext context) {
                for (GLSimpleFboListenerEntry l : entries) {
                    l.draw(context, bounds);
                }
                return null;
            }
        });
    }

    public void bind(GLContext context) {
        GL gl = context.getGL();
        if (!this.initialized) {
            int status;
            if (this.textureId != null) {
                gl.glDeleteTextures(1, this.textureId, 0);
            }
            int[] maxTextureSize = new int[1];
            gl.glGetIntegerv(3379, maxTextureSize, 0);
            if (maxTextureSize[0] < this.width || maxTextureSize[0] < this.height) {
                LoggerUtils.logWarning((Logger)logger, (String)"Texture (%dx%d) has dimensions larger than maximum supported (%d)", (Object[])new Object[]{this.width, this.height, maxTextureSize[0]});
            }
            this.textureId = new int[1];
            gl.glGenTextures(1, this.textureId, 0);
            gl.glBindTexture(3553, this.textureId[0]);
            gl.glTexParameterf(3553, 10240, 9729.0f);
            gl.glTexParameterf(3553, 10241, 9987.0f);
            gl.glTexParameterf(3553, 10242, 33071.0f);
            gl.glTexParameterf(3553, 10243, 33071.0f);
            gl.glTexParameteri(3553, 33169, 1);
            gl.glTexImage2D(3553, 0, 6408, this.width, this.height, 0, 6408, 5126, null);
            gl.glBindTexture(3553, 0);
            if (this.renderBufferId != null) {
                gl.glDeleteRenderbuffersEXT(2, this.renderBufferId, 0);
            }
            this.renderBufferId = new int[2];
            if (this.useDepth || this.useStencil) {
                gl.glGenRenderbuffersEXT(2, this.renderBufferId, 0);
            }
            if (this.useDepth) {
                gl.glBindRenderbufferEXT(36161, this.renderBufferId[0]);
                gl.glRenderbufferStorageEXT(36161, 6402, this.width, this.height);
            }
            if (this.useStencil) {
                gl.glBindRenderbufferEXT(36161, this.renderBufferId[1]);
                gl.glRenderbufferStorageEXT(36161, 36169, this.width, this.height);
            }
            gl.glBindRenderbufferEXT(36161, 0);
            if (this.frameBufferId != null) {
                gl.glDeleteFramebuffersEXT(1, this.frameBufferId, 0);
            }
            this.frameBufferId = new int[1];
            gl.glGenFramebuffersEXT(1, this.frameBufferId, 0);
            gl.glBindFramebufferEXT(36160, this.frameBufferId[0]);
            gl.glFramebufferTexture2DEXT(36160, 36064, 3553, this.textureId[0], 0);
            if (this.useDepth) {
                gl.glFramebufferRenderbufferEXT(36160, 36096, 36161, this.renderBufferId[0]);
            }
            if (this.useStencil) {
                gl.glFramebufferRenderbufferEXT(36160, 36128, 36161, this.renderBufferId[1]);
            }
            if ((status = gl.glCheckFramebufferStatusEXT(36160)) != 36053) {
                LoggerUtils.logWarning((Logger)logger, (String)"Framebuffer not initialized (status=%d)", (Object[])new Object[]{status});
            }
            this.initialized = true;
        } else {
            gl.glBindFramebufferEXT(36160, this.frameBufferId[0]);
        }
    }

    public void unbind(GLContext context) {
        GL gl = context.getGL();
        gl.glBindFramebufferEXT(36160, 0);
        gl.glBindTexture(3553, this.textureId[0]);
        gl.glGenerateMipmapEXT(3553);
        gl.glBindTexture(3553, 0);
    }

    public void addListener(GLSimpleListener listener) {
        this.listeners.add(new GLSimpleFboListenerEntry(listener));
    }

    public Dimension getDimension() {
        return new Dimension(this.width, this.height);
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    public GLContext getGLContext() {
        return this.context;
    }

    public int getTextureId() {
        return this.textureId[0];
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Texture getOpenGLTexture() {
        return TextureIO.newTexture((int)this.textureId[0]);
    }

    public TextureProjected2D getGlimpseTexture() {
        return new ExternalTextureProjected2D(this.getTextureId(), this.width, this.height, false);
    }

    public void dispose(GLContext context) {
        GL gl = context.getGL();
        for (GLSimpleFboListenerEntry entry : this.listeners) {
            entry.dispose(context);
        }
        if (this.textureId != null) {
            gl.glDeleteTextures(1, this.textureId, 0);
        }
        if (this.renderBufferId != null) {
            gl.glDeleteRenderbuffersEXT(2, this.renderBufferId, 0);
        }
        if (this.frameBufferId != null) {
            gl.glDeleteFramebuffersEXT(1, this.frameBufferId, 0);
        }
    }
}

