/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.event.touch;

import com.metsci.glimpse.axis.Axis1D;
import com.metsci.glimpse.axis.Axis2D;
import com.metsci.glimpse.context.GlimpseTarget;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.layout.GlimpseAxisLayout1D;
import com.metsci.glimpse.layout.GlimpseAxisLayout2D;

public class GlimpseTouchEvent {
    protected String source;
    protected GlimpseTargetStack stack;
    protected int x;
    protected int y;
    protected int xPrev;
    protected int yPrev;
    protected int tapCount;
    protected int timestamp;
    protected int phase;

    public GlimpseTouchEvent(String source, GlimpseTargetStack stack, int x, int y, int xPrev, int yPrev, int tapCount, int timestamp, int phase) {
        this.source = source;
        this.stack = stack;
        this.x = x;
        this.y = y;
        this.xPrev = xPrev;
        this.yPrev = yPrev;
        this.tapCount = tapCount;
        this.timestamp = timestamp;
        this.phase = phase;
    }

    public String getSource() {
        return this.source;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getXPrev() {
        return this.xPrev;
    }

    public int getYPrev() {
        return this.yPrev;
    }

    public int getTapCount() {
        return this.tapCount;
    }

    public int getTimestamp() {
        return this.timestamp;
    }

    public int getPhase() {
        return this.phase;
    }

    public GlimpseTargetStack getTargetStack() {
        return this.stack;
    }

    public Axis1D getAxis1D() {
        GlimpseTargetStack stack = this.getTargetStack();
        GlimpseTarget target = stack.getTarget();
        if (target instanceof GlimpseAxisLayout1D) {
            GlimpseAxisLayout1D layout = (GlimpseAxisLayout1D)target;
            return layout.getAxis(stack);
        }
        return null;
    }

    public Axis2D getAxis2D() {
        GlimpseTargetStack stack = this.getTargetStack();
        GlimpseTarget target = stack.getTarget();
        if (target instanceof GlimpseAxisLayout2D) {
            GlimpseAxisLayout2D layout = (GlimpseAxisLayout2D)target;
            return layout.getAxis(stack);
        }
        return null;
    }

    public String toString() {
        return String.format("x: %d y: %d", this.x, this.y);
    }
}

