/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.event.mouse.swing;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseBounds;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.MouseWrapperImpl;
import com.metsci.glimpse.event.mouse.swing.GlimpseMouseWrapper;
import com.metsci.glimpse.event.mouse.swing.GlimpseSwingMouseEvent;
import com.metsci.glimpse.event.mouse.swing.GlimpseSwingMouseWheelEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

public class MouseWrapperSwing
extends MouseWrapperImpl<MouseEvent>
implements MouseWheelListener,
MouseMotionListener,
MouseListener {
    public static final int ANY_BUTTON_DOWN_MASK = 7168;

    public MouseWrapperSwing(GlimpseCanvas canvas) {
        super(canvas);
    }

    @Override
    protected boolean isInterior(MouseEvent e, GlimpseBounds bounds) {
        return bounds.contains(e.getX(), e.getComponent().getBounds().height - e.getY());
    }

    @Override
    protected boolean isButtonDown(MouseEvent e) {
        return (e.getModifiersEx() & 0x1C00) > 0;
    }

    @Override
    protected boolean isValid(MouseEvent e, GlimpseBounds bounds) {
        return e.getComponent() != null;
    }

    @Override
    protected MouseEvent toLocalCoords(MouseEvent e, GlimpseTargetStack stack) {
        if (stack == null) {
            return null;
        }
        GlimpseBounds bounds = stack.getBounds();
        if (bounds == null) {
            return null;
        }
        if (e.getComponent() == null) {
            return null;
        }
        int parentHeight = e.getComponent().getBounds().height;
        Component source = e.getComponent();
        int id = e.getID();
        long when = e.getWhen();
        int modifiers = e.getModifiers();
        int local_x = e.getX() - bounds.getX();
        int local_y = e.getY() - (parentHeight - (bounds.getY() + bounds.getHeight()));
        int clickCount = e.getClickCount();
        boolean popupTrigger = e.isPopupTrigger();
        int button = e.getButton();
        GlimpseSwingMouseEvent localEvent = new GlimpseSwingMouseEvent(stack, source, id, when, modifiers, local_x, local_y, clickCount, popupTrigger, button);
        return localEvent;
    }

    @Override
    protected GlimpseMouseEvent toGlimpseEvent(MouseEvent e) {
        return GlimpseMouseWrapper.fromMouseEvent(e);
    }

    @Override
    protected GlimpseMouseEvent toLocalGlimpseEvent(MouseEvent e, GlimpseTargetStack stack) {
        if (e instanceof MouseWheelEvent) {
            return GlimpseMouseWrapper.fromMouseWheelEvent(this.toLocalCoords((MouseWheelEvent)e, stack));
        }
        return super.toLocalGlimpseEvent(e, stack);
    }

    @Override
    protected MouseWheelEvent toLocalCoords(MouseWheelEvent e, GlimpseTargetStack stack) {
        if (stack == null) {
            return null;
        }
        GlimpseBounds bounds = stack.getBounds();
        if (bounds == null) {
            return null;
        }
        if (e.getComponent() == null) {
            return null;
        }
        int parentHeight = e.getComponent().getBounds().height;
        Component source = e.getComponent();
        int id = e.getID();
        long when = e.getWhen();
        int modifiers = e.getModifiers();
        int local_x = e.getX() - bounds.getX();
        int local_y = e.getY() - (parentHeight - (bounds.getY() + bounds.getHeight()));
        int clickCount = e.getClickCount();
        boolean popupTrigger = e.isPopupTrigger();
        int scrollType = e.getScrollType();
        int scrollAmount = e.getScrollAmount();
        int wheelRotation = e.getWheelRotation();
        GlimpseSwingMouseWheelEvent localEvent = new GlimpseSwingMouseWheelEvent(stack, source, id, when, modifiers, local_x, local_y, clickCount, popupTrigger, scrollType, scrollAmount, wheelRotation);
        return localEvent;
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        this.mouseWheelMoved0(e);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.mouseClicked0(e);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mousePressed0(e);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouseReleased0(e);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.mouseEntered0(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.mouseExited0(e);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDragged0(e);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.mouseMoved0(e);
    }
}

