/*
 * Decompiled with CFR 0.152.
 */
package com.metsci.glimpse.event.mouse;

import com.metsci.glimpse.canvas.GlimpseCanvas;
import com.metsci.glimpse.context.GlimpseTargetStack;
import com.metsci.glimpse.event.mouse.GlimpseMouseEvent;
import com.metsci.glimpse.event.mouse.MouseWrapper;
import com.metsci.glimpse.event.mouse.Mouseable;
import java.util.List;

public abstract class MouseWrapperImpl<E>
extends MouseWrapper<E> {
    public MouseWrapperImpl(GlimpseCanvas canvas) {
        super(canvas);
    }

    public void mouseClicked0(E event) {
    }

    public void mouseEntered0(E event) {
        if (event == null) {
            return;
        }
        List<GlimpseTargetStack> oldHovered = this.clearHovered();
        this.getContainingTargets(event);
        List<GlimpseTargetStack> newHovered = this.getHovered();
        this.notifyMouseEnteredExited(event, oldHovered, newHovered);
    }

    public void mouseExited0(E event) {
        if (event == null) {
            return;
        }
        List<GlimpseTargetStack> oldHovered = this.clearHovered();
        this.getContainingTargets(event);
        List<GlimpseTargetStack> newHovered = this.getHovered();
        this.notifyMouseEnteredExited(event, oldHovered, newHovered);
    }

    public boolean mousePressed0(E event) {
        if (event == null) {
            return false;
        }
        List<GlimpseTargetStack> list = this.getContainingTargets(event);
        this.setAllHovered(list);
        for (GlimpseTargetStack stack : list) {
            Mouseable mouseTarget = this.getMouseTarget(stack);
            if (mouseTarget == null) {
                return false;
            }
            GlimpseMouseEvent glimpseEvent = this.toLocalGlimpseEvent(event, stack);
            mouseTarget.mousePressed(glimpseEvent);
            if (!glimpseEvent.isHandled()) continue;
            return true;
        }
        return false;
    }

    public boolean mouseReleased0(E event) {
        if (event == null) {
            return false;
        }
        boolean handled = false;
        if (this.isDragHovered()) {
            List<GlimpseTargetStack> hoveredList = this.getDragHovered();
            for (GlimpseTargetStack hoveredStack : hoveredList) {
                Mouseable mouseTarget = this.getMouseTarget(hoveredStack);
                GlimpseMouseEvent glimpseEvent = this.toLocalGlimpseEvent(event, hoveredStack);
                if (mouseTarget != null) {
                    mouseTarget.mouseReleased(glimpseEvent);
                }
                if (!glimpseEvent.isHandled()) continue;
                handled = true;
                break;
            }
        }
        this.getContainingTargets(event);
        return handled;
    }

    public boolean mouseDragged0(E event) {
        if (event == null) {
            return false;
        }
        List<GlimpseTargetStack> oldHovered = this.clearHovered();
        this.getContainingTargets(event);
        List<GlimpseTargetStack> newHovered = this.getHovered();
        this.notifyMouseEnteredExited(event, oldHovered, newHovered);
        if (this.isDragHovered()) {
            List<GlimpseTargetStack> hoveredList = this.getDragHovered();
            for (GlimpseTargetStack hoveredStack : hoveredList) {
                Mouseable mouseHoveredTarget = this.getMouseTarget(hoveredStack);
                GlimpseMouseEvent glimpseHoveredEvent = this.toLocalGlimpseEvent(event, hoveredStack);
                if (mouseHoveredTarget != null) {
                    mouseHoveredTarget.mouseMoved(glimpseHoveredEvent);
                }
                if (!glimpseHoveredEvent.isHandled()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean mouseMoved0(E event) {
        if (event == null) {
            return false;
        }
        List<GlimpseTargetStack> oldHovered = this.clearAllHovered();
        this.getContainingTargets(event);
        List<GlimpseTargetStack> newHovered = this.getHovered();
        this.notifyMouseEnteredExited(event, oldHovered, newHovered);
        if (this.isDragHovered()) {
            for (GlimpseTargetStack hoveredStack : newHovered) {
                Mouseable mouseHoveredTarget = this.getMouseTarget(hoveredStack);
                GlimpseMouseEvent glimpseHoveredEvent = this.toLocalGlimpseEvent(event, hoveredStack);
                if (mouseHoveredTarget != null) {
                    mouseHoveredTarget.mouseMoved(glimpseHoveredEvent);
                }
                if (!glimpseHoveredEvent.isHandled()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean mouseWheelMoved0(E event) {
        if (event == null) {
            return false;
        }
        for (GlimpseTargetStack stack : this.getContainingTargets(event)) {
            Mouseable mouseTarget = this.getMouseTarget(stack);
            if (mouseTarget == null) {
                return false;
            }
            GlimpseMouseEvent glimpseEvent = this.toLocalGlimpseEvent(event, stack);
            mouseTarget.mouseWheelMoved(glimpseEvent);
            if (!glimpseEvent.isHandled()) continue;
            return true;
        }
        return false;
    }
}

